/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.repository.connector.update.pages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.polarsys.reqcycle.impact.Impact.ImpactAnalysis;
import org.polarsys.reqcycle.impact.ui.dialogs.ImpactAnalysisComposites;
import org.polarsys.reqcycle.repository.data.RequirementSourceConf.RequirementSource;

public class DialogImpactAnalysis
extends TitleAreaDialog {
    ImpactAnalysisComposites impactComposites;
    ImpactAnalysis analysis;
    private Table tableReqSources;
    Map<RequirementSource, String> inputReqSourcesMap;
    Map<RequirementSource, ImpactAnalysis> reqSourceWithImpAnalysis;
    private Map<RequirementSource, ImpactAnalysis> finalMapReqSourcesWithImpactAna;
    final String suffixName = "_impact_analysis.xmi";
    CheckboxTableViewer cbReqSourceTv;
    List<String> selections;

    public DialogImpactAnalysis(Shell parentShell, Map<RequirementSource, String> inputReqMap) {
        super(parentShell);
        this.setShellStyle(1264);
        this.impactComposites = new ImpactAnalysisComposites();
        this.inputReqSourcesMap = inputReqMap;
        this.reqSourceWithImpAnalysis = new HashMap<RequirementSource, ImpactAnalysis>();
        this.finalMapReqSourcesWithImpactAna = new HashMap<RequirementSource, ImpactAnalysis>();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Finalization of the update");
    }

    public void create() {
        super.create();
        this.setTitle("Requirements sources updating");
        this.setMessage("Select requirements sources and click OK to complete the update");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        composite.setLayout((Layout)new GridLayout(1, false));
        this.cbReqSourceTv = CheckboxTableViewer.newCheckList((Composite)composite, (int)67584);
        this.tableReqSources = this.cbReqSourceTv.getTable();
        GridData gd_tableReqSources = new GridData(4, 128, true, false, 1, 1);
        gd_tableReqSources.heightHint = 92;
        this.tableReqSources.setLayoutData((Object)gd_tableReqSources);
        this.cbReqSourceTv.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.cbReqSourceTv.setLabelProvider((IBaseLabelProvider)new TableLabelProvider(this){

            public String getText(Object element) {
                if (element instanceof RequirementSource) {
                    return ((RequirementSource)element).getName();
                }
                return super.getText(element);
            }
        });
        this.cbReqSourceTv.setInput(this.inputReqSourcesMap.keySet());
        this.cbReqSourceTv.setAllChecked(true);
        this.cbReqSourceTv.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object obj;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) != null && obj instanceof RequirementSource) {
                    for (Map.Entry<RequirementSource, ImpactAnalysis> rsImpAna : DialogImpactAnalysis.this.reqSourceWithImpAnalysis.entrySet()) {
                        if (!rsImpAna.getKey().getName().equals(((RequirementSource)obj).getName())) continue;
                        ImpactAnalysis impactAnalysis = rsImpAna.getValue();
                        DialogImpactAnalysis.this.impactComposites.setImpactResult(impactAnalysis.getRequirementsAdded(), impactAnalysis.getRequirementsDeleted(), impactAnalysis.getRequirementsModified());
                    }
                }
            }
        });
        this.cbReqSourceTv.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                DialogImpactAnalysis.this.getSelectedElements();
            }
        });
        this.selections = new ArrayList<String>();
        this.getSelectedElements();
        Composite impactComposite = new Composite(composite, 2048);
        impactComposite.setLayout((Layout)new GridLayout());
        impactComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.impactComposites.createImpactComposite(impactComposite);
        Button btnSaveAnalysis = new Button(impactComposite, 0);
        btnSaveAnalysis.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] result;
                ContainerSelectionDialog dialog = new ContainerSelectionDialog(DialogImpactAnalysis.this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), true, "select location for save");
                IPath path = null;
                if (dialog.open() == 0 && (result = dialog.getResult()) != null && result.length > 0 && result[0] instanceof IPath) {
                    path = (IPath)result[0];
                }
                if (path != null) {
                    DialogImpactAnalysis.this.finalMapReqSourcesWithImpactAna.clear();
                    DialogImpactAnalysis.this.finalMapReqSourcesWithImpactAna = DialogImpactAnalysis.this.getSelectedRequirementSrc(DialogImpactAnalysis.this.selections, DialogImpactAnalysis.this.reqSourceWithImpAnalysis);
                    for (Map.Entry finalMap : DialogImpactAnalysis.this.finalMapReqSourcesWithImpactAna.entrySet()) {
                        String fileName = "/" + ((RequirementSource)finalMap.getKey()).getName() + "_impact_analysis.xmi";
                        URI destinationPath = URI.createPlatformResourceURI((String)(String.valueOf(path.toString()) + fileName), (boolean)true);
                        ((ImpactAnalysis)finalMap.getValue()).saveAnalysis(destinationPath);
                    }
                }
            }
        });
        btnSaveAnalysis.setToolTipText("");
        btnSaveAnalysis.setAlignment(131072);
        btnSaveAnalysis.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
        btnSaveAnalysis.setText("Save impacts analysis");
        return composite;
    }

    private void getSelectedElements() {
        Object[] listSlectReq;
        this.selections.clear();
        Object[] objectArray = listSlectReq = this.cbReqSourceTv.getCheckedElements();
        int n = listSlectReq.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            this.selections.add(((RequirementSource)obj).getName());
            ++n2;
        }
    }

    public ImpactAnalysisComposites getImpactComposites() {
        return this.impactComposites;
    }

    public void setImpactComposites(ImpactAnalysisComposites impactComposites) {
        this.impactComposites = impactComposites;
    }

    public ImpactAnalysis getAnalysis() {
        return this.analysis;
    }

    public void setAnalysis(ImpactAnalysis analysis) {
        this.analysis = analysis;
    }

    public Map<RequirementSource, ImpactAnalysis> getReqSourceWithImpAnalysis() {
        return this.reqSourceWithImpAnalysis;
    }

    public void setReqSourceWithImpAnalysis(Map<RequirementSource, ImpactAnalysis> reqSourceWithImpAnalysis) {
        this.reqSourceWithImpAnalysis = reqSourceWithImpAnalysis;
    }

    public Map<RequirementSource, ImpactAnalysis> getFinalMapReqSourcesWithImpactAna() {
        return this.finalMapReqSourcesWithImpactAna;
    }

    public void setFinalMapReqSourcesWithImpactAna(Map<RequirementSource, ImpactAnalysis> finalMapReqSourcesWithImpactAna) {
        this.finalMapReqSourcesWithImpactAna = finalMapReqSourcesWithImpactAna;
    }

    protected void okPressed() {
        super.okPressed();
        this.finalMapReqSourcesWithImpactAna.clear();
        this.finalMapReqSourcesWithImpactAna = this.getSelectedRequirementSrc(this.selections, this.reqSourceWithImpAnalysis);
    }

    private Map<RequirementSource, ImpactAnalysis> getSelectedRequirementSrc(List<String> selectItems, Map<RequirementSource, ImpactAnalysis> reqSrcImpacts) {
        HashMap<RequirementSource, ImpactAnalysis> finalMap = new HashMap<RequirementSource, ImpactAnalysis>();
        if (selectItems != null) {
            for (Map.Entry<RequirementSource, ImpactAnalysis> mapFinal : reqSrcImpacts.entrySet()) {
                if (!selectItems.contains(mapFinal.getKey().getName())) continue;
                finalMap.put(mapFinal.getKey(), mapFinal.getValue());
            }
        }
        return finalMap;
    }

    private static class ContentProvider
    implements IStructuredContentProvider {
        private ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return element.toString();
        }
    }
}

