/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.cache.emfbased;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.reqcycle.core.ILogger;
import org.polarsys.reqcycle.traceability.cache.AbstractCachedTraceabilityEngine;
import org.polarsys.reqcycle.traceability.cache.Activator;
import org.polarsys.reqcycle.traceability.cache.emfbased.functions.TraceabilityLink2Link;
import org.polarsys.reqcycle.traceability.cache.emfbased.functions.Traceable2TraceableElement;
import org.polarsys.reqcycle.traceability.cache.emfbased.functions.TraceableElement2Traceable;
import org.polarsys.reqcycle.traceability.cache.emfbased.model.CacheTracability.AnalyzedResource;
import org.polarsys.reqcycle.traceability.cache.emfbased.model.CacheTracability.CacheTracabilityFactory;
import org.polarsys.reqcycle.traceability.cache.emfbased.model.CacheTracability.Model;
import org.polarsys.reqcycle.traceability.cache.emfbased.model.CacheTracability.TraceabilityLink;
import org.polarsys.reqcycle.traceability.cache.emfbased.model.CacheTracability.TraceableElement;
import org.polarsys.reqcycle.traceability.cache.emfbased.pickers.TraceableElementPicker;
import org.polarsys.reqcycle.traceability.cache.emfbased.predicates.TraceabilityLinkPredicate;
import org.polarsys.reqcycle.traceability.engine.ITraceabilityEngine;
import org.polarsys.reqcycle.traceability.model.Link;
import org.polarsys.reqcycle.traceability.model.Pair;
import org.polarsys.reqcycle.traceability.model.StopCondition;
import org.polarsys.reqcycle.traceability.model.TType;
import org.polarsys.reqcycle.traceability.model.scopes.ResourceScope;
import org.polarsys.reqcycle.uri.exceptions.IReachableHandlerException;
import org.polarsys.reqcycle.uri.model.IReachableHandler;
import org.polarsys.reqcycle.uri.model.Reachable;
import org.polarsys.reqcycle.uri.model.ReachableObject;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;
import org.polarsys.reqcycle.utils.iterators.exceptions.PickerExecutionException;
import org.polarsys.reqcycle.utils.iterators.factories.IteratorFactory;
import org.polarsys.reqcycle.utils.iterators.pickers.IPicker;

@Singleton
public class CacheTraceabilityEngine
extends AbstractCachedTraceabilityEngine {
    ResourceSet set;
    private Resource resource;
    public static String CACHE_RESOURCE_NAME = "traceability.ctr";
    @Inject
    ILogger logger;
    private Model theModel;

    @Inject
    public CacheTraceabilityEngine() {
    }

    @PostConstruct
    public void postConstruct() {
        this.set = new ResourceSetImpl();
        String pathName = String.valueOf(this.getCachePath()) + "/" + CACHE_RESOURCE_NAME;
        if (this.logger.isDebug("org.polarsys.reqcycle.traceability.cache/debug", (Plugin)Activator.getDefault())) {
            this.logger.trace(String.format("cached database loading : %s", pathName));
        }
        URI uri = URI.createFileURI((String)pathName);
        if (!new File(pathName).exists()) {
            if (this.logger.isDebug("org.polarsys.reqcycle.traceability.cache/debug", (Plugin)Activator.getDefault())) {
                this.logger.trace("Caching resource for traceability creation");
            }
            this.resource = this.set.createResource(uri);
            Model m = CacheTracabilityFactory.eINSTANCE.createModel();
            this.resource.getContents().add((Object)m);
        } else {
            this.resource = this.set.getResource(uri, true);
        }
        if (this.resource != null) {
            this.resource.getContents().isEmpty();
        }
        this.theModel = (Model)this.resource.getContents().get(0);
        if (this.logger.isDebug("org.polarsys.reqcycle.traceability.cache/debug", (Plugin)Activator.getDefault())) {
            this.logger.trace("cached database loaded ");
        }
    }

    protected void environmentClosed() {
        if (this.resource != null) {
            boolean debug = this.logger.isDebug("org.polarsys.reqcycle.traceability.cache/debug", (Plugin)Activator.getDefault());
            if (debug) {
                this.logger.trace("Resource cache Closing");
            }
            try {
                this.resource.save(Collections.emptyMap());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (debug) {
                this.logger.trace("Resource cache Closed");
            }
        }
    }

    protected boolean isCacheOk(Reachable traceable) {
        String uri = ResourceScope.getURIPath((Reachable)traceable.trimFragment());
        for (AnalyzedResource a : this.theModel.getResources()) {
            if (!uri.equals(a.getUri())) continue;
            try {
                String revisionIdentification;
                IReachableHandler handler = this.manager.getHandlerFromReachable(traceable);
                ReachableObject object = handler.getFromReachable(traceable);
                if (object == null || (revisionIdentification = object.getRevisionIdentification()) == null) continue;
                return Objects.equal((Object)revisionIdentification, (Object)a.getModificationTime());
            }
            catch (IReachableHandlerException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public void newUpwardRelation(Reachable traceable, Reachable container, Reachable source, List<Reachable> targets, TType kind) {
        Traceable2TraceableElement traceable2TraceableElement = new Traceable2TraceableElement(this.theModel);
        ZigguratInject.inject((Object[])new Object[]{traceable2TraceableElement});
        TraceableElement sourceElement = traceable2TraceableElement.apply(source);
        Iterable targetElements = Iterables.transform(targets, (Function)traceable2TraceableElement);
        TraceabilityLink link = this.getTraceabilityLink(container, sourceElement, targetElements, kind.getSemantic());
        if (link == null) {
            AnalyzedResource r = this.getOrCreateAnalyzedResource(container);
            link = CacheTracabilityFactory.eINSTANCE.createTraceabilityLink();
            link.setLabel(kind.getSemantic());
            ArrayList sourcesToAdd = Lists.newArrayList((Object[])new TraceableElement[]{sourceElement});
            link.getSources().addAll((Collection)sourcesToAdd);
            ArrayList targetsToAdd = Lists.newArrayList((Iterable)targetElements);
            link.getTargets().addAll((Collection)targetsToAdd);
            r.getLinks().add((Object)link);
        }
    }

    private TraceabilityLink getTraceabilityLink(Reachable container, TraceableElement sourceElements, Iterable<TraceableElement> targetElements, String label) {
        TraceabilityLink result = null;
        AnalyzedResource analy = this.getResource(container);
        if (analy != null) {
            TraceabilityLink t;
            result = t = (TraceabilityLink)Iterables.find(analy.getLinks(), (Predicate)new TraceabilityLinkPredicate(sourceElements, targetElements, label), null);
        }
        return result;
    }

    public Iterable<Link> getLinksForTraceable(Reachable traceable) {
        AnalyzedResource r = this.getResource(traceable);
        if (r != null) {
            EList<TraceabilityLink> links = r.getLinks();
            Iterable result = Iterables.transform(links, (Function)new TraceabilityLink2Link());
            return result;
        }
        return Lists.newArrayList();
    }

    private AnalyzedResource getOrCreateAnalyzedResource(Reachable traceable) {
        AnalyzedResource r = this.getResource(traceable);
        if (r == null) {
            r = CacheTracabilityFactory.eINSTANCE.createAnalyzedResource();
            this.theModel.getResources().add((Object)r);
            String traceablePath = traceable.trimFragment().toString();
            r.setUri(traceablePath);
            IReachableHandler uriHandler = null;
            try {
                uriHandler = this.manager.getHandlerFromReachable(traceable);
                ReachableObject object = uriHandler.getFromReachable(traceable);
                if (object != null) {
                    r.setModificationTime(object.getRevisionIdentification());
                }
            }
            catch (IReachableHandlerException e) {
                e.printStackTrace();
            }
        }
        return r;
    }

    private AnalyzedResource getResource(final Reachable traceable) {
        return (AnalyzedResource)Iterables.find(this.theModel.getResources(), (Predicate)new Predicate<AnalyzedResource>(){

            public boolean apply(AnalyzedResource a) {
                return a.getUri().equals(traceable.trimFragment().toString());
            }
        }, null);
    }

    protected void tagDeletedRelationShips(Iterable<Link> linksToTag) {
    }

    protected Iterator<Pair<Link, Reachable>> doGetTraceability(Reachable source, ITraceabilityEngine.DIRECTION direction, Predicate<Pair<Link, Reachable>> scope) {
        TraceableElement s = this.getTraceableElement(source);
        if (s != null) {
            IPicker picker = this.getPicker(direction, scope);
            List<IPicker> pickers = Arrays.asList(picker);
            IteratorFactory f = new IteratorFactory(pickers);
            f.activateWidthWisdom();
            f.activateRedundancyAwareness();
            Iterable iterable = f.createIterable((Object)s);
            Iterator i = iterable.iterator();
            i.next();
            return Lists.newArrayList((Iterator)Iterators.transform(i, (Function)new Function<Object, Pair<Link, Reachable>>(){

                public Pair<Link, Reachable> apply(Object o) {
                    return (Pair)o;
                }
            })).iterator();
        }
        return Iterators.emptyIterator();
    }

    protected Iterator<Pair<Link, Reachable>> doGetOneLevelTraceability(Reachable source, ITraceabilityEngine.DIRECTION direction, Predicate<Pair<Link, Reachable>> scope) {
        TraceableElement s = this.getTraceableElement(source);
        if (s != null) {
            IPicker picker = this.getPicker(direction, scope);
            try {
                new ArrayList();
                Iterable elements = picker.getNexts((Object)source);
                return Lists.newArrayList((Iterable)Iterables.transform((Iterable)elements, (Function)new Function<Object, Pair<Link, Reachable>>(){

                    public Pair<Link, Reachable> apply(Object o) {
                        return (Pair)o;
                    }
                })).iterator();
            }
            catch (PickerExecutionException e) {
                e.printStackTrace();
            }
        }
        return Iterators.emptyIterator();
    }

    protected Iterator<Pair<Link, Reachable>> doGetTraceability(Reachable source, StopCondition t, ITraceabilityEngine.DIRECTION direction, Predicate<Pair<Link, Reachable>> scope) {
        ArrayDeque<Pair<Link, Reachable>> result = new ArrayDeque<Pair<Link, Reachable>>();
        ArrayDeque<Pair<Link, Reachable>> current = new ArrayDeque<Pair<Link, Reachable>>();
        TraceableElement s = this.getTraceableElement(source);
        if (s != null && t != null) {
            IPicker picker = this.getPicker(direction, scope);
            List<IPicker> pickers = Arrays.asList(picker);
            IteratorFactory f = new IteratorFactory(pickers);
            f.activateWidthWisdom();
            f.activateRedundancyAwareness();
            Iterable iterable = f.createIterable((Object)s);
            Iterator<Object> i = iterable.iterator();
            if (this.checkPath((TraceableElement)i.next(), t, i, result, current)) {
                result.addAll(current);
            }
        }
        return result.iterator();
    }

    private IPicker getPicker(ITraceabilityEngine.DIRECTION direction, Predicate<Pair<Link, Reachable>> scope) {
        TraceableElementPicker traceableElementPicker = new TraceableElementPicker(direction, this.theModel, scope);
        ZigguratInject.inject((Object[])new Object[]{traceableElementPicker});
        return traceableElementPicker;
    }

    private boolean checkPath(TraceableElement te, StopCondition condition, Iterator<Object> i, ArrayDeque<Pair<Link, Reachable>> result, ArrayDeque<Pair<Link, Reachable>> current) {
        boolean found = false;
        TraceableElement2Traceable traceableElement2Traceable = new TraceableElement2Traceable();
        ZigguratInject.inject((Object[])new Object[]{traceableElement2Traceable});
        Reachable source = traceableElement2Traceable.apply(te);
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof Pair)) continue;
            Pair pair = (Pair)o;
            Reachable secondReachable = (Reachable)pair.getSecond();
            Pair pair2 = new Pair((Object)((Link)pair.getFirst()), (Object)secondReachable);
            if (condition.apply(pair2)) {
                current.add((Pair<Link, Reachable>)pair);
                found = true;
                break;
            }
            if (!((Link)pair.getFirst()).getSources().contains(source)) {
                if (!this.checkPath(new Traceable2TraceableElement(this.theModel).apply((Reachable)((Link)pair.getFirst()).getSources().iterator().next()), condition, i, result, current)) continue;
                result.addAll(current);
                continue;
            }
            current.add((Pair<Link, Reachable>)pair);
            if (!condition.apply(pair2)) continue;
            found = true;
            break;
        }
        return found;
    }

    private TraceableElement getTraceableElement(Reachable source) {
        return new Traceable2TraceableElement(this.theModel).apply(source);
    }

    protected void removeTraceabilityLink(Reachable traceable) {
        AnalyzedResource a = this.getResource(traceable);
        if (a != null) {
            for (TraceabilityLink l : a.getLinks()) {
                this.deleteNodesIfCorrespondingToTraceable(traceable, (Iterable<TraceableElement>)l.getSources());
                this.deleteNodesIfCorrespondingToTraceable(traceable, (Iterable<TraceableElement>)l.getTargets());
                EcoreUtil.delete((EObject)l);
            }
        }
    }

    private void deleteNodesIfCorrespondingToTraceable(Reachable traceable, Iterable<TraceableElement> collection) {
        TraceableElement2Traceable function = new TraceableElement2Traceable();
        ZigguratInject.inject((Object[])new Object[]{function});
        for (TraceableElement t : collection) {
            Reachable tr = function.apply(t);
            if (!tr.trimFragment().equals((Object)traceable)) continue;
            EcoreUtil.delete((EObject)t);
        }
    }

    public void startBuild(Reachable reachable) {
        this.getOrCreateAnalyzedResource(reachable);
    }

    protected Iterator<Pair<Link, Reachable>> doGetAllTraceability(ITraceabilityEngine.DIRECTION direction, Predicate<Pair<Link, Reachable>> requestPredicate) {
        return null;
    }

    protected Iterable<Reachable> getEntriesFor(Reachable reachable) {
        return null;
    }
}

