/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.uri.impl;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.polarsys.reqcycle.uri.services.IReachableExtender;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class ExtenderManager {
    private static String EXT_EXTENDER_NAME = "reachableExtender";
    private static List<IReachableExtender> allRegistered = ExtenderManager.getAllRegistered();
    LoadingCache<Pair, Iterable<IReachableExtender>> cache = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Pair, Iterable<IReachableExtender>>(){

        public Iterable<IReachableExtender> load(final Pair pair) throws Exception {
            return Iterables.filter((Iterable)allRegistered, (Predicate)new Predicate<IReachableExtender>(){

                public boolean apply(IReachableExtender ext) {
                    return ext.handles(pair.uri, pair.originalObject);
                }
            });
        }
    });

    public Iterable<IReachableExtender> getExtenders(URI uri, Object originalObject) {
        Pair pair = new Pair();
        pair.uri = uri;
        pair.originalObject = originalObject;
        try {
            return (Iterable)this.cache.get((Object)pair);
        }
        catch (ExecutionException executionException) {
            return Lists.newArrayList();
        }
    }

    private static List<IReachableExtender> getAllRegistered() {
        return Lists.newArrayList((Iterable)Iterables.filter((Iterable)Iterables.transform(Arrays.asList(Platform.getExtensionRegistry().getConfigurationElementsFor("org.polarsys.reqcycle.uri", EXT_EXTENDER_NAME)), (Function)new Function<IConfigurationElement, IReachableExtender>(){

            public IReachableExtender apply(IConfigurationElement conf) {
                IReachableExtender ext = null;
                try {
                    ext = (IReachableExtender)conf.createExecutableExtension("instance");
                    ZigguratInject.inject((Object[])new Object[]{ext});
                }
                catch (CoreException coreException) {}
                return ext;
            }
        }), (Predicate)Predicates.notNull()));
    }

    private class Pair {
        URI uri;
        Object originalObject;

        private Pair() {
        }

        public boolean equals(Object arg0) {
            if (arg0 instanceof Pair) {
                Pair pair = (Pair)arg0;
                return Objects.equal((Object)pair.uri, (Object)this.uri) && Objects.equal((Object)pair.originalObject, (Object)this.originalObject);
            }
            return Objects.equal((Object)arg0, (Object)this);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.originalObject, this.uri});
        }
    }
}

