/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.doc.doc2model.tikaparsing.xls;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.polarsys.kitalpha.doc.doc2model.tikaparsing.xls.CellsGroup;
import org.polarsys.kitalpha.doc.doc2model.tikaparsing.xls.StylizedCell;
import org.polarsys.kitalpha.doc.doc2model.tikaparsing.xls.SubRow;

public class SubRowSimple
implements SubRow {
    private List<CellsGroup> _cellGroups = new ArrayList<CellsGroup>();
    private int _firstColumn = -1;
    private int _rowIndex = -1;

    @Override
    public int getNbColumn() {
        int count = 0;
        for (CellsGroup cg : this._cellGroups) {
            count += cg.getCellsNb();
        }
        return count;
    }

    @Override
    public List<CellsGroup> get_Groups() {
        return this._cellGroups;
    }

    @Override
    public List<StylizedCell> getCells() {
        ArrayList<StylizedCell> retList = new ArrayList<StylizedCell>();
        for (CellsGroup cg : this._cellGroups) {
            retList.addAll(cg.getCells());
        }
        return retList;
    }

    @Override
    public int getElementNb() {
        return this._cellGroups.size();
    }

    @Override
    public int getCellsNb() {
        int sum = 0;
        for (CellsGroup cg : this._cellGroups) {
            sum += cg.getCellsNb();
        }
        return sum;
    }

    @Override
    public void addSubRowCellsGroup(SubRow sb) {
        this._rowIndex = sb.getRowIndex();
        for (CellsGroup cg : sb) {
            this._cellGroups.add(cg);
        }
    }

    @Override
    public void addCellsGroup(CellsGroup cg) {
        if (this._cellGroups.size() == 0) {
            this._rowIndex = cg.getRowIndex();
            this._firstColumn = cg.getFirstColumn();
        }
        this._cellGroups.add(cg);
    }

    @Override
    public int get_firstColumn() {
        return this._firstColumn;
    }

    @Override
    public int get_lastColumn() {
        return this.get_lastGroup().getLastColumn();
    }

    @Override
    public CellsGroup get_lastGroup() {
        return this._cellGroups.get(this._cellGroups.size() - 1);
    }

    public String toString() {
        String str = "";
        for (CellsGroup cg : this._cellGroups) {
            str = String.valueOf(str) + "$" + cg.toString();
        }
        str = String.valueOf(str) + "\n";
        return str;
    }

    @Override
    public boolean isGroupWithin(CellsGroup cellgroup) {
        return this._firstColumn <= cellgroup.getFirstColumn() && this.get_lastColumn() >= cellgroup.getLastColumn();
    }

    @Override
    public int getRowIndex() {
        return this._rowIndex;
    }

    @Override
    public Iterator<CellsGroup> iterator() {
        return this._cellGroups.iterator();
    }

    @Override
    public boolean isSubRowWithin(SubRow subrow) {
        return this._firstColumn <= subrow.get_firstColumn() && this.get_lastColumn() >= subrow.get_lastColumn();
    }

    @Override
    public int[] excess(SubRow subrow) {
        int[] excess = new int[]{this._firstColumn - subrow.get_firstColumn(), subrow.get_lastColumn() - this.get_lastColumn()};
        return excess;
    }

    @Override
    public String getText() {
        String str = "";
        for (CellsGroup cg : this._cellGroups) {
            str = String.valueOf(str) + " " + cg.getText();
        }
        str = String.valueOf(str) + "\n";
        return str;
    }
}

