/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.emf.ui;

import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.polarsys.reqcycle.emf.Activator;
import org.polarsys.reqcycle.emf.utils.EMFUtils;
import org.polarsys.reqcycle.uri.IReachableManager;
import org.polarsys.reqcycle.uri.exceptions.IReachableHandlerException;
import org.polarsys.reqcycle.uri.model.Reachable;
import org.polarsys.reqcycle.uri.model.ReachableObject;
import org.polarsys.reqcycle.uri.services.IReachableExtender;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class EMFEditExtender
implements IReachableExtender {
    private static final String URI_PREFIX = "emf:/";
    private static String EMF_EDIT_LABEL = "emf:/emfEditLabel";
    private static String EMF_EDIT_ECLASS = "emf:/emfEditEclass";
    private static ComposedAdapterFactory factory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    static IReachableManager manager = (IReachableManager)ZigguratInject.make(IReachableManager.class);

    public Map<String, String> getExtendedProperties(java.net.URI uri, Object originalObject) {
        EObject eobj;
        HashMap<String, String> result = new HashMap<String, String>();
        if (originalObject instanceof EObject && !(eobj = (EObject)originalObject).eIsProxy()) {
            AdapterFactoryLabelProvider adapterFactoryLabelProvider = new AdapterFactoryLabelProvider((AdapterFactory)factory);
            String label = adapterFactoryLabelProvider.getText((Object)eobj);
            this.putLabel(result, label);
            this.putImage(result, String.valueOf(eobj.eClass().getEPackage().getNsURI()) + "#" + eobj.eClass().getName());
        }
        return result;
    }

    public void putImage(Map<String, String> result, String image) {
        result.put(EMF_EDIT_ECLASS, image);
    }

    public void putLabel(Map<String, String> result, String label) {
        result.put(EMF_EDIT_LABEL, label);
    }

    public boolean handles(java.net.URI uri, Object object) {
        return EMFUtils.isEMF(uri) && object instanceof EObject && !((EObject)object).eIsProxy();
    }

    public static EObject getEObject(Reachable r) {
        EObject result = null;
        try {
            ReachableObject ro = manager.getHandlerFromReachable(r).getFromReachable(r);
            result = (EObject)ro.getAdapter(EObject.class);
            if (result == null) {
                ResourceSet set = EMFUtils.getFastAndUnresolvingResourceSet();
                URI emfuri = EMFUtils.getEMFURI(r);
                if (EMFUtils.isEMF(emfuri)) {
                    result = set.getEObject(emfuri, true);
                }
            }
        }
        catch (IReachableHandlerException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String getLabel(Reachable r) {
        String result = r.get(EMF_EDIT_LABEL);
        if (result == null) {
            EObject e = EMFEditExtender.getEObject(r);
            try {
                r.putAll(new EMFEditExtender().getExtendedProperties(new java.net.URI(r.toString()), e));
            }
            catch (URISyntaxException e1) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.reqcycle.emf", e1.getMessage(), (Throwable)e1));
            }
            result = r.get(EMF_EDIT_LABEL);
        }
        if (result != null && result.length() > 0) {
            return result;
        }
        return r.toString();
    }

    public static Image getImage(Reachable r) {
        String[] tab;
        String s = r.get(EMF_EDIT_ECLASS);
        if (s == null) {
            EObject e = EMFEditExtender.getEObject(r);
            try {
                r.putAll(new EMFEditExtender().getExtendedProperties(new java.net.URI(r.toString()), e));
            }
            catch (URISyntaxException e1) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.reqcycle.emf", e1.getMessage(), (Throwable)e1));
            }
        }
        if ((s = r.get(EMF_EDIT_ECLASS)) != null && (tab = s.split("#")).length == 2) {
            EClassifier e;
            String epackageURI = tab[0];
            String eclassName = tab[1];
            EPackage ep = EPackage.Registry.INSTANCE.getEPackage(epackageURI);
            if (ep != null && (e = ep.getEClassifier(eclassName)) instanceof EClass) {
                EClass eclass = (EClass)e;
                EObject eobj = ep.getEFactoryInstance().create(eclass);
                AdapterFactoryLabelProvider p = new AdapterFactoryLabelProvider((AdapterFactory)factory);
                return p.getImage((Object)eobj);
            }
        }
        return null;
    }
}

