/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class TType
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, String> metadata = new HashMap<String, String>();
    private TType superType;
    private String label;
    private String id;

    public TType(String id, String label) {
        this.id = id;
        this.label = label;
    }

    public TType(String id, TType superType) {
        this(id, superType.getLabel());
        this.superType = superType;
    }

    public TType(String id, String label, TType superType) {
        this(id, label);
        this.superType = superType;
    }

    public String getLabel() {
        return this.label;
    }

    public TType getSuperType() {
        return this.superType;
    }

    public String getId() {
        return this.id;
    }

    public String getSemantic() {
        if (this.superType != null) {
            return this.superType.getLabel();
        }
        return this.label;
    }

    public boolean is(TType type) {
        if (this.getId().equals(type.getId())) {
            return true;
        }
        return this.superType != null && this.superType.equals(type);
    }

    public boolean isBasic() {
        return this.superType == null;
    }

    public String toString() {
        return this.getLabel();
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TType) {
            TType ttype = (TType)obj;
            return ttype.getId().equals(this.getId());
        }
        return super.equals(obj);
    }
}

