/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.styling.ui.dnd;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;
import org.polarsys.reqcycle.dnd.DropRequirementDelegate;
import org.polarsys.reqcycle.uri.IReachableManager;
import org.polarsys.reqcycle.uri.exceptions.IReachableHandlerException;
import org.polarsys.reqcycle.uri.model.Reachable;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class ReqDropAdapterAssistant
extends CommonDropAdapterAssistant {
    @Inject
    IReachableManager manager;

    public ReqDropAdapterAssistant() {
        ZigguratInject.inject((Object[])new Object[]{this});
    }

    protected void doInit() {
        super.doInit();
    }

    public IStatus validateDrop(Object target, int operation, TransferData transferType) {
        ISelection selection;
        Iterable<Reachable> reachables;
        if (LocalSelectionTransfer.getTransfer().isSupportedType(transferType) && (reachables = this.getReachable(selection = LocalSelectionTransfer.getTransfer().getSelection())).iterator().hasNext()) {
            return Status.OK_STATUS;
        }
        return null;
    }

    private Iterable<Reachable> getReachable(ISelection selection) {
        ArrayList result = Lists.newArrayList();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection strucutred = (IStructuredSelection)selection;
            for (Object next : strucutred) {
                try {
                    Reachable r = this.manager.getHandlerFromObject(next).getFromObject(next).getReachable();
                    result.add(r);
                }
                catch (IReachableHandlerException e) {
                    e.printStackTrace();
                }
            }
        }
        return Iterables.filter((Iterable)result, (Predicate)Predicates.notNull());
    }

    public IStatus handleDrop(CommonDropAdapter aDropAdapter, DropTargetEvent aDropTargetEvent, Object aTarget) {
        if (LocalSelectionTransfer.getTransfer().isSupportedType(aDropAdapter.getCurrentTransfer())) {
            Iterable<Reachable> reachables = this.getReachable(LocalSelectionTransfer.getTransfer().getSelection());
            DropRequirementDelegate req = new DropRequirementDelegate();
            IFile file = WorkspaceSynchronizer.getFile((Resource)((EObject)aTarget).eResource());
            try {
                req.handleDrop((List)Lists.newArrayList(reachables), this.manager.getHandlerFromObject(aTarget).getFromObject(aTarget).getReachable(), (IResource)file);
            }
            catch (IReachableHandlerException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

