/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.export.pages;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.polarsys.reqcycle.export.ProviderUtils;
import org.polarsys.reqcycle.export.pages.WizardController;
import org.polarsys.reqcycle.export.transform.RequirementSourceReqProvider;
import org.polarsys.reqcycle.export.transform.ScopeReqProvider;
import org.polarsys.reqcycle.repository.data.IDataManager;
import org.polarsys.reqcycle.repository.data.IDataModelManager;
import org.polarsys.reqcycle.repository.data.RequirementSourceConf.RequirementSource;
import org.polarsys.reqcycle.repository.data.ScopeConf.Scope;
import org.polarsys.reqcycle.repository.data.types.IDataModel;
import org.polarsys.reqcycle.repository.ui.providers.RequirementSourceLabelProvider;

public class RequirementSourceSelectionPage
extends WizardPage {
    @Inject
    IDataManager requirementSourceManager;
    @Inject
    IDataModelManager dataManager;
    private CheckboxTableViewer reqScopeTableViewer;
    private Collection<Scope> scopes = new ArrayList<Scope>();
    private IDataModel dataModel;
    protected WizardController controller;
    private List<RequirementSource> selectedSources = Lists.newArrayList();
    private Table table;
    private Table table_1;
    private CheckboxTableViewer reqSourceTableViewer;

    public RequirementSourceSelectionPage(WizardController controller) {
        super("wizardPage");
        this.controller = controller;
        this.setTitle("Traceability");
        this.setDescription("Selection of scopes from data model and data sources");
    }

    public boolean isPageComplete() {
        return this.reqSourceTableViewer.getCheckedElements().length != 0 || this.reqScopeTableViewer.getCheckedElements().length != 0;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(1, false));
        Composite composite = new Composite(container, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        composite.setLayout((Layout)new GridLayout(1, false));
        Group grpDataSource = new Group(composite, 0);
        grpDataSource.setLayout((Layout)new GridLayout(1, false));
        grpDataSource.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        grpDataSource.setText("Data Sources");
        this.reqSourceTableViewer = CheckboxTableViewer.newCheckList((Composite)grpDataSource, (int)67584);
        this.reqSourceTableViewer.setLabelProvider((IBaseLabelProvider)new RequirementSourceLabelProvider());
        this.reqSourceTableViewer.setContentProvider(ProviderUtils.getArrayContentProvider());
        this.reqSourceTableViewer.setInput((Object)this.requirementSourceManager.getRequirementSources());
        this.table = this.reqSourceTableViewer.getTable();
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.reqSourceTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    RequirementSourceSelectionPage.this.controller.addReqProvider(new RequirementSourceReqProvider((RequirementSource)event.getElement()));
                } else {
                    RequirementSourceSelectionPage.this.controller.removeReqProvider(new RequirementSourceReqProvider((RequirementSource)event.getElement()));
                }
                RequirementSourceSelectionPage.this.getWizard().getContainer().updateButtons();
                RequirementSourceSelectionPage.this.getWizard().getContainer().updateMessage();
            }
        });
        Group grpScope = new Group(composite, 0);
        grpScope.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        grpScope.setText("Scopes");
        grpScope.setLayout((Layout)new GridLayout(2, false));
        Label lblDataModel = new Label((Composite)grpScope, 0);
        lblDataModel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblDataModel.setText("Data Model :");
        ComboViewer modelComboViewer = new ComboViewer((Composite)grpScope, 8);
        Combo combo = modelComboViewer.getCombo();
        combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        modelComboViewer.setContentProvider(ProviderUtils.getArrayContentProvider());
        modelComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IDataModel) {
                    return ((IDataModel)element).getName();
                }
                return "";
            }
        });
        modelComboViewer.setInput((Object)this.dataManager.getCurrentDataModels());
        modelComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IDataModel selectedDataModel;
                Object firstElement;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (firstElement = ((IStructuredSelection)selection).getFirstElement()) instanceof IDataModel && (selectedDataModel = (IDataModel)firstElement) != RequirementSourceSelectionPage.this.dataModel) {
                    RequirementSourceSelectionPage.this.dataModel = selectedDataModel;
                    RequirementSourceSelectionPage.this.setScopes(RequirementSourceSelectionPage.this.dataManager.getScopes(RequirementSourceSelectionPage.this.dataModel));
                }
            }
        });
        this.reqScopeTableViewer = CheckboxTableViewer.newCheckList((Composite)grpScope, (int)67584);
        this.reqScopeTableViewer.setContentProvider(ProviderUtils.getArrayContentProvider());
        this.reqScopeTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Scope) {
                    return ((Scope)element).getName();
                }
                return "a";
            }
        });
        this.reqScopeTableViewer.setInput(this.scopes);
        this.reqScopeTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    RequirementSourceSelectionPage.this.controller.addReqProvider(new ScopeReqProvider((Scope)event.getElement()));
                } else {
                    RequirementSourceSelectionPage.this.controller.removeReqProvider(new ScopeReqProvider((Scope)event.getElement()));
                }
                RequirementSourceSelectionPage.this.getWizard().getContainer().updateButtons();
                RequirementSourceSelectionPage.this.getWizard().getContainer().updateMessage();
            }
        });
        this.table_1 = this.reqScopeTableViewer.getTable();
        this.table_1.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        for (RequirementSource s : this.selectedSources) {
            this.reqSourceTableViewer.setChecked((Object)s, true);
        }
        this.doCreateGroup(composite);
    }

    protected void doCreateGroup(Composite composite) {
    }

    protected void setScopes(Collection<Scope> scopes) {
        this.scopes.clear();
        this.scopes.addAll(scopes);
        if (this.reqScopeTableViewer != null) {
            this.reqScopeTableViewer.setSelection((ISelection)new StructuredSelection(scopes));
            this.reqScopeTableViewer.refresh();
        }
    }

    public void select(RequirementSource source) {
        this.selectedSources.add(source);
    }
}

