/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.repository.data.ui.naming.impl;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.polarsys.reqcycle.repository.data.IDataModelManager;
import org.polarsys.reqcycle.repository.data.types.IDataModel;
import org.polarsys.reqcycle.repository.data.types.IType;
import org.polarsys.reqcycle.repository.data.ui.naming.IRequirementNamingPreferenceManager;
import org.polarsys.reqcycle.repository.data.ui.naming.strategy.IStrategy;
import org.polarsys.reqcycle.repository.data.ui.naming.strategy.IStrategyWithID;
import org.polarsys.reqcycle.repository.data.ui.naming.strategy.impl.IDStrategy;
import org.polarsys.reqcycle.repository.data.ui.naming.typeconfiguration.TypeConfiguration;
import org.polarsys.reqcycle.repository.data.ui.naming.variable.IVariable;
import org.polarsys.reqcycle.repository.data.ui.naming.variable.IVariableWithID;
import org.polarsys.reqcycle.repository.data.ui.naming.variable.impl.IDVariable;
import org.polarsys.reqcycle.utils.configuration.IConfigurationManager;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

@Singleton
public class RequirementNamingPreferenceManager
implements IRequirementNamingPreferenceManager {
    static final String TYPES_CONF_ID = "org.polarsys.reqcycle.data.typeconfiguration";
    static final String VARIABLES = "variables";
    static final String STRATEGIES = "strategies";
    private static Map<String, IStrategyWithID> strategies = RequirementNamingPreferenceManager.doGetAllRegisteredStrategies();
    private static Map<String, IVariableWithID> variables = RequirementNamingPreferenceManager.doGetAllRegisteredVariables();
    private Map<String, Map<IType, TypeConfiguration>> configurations;
    private Map<String, Map<IType, TypeConfiguration>> localConfigurations;
    @Inject
    IConfigurationManager confManager;
    @Inject
    IDataModelManager dataModelManager;

    @PostConstruct
    void postConstruct() {
        this.localConfigurations = this.doLoadAllConfigurations();
        this.configurations = this.cloneConfiguration(this.localConfigurations);
    }

    public static String getID(String datamodel, IType type) {
        return "org.polarsys.reqcycle.data.typeconfiguration." + datamodel + "." + type.getName();
    }

    @Override
    public void setConfiguration(IDataModel datamodel, IType type, TypeConfiguration config) {
        Map<IType, TypeConfiguration> map = this.localConfigurations.get(datamodel.getName());
        map.put(type, config);
        this.localConfigurations.put(datamodel.getName(), map);
    }

    @Override
    public void removeConfiguration(IDataModel datamodel, IType type) {
        Map<IType, TypeConfiguration> map = this.localConfigurations.get(datamodel.getName());
        map.remove(type);
        this.localConfigurations.put(datamodel.getName(), map);
    }

    @Override
    public TypeConfiguration getConfiguration(IDataModel datamodel, IType type) {
        Map<IType, TypeConfiguration> map = this.localConfigurations.get(datamodel.getName());
        if (map != null) {
            return map.get(type);
        }
        return null;
    }

    @Override
    public Map<IType, TypeConfiguration> getConfigurations(IDataModel datamodel) {
        return Collections.unmodifiableMap(this.localConfigurations.get(datamodel.getName()));
    }

    @Override
    public void saveConfigurations() {
        for (Map.Entry<String, Map<IType, TypeConfiguration>> entry : this.configurations.entrySet()) {
            this.removeConfigurations(entry.getKey(), entry.getValue());
        }
        this.configurations = this.cloneConfiguration(this.localConfigurations);
        for (Map.Entry<String, Map<IType, TypeConfiguration>> entry : this.configurations.entrySet()) {
            this.saveConfigurations(entry.getKey(), entry.getValue());
        }
    }

    private void removeConfigurations(String datamodel, Map<IType, TypeConfiguration> configs) {
        for (Map.Entry<IType, TypeConfiguration> entry : configs.entrySet()) {
            IType type = entry.getKey();
            entry.getValue();
            this.confManager.removeSimpleConfiguration(null, null, RequirementNamingPreferenceManager.getID(datamodel, type));
        }
    }

    private void saveConfigurations(String datamodel, Map<IType, TypeConfiguration> configs) {
        try {
            for (Map.Entry<IType, TypeConfiguration> entry : configs.entrySet()) {
                IType type = entry.getKey();
                TypeConfiguration conf = entry.getValue();
                this.confManager.saveSimpleConfiguration(this.getMapFromConfiguration(conf), null, null, RequirementNamingPreferenceManager.getID(datamodel, type));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void clearConfigurations() {
        this.localConfigurations = this.cloneConfiguration(this.configurations);
    }

    private Map<IType, TypeConfiguration> doLoadConfigurations(IDataModel datamodel) {
        HashMap<IType, TypeConfiguration> map = new HashMap<IType, TypeConfiguration>();
        for (IType type : datamodel.getTypes()) {
            Map conf = this.confManager.getSimpleConfiguration(null, null, RequirementNamingPreferenceManager.getID(datamodel.getName(), type), false);
            if (conf == null) continue;
            map.put(type, this.getConfigurationFromMap(conf));
        }
        return map;
    }

    private Map<String, Map<IType, TypeConfiguration>> doLoadAllConfigurations() {
        HashMap<String, Map<IType, TypeConfiguration>> map = new HashMap<String, Map<IType, TypeConfiguration>>();
        for (IDataModel datamodel : this.dataModelManager.getCurrentDataModels()) {
            map.put(datamodel.getName(), this.doLoadConfigurations(datamodel));
        }
        return map;
    }

    @Override
    public Collection<IDataModel> getDataModels() {
        return this.dataModelManager.getCurrentDataModels();
    }

    @Override
    public Collection<IType> getTypes(IDataModel datamodel) {
        return datamodel.getTypes();
    }

    @Override
    public Collection<IType> getUnSetTypes(IDataModel datamodel) {
        ArrayList<IType> list = new ArrayList<IType>();
        Map<IType, TypeConfiguration> map = this.localConfigurations.get(datamodel.getName());
        for (IType type : datamodel.getTypes()) {
            if (map.containsKey(type)) continue;
            list.add(type);
        }
        return list;
    }

    private static Map<String, IVariableWithID> doGetAllRegisteredVariables() {
        IConfigurationElement[] extensions = Platform.getExtensionRegistry().getConfigurationElementsFor("org.polarsys.reqcycle.repository.data.ui.naming", VARIABLES);
        Iterable vars = Iterables.transform(Arrays.asList(extensions), (Function)new Function<IConfigurationElement, IVariableWithID>(){

            public IVariableWithID apply(IConfigurationElement arg0) {
                try {
                    IVariable var = (IVariable)arg0.createExecutableExtension("impl");
                    ZigguratInject.inject((Object[])new Object[]{var});
                    return IDVariable.of(var, arg0.getAttribute("id"));
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        });
        return Maps.uniqueIndex((Iterable)Iterables.filter((Iterable)vars, (Predicate)Predicates.notNull()), (Function)new Function<IVariableWithID, String>(){

            public String apply(IVariableWithID arg0) {
                return arg0.getID();
            }
        });
    }

    @Override
    public Map<String, IVariableWithID> getAllRegisteredVariables() {
        return variables;
    }

    private static Map<String, IStrategyWithID> doGetAllRegisteredStrategies() {
        IConfigurationElement[] extensions = Platform.getExtensionRegistry().getConfigurationElementsFor("org.polarsys.reqcycle.repository.data.ui.naming", STRATEGIES);
        Iterable strats = Iterables.transform(Arrays.asList(extensions), (Function)new Function<IConfigurationElement, IStrategyWithID>(){

            public IStrategyWithID apply(IConfigurationElement arg0) {
                try {
                    IStrategy result = (IStrategy)arg0.createExecutableExtension("impl");
                    ZigguratInject.inject((Object[])new Object[]{result});
                    return IDStrategy.of(result, arg0.getAttribute("id"));
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        });
        return Maps.uniqueIndex((Iterable)Iterables.filter((Iterable)strats, (Predicate)Predicates.notNull()), (Function)new Function<IStrategyWithID, String>(){

            public String apply(IStrategyWithID arg0) {
                return arg0.getID();
            }
        });
    }

    @Override
    public List<IStrategyWithID> getAllRegisteredStrategies() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(strategies.values());
        return builder.build();
    }

    @Override
    public IStrategyWithID getStrategyById(String id) {
        return strategies.get(id);
    }

    private Map<String, Object> getMapFromConfiguration(TypeConfiguration conf) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("org.polarsys.reqcycle.repository.data.pattern", conf.getPattern());
        map.put("org.polarsys.reqcycle.repository.data.strategy", conf.getStrategy().getID());
        map.put("org.polarsys.reqcycle.repository.data.step", conf.getStep());
        map.put("org.polarsys.reqcycle.repository.data.digits", conf.getDigits());
        return map;
    }

    private TypeConfiguration getConfigurationFromMap(Map<String, Object> map) {
        TypeConfiguration conf = TypeConfiguration.create();
        conf.setPattern((String)map.get("org.polarsys.reqcycle.repository.data.pattern"));
        conf.setStrategy(this.getStrategyById((String)map.get("org.polarsys.reqcycle.repository.data.strategy")));
        conf.setStep((Integer)map.get("org.polarsys.reqcycle.repository.data.step"));
        conf.setDigits((Integer)map.get("org.polarsys.reqcycle.repository.data.digits"));
        return conf;
    }

    private Map<String, Map<IType, TypeConfiguration>> cloneConfiguration(Map<String, Map<IType, TypeConfiguration>> map) {
        HashMap<String, Map<IType, TypeConfiguration>> clone = new HashMap<String, Map<IType, TypeConfiguration>>();
        for (Map.Entry<String, Map<IType, TypeConfiguration>> entry : map.entrySet()) {
            HashMap<IType, TypeConfiguration> m = new HashMap<IType, TypeConfiguration>();
            for (Map.Entry<IType, TypeConfiguration> e : entry.getValue().entrySet()) {
                m.put(e.getKey(), e.getValue());
            }
            clone.put(entry.getKey(), m);
        }
        return clone;
    }
}

