/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.repository.data.ui.naming.variable.impl;

import javax.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.reqcycle.repository.data.IDataModelManager;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.AbstractElement;
import org.polarsys.reqcycle.repository.data.types.IDataModel;
import org.polarsys.reqcycle.repository.data.types.IRequirementType;
import org.polarsys.reqcycle.repository.data.types.IType;
import org.polarsys.reqcycle.repository.data.ui.naming.IRequirementNamingPreferenceManager;
import org.polarsys.reqcycle.repository.data.ui.naming.strategy.IStrategyWithID;
import org.polarsys.reqcycle.repository.data.ui.naming.typeconfiguration.TypeConfiguration;
import org.polarsys.reqcycle.repository.data.ui.naming.variable.IVariable;

public class IndexVariable
implements IVariable {
    public static final String NAME = "index";
    @Inject
    IRequirementNamingPreferenceManager prefManager;
    @Inject
    IDataModelManager dataModelManager;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getValue(EObject container, AbstractElement element) {
        IRequirementType type = this.dataModelManager.getType(element);
        if (type == null) {
            return null;
        }
        IDataModel datamodel = type.getDataModel();
        TypeConfiguration conf = this.prefManager.getConfiguration(datamodel, (IType)type);
        if (conf == null) {
            return null;
        }
        IStrategyWithID strategy = conf.getStrategy();
        int index = strategy.getLastIndex(container, element);
        index = index == IStrategyWithID.ERROR_VALUE ? conf.getStep() : (index += conf.getStep());
        return String.format("%0" + conf.getDigits() + "d", index);
    }
}

