/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.sgml.impl;

import org.eclipse.actf.model.internal.dom.sgml.impl.ElementDefinition;

class UnsynchronizedHashtable {
    private ElementDefinition[] linearTable = new ElementDefinition[256];
    private int count = 0;
    private Entry[] table = new Entry[256];

    UnsynchronizedHashtable() {
    }

    private void expand() {
        ElementDefinition[] newTable = new ElementDefinition[this.count * 2];
        System.arraycopy(this.linearTable, 0, newTable, 0, this.count);
        this.linearTable = newTable;
    }

    private int hashCode(char[] key) {
        int ret = 0;
        int i = key.length - 1;
        while (i >= 0) {
            ret = 25 * ret + (key[i] & 0x1F) - 1;
            --i;
        }
        return ret;
    }

    final ElementDefinition get(int number) {
        return this.linearTable[number];
    }

    final ElementDefinition get(String key) {
        char[] str = key.toCharArray();
        Entry entry = this.table[0xFF & this.hashCode(str)];
        while (entry != null) {
            String entryKey = entry.key;
            if (entryKey.equalsIgnoreCase(key)) {
                return entry.val;
            }
            entry = entry.next;
        }
        return null;
    }

    final void put(String key, ElementDefinition val) {
        char[] str = key.toCharArray();
        Entry entry = new Entry();
        entry.key = key;
        entry.val = val;
        val.number = entry.num = this.count;
        if (this.linearTable.length == this.count) {
            this.expand();
        }
        this.linearTable[this.count++] = val;
        int index = 0xFF & this.hashCode(str);
        entry.next = this.table[index];
        this.table[index] = entry;
    }

    final int size() {
        return this.count;
    }

    class Entry {
        String key;
        ElementDefinition val;
        int num;
        Entry next;

        Entry() {
        }
    }
}

