/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.httpproxy.core;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.eclipse.actf.util.httpproxy.core.IHTTPRequestMessage;
import org.eclipse.actf.util.httpproxy.core.IHTTPResponseMessage;
import org.eclipse.actf.util.httpproxy.core.TimeoutException;
import org.eclipse.actf.util.httpproxy.util.Logger;
import org.eclipse.actf.util.internal.httpproxy.core.BifurcatedOutputStream;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPConnectionException;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPMalformedResponseMessage;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPResponseMessage;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPResponseReader;
import org.eclipse.actf.util.internal.httpproxy.core.RequestDispatcher;
import org.eclipse.actf.util.internal.httpproxy.core.ServerKey;
import org.eclipse.actf.util.internal.httpproxy.core.SocketTimeoutRetryOutputStream;

public abstract class ServerConnection
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(ServerConnection.class);
    public static final int STAT_CLOSED = -2;
    public static final int STAT_FINALIZING = -1;
    public static final int STAT_INIT = 0;
    public static final int STAT_CONNECTING = 1;
    public static final int STAT_CONNECTED = 2;
    private final ServerKey fKey;
    private final String name;
    private final String host;
    private final int port;
    private final RequestDispatcher fDispatcher;
    private final int fRetryTime;
    private final int timeout;
    private Thread fThread;
    private SocketOpener fSocketOpener = null;
    private Thread fSocketOpenerThread = null;
    private IHTTPRequestMessage fRequest;
    private long fFirstTimeout = 0L;
    private Socket fSocket = null;
    private InputStream fInputStream = null;
    private BufferedOutputStream fOutputStream = null;
    private HTTPResponseReader fReader = null;
    private long fMessageSerial;
    private Status fStat = new Status();

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    InputStream getInputStream() {
        return this.fInputStream;
    }

    OutputStream getOutputStream() {
        return this.fOutputStream;
    }

    protected ServerConnection(String name, String host, int port, int group, int index, RequestDispatcher dispatcher, int retryTime, int timeout) {
        this.name = name;
        this.host = host;
        this.port = port;
        this.fKey = new ServerKey(group, index);
        this.fRetryTime = retryTime;
        this.fDispatcher = dispatcher;
        this.timeout = timeout;
        this.fRequest = null;
        this.fMessageSerial = 0L;
    }

    protected abstract HTTPResponseMessage createHTTPResponseMessage(long var1);

    public synchronized void reset() {
        this.deactivate();
        this.setStat(0);
    }

    public ServerKey getKey() {
        return this.fKey;
    }

    public synchronized boolean isActive() {
        return this.fThread != null;
    }

    public synchronized void activate() {
        if (this.isActive()) {
            this.DEBUG("activate: already active");
            return;
        }
        this.DEBUG("activate");
        this.setStat(1);
        this.fMessageSerial = 0L;
        this.setTimeout(false);
        this.fThread = new Thread((Runnable)this, "ServerConnection-" + this.name);
        this.fThread.start();
        this.fSocket = null;
        this.fOutputStream = null;
        this.fReader = null;
        this.fSocketOpener = new SocketOpener(this.host, this.port, this.timeout * 2, this);
        this.fSocketOpenerThread = new Thread((Runnable)this.fSocketOpener, "SocketOpener-" + this.toString());
        this.fSocketOpenerThread.start();
    }

    public void activateAndConnect(long timeout) throws IOException, TimeoutException, InterruptedException {
        this.activate();
        this.waitUntilConnected(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilConnected(long timeout) throws IOException, TimeoutException, InterruptedException {
        int stat;
        this.DEBUG("waitUntilConnected");
        Status status = this.fStat;
        synchronized (status) {
            if (this.fStat.equals(1)) {
                this.fStat.waitFor(2, timeout);
            }
            stat = this.fStat.get();
        }
        if (stat == 2) {
            this.DEBUG("connected");
            return;
        }
        if (stat == 1) {
            throw new TimeoutException("ServerConnection.waitUntilConnected");
        }
        if (stat == 0) {
            throw new IOException("This connection is not activated yet");
        }
        if (stat == -2) {
            throw new IOException("This connection is already closed");
        }
    }

    public synchronized void deactivate() {
        this.DEBUG("deactivate");
        if (!this.isActive()) {
            this.DEBUG("deactivate: already deactive");
            return;
        }
        try {
            if (this.fSocket != null && !this.fSocket.isOutputShutdown()) {
                this.fSocket.shutdownOutput();
            }
        }
        catch (IOException e) {
            this.WARNING("Failed to shutdown a socket (IOException): " + e.getMessage());
        }
        this.fThread.interrupt();
        this.fThread = null;
        this.fSocketOpener.setValid(false);
        this.fSocketOpenerThread.interrupt();
        this.fSocketOpener = null;
        this.fSocketOpenerThread = null;
        this.fSocket = null;
        this.fOutputStream = null;
        this.fReader = null;
        this.fMessageSerial = 0L;
        this.setTimeout(false);
        this.setStat(-2);
    }

    synchronized void notifyConnected(Socket sock, OutputStream out, InputStream in) {
        if (sock == null) {
            throw new IllegalArgumentException("null");
        }
        this.DEBUG("setSocket");
        this.fSocket = sock;
        this.fOutputStream = new BufferedOutputStream(new SocketTimeoutRetryOutputStream(out));
        this.fInputStream = in;
        this.fReader = this.fDispatcher.createHTTPResponseReader(in);
        this.setStat(2);
    }

    synchronized void notifyConnectFailed(IOException e) {
        this.WARNING("setSocketException: failed to create a socket (IOException): " + e.getMessage());
        this.fSocket = null;
        this.fOutputStream = null;
        this.fReader = null;
        this.deactivate();
    }

    public synchronized void setTimeout(boolean timeout) {
        if (timeout) {
            if (this.fFirstTimeout == 0L) {
                this.fFirstTimeout = System.currentTimeMillis();
            }
        } else {
            this.fFirstTimeout = 0L;
        }
    }

    public synchronized boolean isInvalid() {
        if (this.fFirstTimeout == 0L) {
            return false;
        }
        return System.currentTimeMillis() - this.fFirstTimeout < (long)this.fRetryTime;
    }

    public int getStat() {
        return this.fStat.get();
    }

    private void setStat(int stat) {
        this.fStat.set(stat);
    }

    private boolean startSession(long msgSerial, long timeout) throws TimeoutException, InterruptedException {
        if (this.fMessageSerial != 0L) {
            if (msgSerial == this.fMessageSerial) {
                return false;
            }
            long deadline = System.currentTimeMillis() + timeout;
            long wait = timeout;
            while (wait > 0L) {
                this.wait(wait);
                if (this.fMessageSerial == 0L) break;
                wait = deadline - System.currentTimeMillis();
            }
            if (this.fMessageSerial != 0L) {
                throw new TimeoutException("ServerConnection.startSession");
            }
        }
        this.fMessageSerial = msgSerial;
        if (LOGGER.isDebugEnabled()) {
            this.DEBUG("Session started: msgSerial=" + this.fMessageSerial);
        }
        return true;
    }

    private synchronized void finishSession() {
        if (LOGGER.isDebugEnabled()) {
            this.DEBUG("Session finished: msgSerial=" + this.fMessageSerial);
        }
        assert (this.fMessageSerial != 0L);
        this.fMessageSerial = 0L;
        this.notifyAll();
    }

    public synchronized void putRequest(IHTTPRequestMessage req, long timeout) throws TimeoutException, InterruptedException {
        if (LOGGER.isDebugEnabled()) {
            this.DEBUG("putRequest: msgSerial=" + req.getSerial() + ", tid=" + req.getTid());
        }
        boolean sessionStarted = this.startSession(req.getSerial(), timeout);
        assert (req.getSerial() == this.fMessageSerial);
        if (sessionStarted) {
            this.fRequest = req;
            this.notifyAll();
        }
    }

    private synchronized IHTTPRequestMessage nextRequest() throws InterruptedException {
        while (this.fRequest == null || this.fMessageSerial == 0L) {
            if (LOGGER.isDebugEnabled()) {
                this.DEBUG("nextRequest waiting: request=" + this.fRequest + ", msgSerial=" + this.fMessageSerial);
            }
            this.wait();
        }
        if (LOGGER.isDebugEnabled()) {
            this.DEBUG("nextRequest waiting done: request=" + this.fRequest + ", msgSerial=" + this.fMessageSerial);
        }
        IHTTPRequestMessage req = this.fRequest;
        this.fRequest = null;
        return req;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IHTTPResponseMessage receiveResponse(long timeout, boolean isBodyEmpty) throws InterruptedException, IOException, TimeoutException {
        long msgSerial;
        HTTPResponseReader reader;
        ServerConnection serverConnection = this;
        synchronized (serverConnection) {
            assert (this.fStat.equals(2) && this.fReader != null && this.fMessageSerial != 0L);
            if (this.fReader == null || this.fMessageSerial == 0L) {
                throw new IOException("Deactivated");
            }
            reader = this.fReader;
            msgSerial = this.fMessageSerial;
        }
        HTTPResponseMessage response = this.createHTTPResponseMessage(msgSerial);
        this.DEBUG("Try to read response...");
        reader.readMessage(response, timeout, isBodyEmpty);
        return response;
    }

    private synchronized void sendRequest(IHTTPRequestMessage request, long timeout) throws IOException, InterruptedException, TimeoutException {
        if (LOGGER.isDebugEnabled()) {
            this.DEBUG("sendRequest....");
        }
        long t0 = System.currentTimeMillis();
        this.waitUntilConnected(timeout);
        assert (this.fOutputStream != null);
        long t1 = System.currentTimeMillis();
        if ((timeout -= t1 - t0) <= 0L) {
            throw new TimeoutException();
        }
        if (LOGGER.isDebugEnabled()) {
            this.DEBUG("Sent a request: msgSerial=" + request.getSerial() + ", tid=" + request.getTid());
            StringBuffer sb = new StringBuffer();
            ByteArrayOutputStream ob = new ByteArrayOutputStream();
            BifurcatedOutputStream o = new BifurcatedOutputStream(this.fOutputStream, ob);
            request.write(timeout, o);
            ob.close();
            sb.append("\n===============>====>====>====>=============>\n");
            sb.append(ob.toString());
            sb.append("===============<====<====<====<=============<\n");
            this.DEBUG(sb.toString());
        } else {
            request.write(timeout, this.fOutputStream);
        }
        this.fOutputStream.flush();
        this.fMessageSerial = request.getSerial();
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        this.DEBUG("receiver thread started");
        try {
            try {
                serverError = false;
                if (true) ** GOTO lbl45
                do {
                    block22: {
                        request = this.nextRequest();
                        try {
                            if (request.isConnectionShutdownRequired()) {
                                request.setConnectionHeader(false);
                                this.sendRequest(request, this.timeout);
                                this.fSocket.shutdownOutput();
                                this.setStat(-1);
                            } else {
                                request.setConnectionHeader(true);
                                this.sendRequest(request, this.timeout);
                            }
                        }
                        catch (TimeoutException v0) {
                            this.DEBUG("sendRequest() timeout");
                            this.setTimeout(true);
                            break block22;
                        }
                        if (!(ServerConnection.$assertionsDisabled || this.fStat.equals(2) || this.fStat.equals(-1))) {
                            throw new AssertionError();
                        }
                        loop = 0;
                        start = System.currentTimeMillis();
                        while (!Thread.currentThread().isInterrupted() && !serverError) {
                            try {
                                this.DEBUG("ReceiveResponse...");
                                response = this.receiveResponse(this.timeout, request.isResponseBodyEmpty());
                                this.DEBUG("ResponseArrived...");
                                if (response.isConnectionToBeClosed()) {
                                    this.DEBUG("Since the response is not keep-alive, we do not reuse this connection.");
                                    this.setStat(-1);
                                }
                                this.fDispatcher.responseArrived(this, response);
                                this.finishSession();
                                break;
                            }
                            catch (TimeoutException timeout) {
                                if (ServerConnection.LOGGER.isDebugEnabled()) {
                                    this.DEBUG("response receiving timeout (" + timeout.getMessage() + "): retry=" + loop + ", elapsed=" + (System.currentTimeMillis() - start));
                                }
                                ++loop;
                                delay = System.currentTimeMillis() - start;
                                if (delay <= 60000L) continue;
                                throw new IOException("Shutdown this connection");
                            }
                        }
                    }
                    if (Thread.interrupted()) return;
                } while (!serverError);
                return;
            }
            catch (HTTPConnectionException v1) {
                this.DEBUG("The connection is closed by the peer.");
                this.DEBUG("receiver thread stopped");
                this.deactivate();
                return;
            }
            catch (IOException e) {
                this.DEBUG("IOException: " + e.getMessage());
                response = new HTTPMalformedResponseMessage(this.fMessageSerial, e);
                try {
                    this.fDispatcher.responseArrived(this, response);
                }
                catch (InterruptedException v2) {}
                this.finishSession();
                this.DEBUG("receiver thread stopped");
                this.deactivate();
                return;
            }
            catch (InterruptedException v3) {
                this.DEBUG("reader thread interrupted");
                this.DEBUG("receiver thread stopped");
                this.deactivate();
                return;
                {
                    catch (Throwable var8_10) {
                        throw var8_10;
                    }
                }
            }
        }
        finally {
            this.DEBUG("receiver thread stopped");
            this.deactivate();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.host).append(':').append(this.port).append('.').append(this.fKey.toString());
        return sb.toString();
    }

    private final void DEBUG(String msg) {
        if (LOGGER.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.name).append(" [");
            sb.append(this.toString()).append("] ").append(msg);
            LOGGER.debug(sb.toString());
        }
    }

    private final void WARNING(String msg) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name).append(" [");
        sb.append(this.toString()).append("] ").append(msg);
        LOGGER.warning(sb.toString());
    }

    public synchronized String dump() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.toString()).append(": stat=").append(this.fStat);
        sb.append(", thread=");
        sb.append(this.fThread == null ? "null" : Boolean.toString(this.fThread.isAlive()));
        sb.append(", socketOpener=");
        sb.append(this.fSocketOpener == null ? "null" : "exists");
        sb.append(", socketOpenerThread=");
        sb.append(this.fSocketOpenerThread == null ? "null" : Boolean.toString(this.fSocketOpenerThread.isAlive()));
        sb.append(", socket=");
        sb.append(this.fSocket == null ? "null" : Boolean.toString(this.fSocket.isConnected()));
        sb.append(", invalid=").append(this.isInvalid());
        return sb.toString();
    }

    private static class SocketOpener
    implements Runnable {
        private ServerConnection fSocketReceiver;
        private String fHost;
        private int fPort;
        private boolean isValid;

        SocketOpener(String host, int port, int soTimeout, ServerConnection socketReceiver) {
            this.fHost = host;
            this.fPort = port;
            this.fSocketReceiver = socketReceiver;
            this.isValid = true;
        }

        synchronized void setValid(boolean v) {
            this.isValid = v;
        }

        synchronized boolean isValid() {
            return this.isValid;
        }

        public void run() {
            block8: {
                this.fSocketReceiver.DEBUG("SocketOpener started");
                try {
                    Socket sock = null;
                    OutputStream out = null;
                    InputStream in = null;
                    if (this.isValid()) {
                        if (LOGGER.isDebugEnabled()) {
                            this.fSocketReceiver.DEBUG("Trying to create a Socket: " + this.fHost + "@" + this.fPort);
                        }
                        sock = new Socket(this.fHost, this.fPort);
                        sock.setSoTimeout(1);
                        out = sock.getOutputStream();
                        in = sock.getInputStream();
                        if (LOGGER.isDebugEnabled()) {
                            this.fSocketReceiver.DEBUG("Created a Socket: " + this.fHost + "@" + this.fPort);
                        }
                    }
                    if (sock != null && out != null && in != null && this.isValid()) {
                        if (LOGGER.isDebugEnabled()) {
                            this.fSocketReceiver.DEBUG("Set a Socket to the ServerConnection: " + this.fHost + "@" + this.fPort);
                        }
                        this.fSocketReceiver.notifyConnected(sock, out, in);
                    }
                }
                catch (IOException e) {
                    if (LOGGER.isDebugEnabled()) {
                        this.fSocketReceiver.DEBUG("Failed to create a Socket (" + e.getClass().getName() + "): " + this.fHost + "@" + this.fPort);
                    }
                    if (!this.isValid()) break block8;
                    this.fSocketReceiver.notifyConnectFailed(e);
                }
            }
        }
    }

    private static class Status {
        private int fStat = 0;
        private int fNumWaiters = 0;

        Status() {
        }

        synchronized void set(int stat) {
            this.fStat = stat;
            this.notifyAll();
        }

        synchronized int get() {
            return this.fStat;
        }

        synchronized boolean equals(int stat) {
            return this.fStat == stat;
        }

        synchronized boolean waitFor(int stat, long timeout) throws InterruptedException, TimeoutException {
            if (this.fStat == stat) {
                return true;
            }
            if (this.fStat == -2) {
                return false;
            }
            ++this.fNumWaiters;
            long deadline = System.currentTimeMillis() + timeout;
            long wait = timeout;
            while (wait > 0L) {
                this.wait(wait);
                if (this.fStat == stat) {
                    return true;
                }
                if (this.fStat == -2) {
                    return false;
                }
                wait = deadline - System.currentTimeMillis();
            }
            throw new TimeoutException();
        }

        public String toString() {
            switch (this.fStat) {
                case -2: {
                    return "CLOSED";
                }
                case 0: {
                    return "INIT";
                }
                case 1: {
                    return "CONNECTING";
                }
                case 2: {
                    return "CONNECTED";
                }
            }
            return "Unkown";
        }
    }
}

