/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.internal.ui.scripteditor;

import java.net.URLDecoder;
import org.eclipse.actf.ai.scripteditor.data.ScriptData;
import org.eclipse.actf.ai.scripteditor.util.SoundMixer;
import org.eclipse.actf.ai.ui.scripteditor.views.IUNIT;
import org.eclipse.actf.examples.scripteditor.Activator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class ScriptListLabelProvider
extends LabelProvider
implements ITableLabelProvider,
IUNIT {
    private static final String LABEL_EXTENDED_ENABLE = "Ex";
    private static final String LABEL_EXTENDED_DISABLE = "";

    public Image getColumnImage(Object element, int columnIndex) {
        int index;
        ScriptData item = (ScriptData)element;
        Image result = null;
        if (columnIndex == 0 && (index = ScriptData.getInstance().getIndexWavList(item.getScriptStartTime(0))) >= 0) {
            Image imgWavOn = Activator.getImageDescriptor("/icons/wave_on.gif").createImage();
            Image imgWavOff = Activator.getImageDescriptor("/icons/wave_off.gif").createImage();
            Image image = result = ScriptData.getInstance().getEnableWavList(index) ? imgWavOn : imgWavOff;
            if (ScriptData.getInstance().getEndTimeWavList(index) == -1) {
                result = imgWavOff;
            }
            try {
                String strWavPath = ScriptData.getInstance().getFileNameWavList(index).toString().replace("file:/", LABEL_EXTENDED_DISABLE);
                if (!SoundMixer.getInstance().isWavFormat(strWavPath)) {
                    strWavPath = URLDecoder.decode(ScriptData.getInstance().getFileNameWavList(index).toString(), "UTF-8").replace("file:/", LABEL_EXTENDED_DISABLE);
                    if (!SoundMixer.getInstance().isWavFormat(strWavPath)) {
                        result = imgWavOff;
                    }
                }
            }
            catch (Exception exception) {
                result = imgWavOff;
            }
        }
        return result;
    }

    public String getColumnText(Object element, int columnIndex) {
        ScriptData item = (ScriptData)element;
        String result = LABEL_EXTENDED_DISABLE;
        if (columnIndex == 1) {
            int startTime = item.getScriptStartTime(0);
            int index = ScriptData.getInstance().getIndexScriptData(startTime);
            if (index >= 0) {
                boolean stat = ScriptData.getInstance().getExtendExtended(index);
                result = new String(stat ? LABEL_EXTENDED_ENABLE : LABEL_EXTENDED_DISABLE);
            }
        } else if (columnIndex == 2) {
            int intScriptStartTime = item.getScriptStartTime(0);
            result = new String(item.makeFormatMMSSMS(intScriptStartTime));
        } else if (columnIndex == 3) {
            result = item.getScriptData(0);
        } else if (columnIndex == 4) {
            result = item.getScriptComment(0);
        }
        return result;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

