/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.ui.editor.actions;

import java.util.Map;
import java.util.TreeMap;
import org.eclipse.actf.model.internal.ui.FavoritesChangeEvent;
import org.eclipse.actf.model.internal.ui.FavoritesUtil;
import org.eclipse.actf.model.internal.ui.editor.actions.FavoritesAction;
import org.eclipse.actf.model.internal.ui.editor.dialogs.FavoritesArrangeDialog;
import org.eclipse.actf.model.ui.util.ModelServiceMessages;
import org.eclipse.ui.IWorkbenchWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrangeFavoritesAction
extends FavoritesAction {
    public static final String ID = ArrangeFavoritesAction.class.getName();
    private IWorkbenchWindow _window;

    public ArrangeFavoritesAction(IWorkbenchWindow window, Map<String, String> favoritesMap) {
        this._window = window;
        this.setId(ID);
        this.setText(ModelServiceMessages.MenuConst_ArrangeFavorites);
    }

    public void run() {
        Map<String, String> tmpMap = new TreeMap<String, String>();
        tmpMap.putAll(FavoritesUtil.getFavoritesMap());
        FavoritesArrangeDialog arrangeDialog = new FavoritesArrangeDialog(this._window.getShell(), tmpMap);
        int returnCode = arrangeDialog.open();
        if (returnCode == 0 && arrangeDialog.isModified()) {
            tmpMap = arrangeDialog.getFavoritesMap();
            FavoritesUtil.saveFavoritesMap(tmpMap);
            FavoritesChangeEvent fce = new FavoritesChangeEvent((Object)this, tmpMap);
            this.fireFavoritesChanged(fce);
        }
    }
}

