/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.xpath;

import java.lang.reflect.Method;
import org.eclipse.actf.util.xpath.XPathService;

public abstract class XPathServiceFactory {
    private static XPathServiceFactory factory;

    static {
        XPathServiceFactory.setFactory(XPathServiceFactory.enable("org.eclipse.actf.util.xpath.jaxp.XPathServiceFactoryImpl"));
        XPathServiceFactory.setFactory(XPathServiceFactory.enable("org.eclipse.actf.util.jxpath.XPathServiceFactoryImpl"));
    }

    private static XPathServiceFactory enable(String name) {
        try {
            Class<?> clazz = Class.forName(name);
            Method newInstanceMethod = clazz.getMethod("newInstance", new Class[0]);
            Object instance = newInstanceMethod.invoke(null, new Object[0]);
            if (instance instanceof XPathServiceFactory) {
                return (XPathServiceFactory)instance;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public static void setFactory(XPathServiceFactory f) {
        if (f != null) {
            factory = f;
        }
    }

    public static XPathService newService() {
        return factory.getService();
    }

    protected abstract XPathService getService();
}

