/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.win32.comclutch.impl;

import org.eclipse.actf.util.win32.comclutch.IResource;
import org.eclipse.actf.util.win32.comclutch.ResourceManager;

public abstract class IResourceImpl
implements IResource {
    private ResourceManager resourceManager;
    private final boolean permanent;

    public boolean isPermanent() {
        return this.permanent;
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public void addResource(IResource target) {
        if (this.resourceManager != null) {
            this.resourceManager.addResource(target);
        }
    }

    public void release() {
        if (this.resourceManager != null) {
            this.resourceManager.removeResource(this);
        }
    }

    public IResource findInResource(long ptr) {
        if (this.resourceManager != null) {
            return this.resourceManager.findInResource(ptr);
        }
        return null;
    }

    public int hashCode() {
        long x = this.getPtr();
        return (int)(x & 0xFFFFFFFFFFFFFFFFL ^ x >> 32);
    }

    public boolean equals(Object o) {
        if (!(o instanceof IResource)) {
            return false;
        }
        IResource r = (IResource)o;
        return this.getPtr() == r.getPtr();
    }

    public String toString() {
        return String.valueOf(super.toString()) + " PTR:" + this.getPtr();
    }

    public IResourceImpl(ResourceManager rm, boolean permanent) {
        this.resourceManager = rm;
        this.permanent = permanent;
    }
}

