/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.core.codeassist;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.ISourceParser;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.codeassist.IAssistParser;
import org.eclipse.dltk.compiler.env.ISourceModule;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.tcl.internal.core.codeassist.TclASTUtil;

public abstract class TclAssistParser
implements IAssistParser {
    protected static final int MODULE = 0;
    protected static final int NAMESPACE = 1;
    protected static final int FUNCTION = 2;
    protected static final int EXEC_EXPRESSION = 3;
    protected ISourceParser parser;
    protected ModuleDeclaration module;
    protected ASTNode assistNodeParent;

    public TclAssistParser() {
        block2: {
            this.parser = null;
            this.assistNodeParent = null;
            try {
                this.parser = DLTKLanguageManager.getSourceParser((String)"org.eclipse.dltk.tcl.core.nature");
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG) break block2;
                e.printStackTrace();
            }
        }
    }

    public ASTNode getAssistNodeParent() {
        return this.assistNodeParent;
    }

    protected void findElementsTo(List statements, ASTNode node, List elements) {
        if (statements == null) {
            return;
        }
        Iterator i = statements.iterator();
        while (i.hasNext()) {
            ASTNode n = (ASTNode)i.next();
            if (n.equals(node)) {
                elements.add(n);
                return;
            }
            if (n.sourceStart() > node.sourceStart() || node.sourceEnd() > n.sourceEnd()) continue;
            elements.add(n);
            this.findElementsTo(TclASTUtil.getStatements(n), node, elements);
            return;
        }
    }

    protected List findLevelsTo(ASTNode astNodeParent) {
        ArrayList<ModuleDeclaration> elements = new ArrayList<ModuleDeclaration>();
        if (this.module != null || astNodeParent instanceof ModuleDeclaration) {
            if (this.module == null) {
                this.module = (ModuleDeclaration)astNodeParent;
            }
            elements.add(this.module);
            this.findElementsTo(TclASTUtil.getStatements((ASTNode)this.module), astNodeParent, elements);
        }
        return elements;
    }

    public void setSource(ModuleDeclaration unit) {
        this.module = unit;
    }

    public ModuleDeclaration parse(ISourceModule sourceUnit) {
        ModuleDeclaration module = this.parser.parse(sourceUnit.getFileName(), sourceUnit.getSourceContents().toCharArray(), null);
        module.rebuild();
        TclASTUtil.extendStatements((ASTNode)module, sourceUnit.getSourceContents());
        return module;
    }
}

