/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.debug;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.dltk.dbgp.commands.IDbgpExtendedCommands;
import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.debug.core.IHotCodeReplaceProvider;
import org.eclipse.dltk.debug.core.model.IScriptDebugTarget;
import org.eclipse.dltk.debug.core.model.IScriptThread;
import org.eclipse.dltk.ruby.debug.Messages;

public class RubyHotCodeReplaceProvider
implements IHotCodeReplaceProvider {
    public void performCodeReplace(IScriptDebugTarget target, IResource[] resources) throws DebugException {
        IScriptThread[] threads = (IScriptThread[])target.getThreads();
        if (threads.length > 0) {
            IScriptThread thread = threads[0];
            IDbgpExtendedCommands extCmds = thread.getDbgpSession().getExtendedCommands();
            try {
                extCmds.evaluate(this.getReplacementCode(resources));
            }
            catch (DbgpException e) {
                this.fail(e);
            }
        }
    }

    private String getReplacementCode(IResource[] resources) throws DebugException {
        StringBuffer builder = new StringBuffer();
        this.getResourceReplacementCode(resources[0]);
        int i = 0;
        while (i < resources.length) {
            builder.append('\n');
            builder.append(this.getResourceReplacementCode(resources[i]));
            ++i;
        }
        return builder.toString();
    }

    private String getResourceReplacementCode(IResource resource) throws DebugException {
        IPath path = resource.getProjectRelativePath();
        if (path == null) {
            this.fail(Messages.RubyHotCodeReplaceProvider_unableToComputeSourceFilePath);
        }
        return "load '" + path.toOSString() + "'";
    }

    private void fail(String message) throws DebugException {
        this.fail(message, null);
    }

    private void fail(Throwable e) throws DebugException {
        this.fail(e.getMessage(), e);
    }

    private void fail(String message, Throwable e) throws DebugException {
        throw new DebugException((IStatus)new Status(4, "org.eclipse.dltk.debug", 120, message, e));
    }
}

