/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.testing;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.tcl.internal.testing.TclTestingEngineManager;
import org.eclipse.dltk.tcl.testing.ITclTestingEngine;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.ModelElementLabelProvider;
import org.eclipse.dltk.ui.ScriptElementLabels;
import org.eclipse.dltk.ui.util.ExceptionHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class TclTestingLaunchShortcut
implements ILaunchShortcut {
    private static final String EMPTY_STRING = "";
    static /* synthetic */ Class class$0;

    public void launch(IEditorPart editor, String mode) {
        ISourceModule element = DLTKUIPlugin.getEditorInputModelElement((IEditorInput)editor.getEditorInput());
        if (element != null) {
            this.launch(new Object[]{element}, mode);
        } else {
            this.showNoTestsFoundDialog();
        }
    }

    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            this.launch(((IStructuredSelection)selection).toArray(), mode);
        } else {
            this.showNoTestsFoundDialog();
        }
    }

    private void launch(Object[] elements, String mode) {
        try {
            IModelElement elementToLaunch = null;
            if (elements.length == 1) {
                Object selected = elements[0];
                if (selected instanceof IFolder) {
                    this.performLaunch((IFolder)selected, mode);
                    return;
                }
                if (!(selected instanceof IModelElement) && selected instanceof IAdaptable) {
                    IAdaptable iAdaptable = (IAdaptable)selected;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.dltk.core.IModelElement");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    selected = iAdaptable.getAdapter((Class)clazz);
                }
                if (selected instanceof IModelElement) {
                    IModelElement element = (IModelElement)selected;
                    switch (element.getElementType()) {
                        case 2: {
                            IProject project = ((IScriptProject)element).getProject();
                            IFolder specFolder = project.getFolder("test");
                            if (specFolder == null || !specFolder.exists()) break;
                            this.performLaunch(specFolder, mode);
                            return;
                        }
                        case 3: 
                        case 4: {
                            this.performLaunch((IFolder)element.getResource(), mode);
                            return;
                        }
                        case 5: 
                        case 9: {
                            elementToLaunch = element;
                        }
                    }
                }
            }
            if (elementToLaunch == null) {
                this.showNoTestsFoundDialog();
                return;
            }
            this.performLaunch(elementToLaunch, mode);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (CoreException e) {
            ExceptionHandler.handle((CoreException)e, (Shell)this.getShell(), (String)"XUnit Launch", (String)"Launching of XUnit tests unexpectedly failed. Check log for details.");
        }
    }

    private void showNoTestsFoundDialog() {
        MessageDialog.openInformation((Shell)this.getShell(), (String)"XUnit Launch", (String)"No XUnit tests found.");
    }

    private void performLaunch(IModelElement element, String mode) throws InterruptedException, CoreException {
        ILaunchConfigurationWorkingCopy temparary = this.createLaunchConfiguration(element);
        if (temparary == null) {
            return;
        }
        ILaunchConfiguration config = this.findExistingLaunchConfiguration(temparary, mode);
        if (config == null) {
            config = temparary.doSave();
        }
        DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
    }

    private void performLaunch(IFolder folder, String mode) throws InterruptedException, CoreException {
        String name = folder.getName();
        String testName = name.substring(name.lastIndexOf(47) + 1);
        ILaunchConfigurationType configType = this.getLaunchManager().getLaunchConfigurationType(this.getLaunchConfigurationTypeId());
        ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(testName));
        wc.setAttribute("project", folder.getProject().getName());
        ILaunchConfiguration config = this.findExistingLaunchConfiguration(wc, mode);
        if (config == null) {
            config = wc.doSave();
        }
        DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
    }

    private IType chooseType(IType[] types, String mode) throws InterruptedException {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new ModelElementLabelProvider(2048));
        dialog.setElements((Object[])types);
        dialog.setTitle("Test Selection");
        if (mode.equals("debug")) {
            dialog.setMessage("Select Test to debug");
        } else {
            dialog.setMessage("Select Test to run");
        }
        dialog.setMultipleSelection(false);
        if (dialog.open() == 0) {
            return (IType)dialog.getFirstResult();
        }
        throw new InterruptedException();
    }

    private Shell getShell() {
        return DLTKUIPlugin.getActiveWorkbenchShell();
    }

    private ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    private ILaunchConfiguration chooseConfiguration(List configList, String mode) throws InterruptedException {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setElements(configList.toArray());
        dialog.setTitle("Select a Test Configuration");
        if (mode.equals("debug")) {
            dialog.setMessage("Select configuration to debug");
        } else {
            dialog.setMessage("Select configuration to run");
        }
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        throw new InterruptedException();
    }

    protected String getLaunchConfigurationTypeId() {
        return "org.eclipse.dltk.tcl.testing.launchConfig";
    }

    protected ILaunchConfigurationWorkingCopy createLaunchConfiguration(IModelElement element) throws CoreException {
        String testFileName;
        String name = ScriptElementLabels.getDefault().getTextLabel((Object)element, 65536L);
        String testName = name.substring(name.lastIndexOf(47) + 1);
        switch (element.getElementType()) {
            case 5: {
                testFileName = element.getResource().getProjectRelativePath().toPortableString();
                break;
            }
            case 9: {
                testFileName = element.getResource().getProjectRelativePath().toPortableString();
                element.getElementName();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid element type to create a launch configuration: " + element.getClass().getName());
            }
        }
        ILaunchConfigurationType configType = this.getLaunchManager().getLaunchConfigurationType(this.getLaunchConfigurationTypeId());
        ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(testName));
        wc.setAttribute("project", element.getScriptProject().getElementName());
        wc.setAttribute("org.eclipse.dltk.testing.TEST_KIND", "#");
        wc.setAttribute("mainScript", testFileName);
        wc.setAttribute("nature", "org.eclipse.dltk.tcl.core.nature");
        wc.setAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_OUTPUT_ON", "true");
        ITclTestingEngine[] engines = TclTestingEngineManager.getEngines();
        ISourceModule module = (ISourceModule)element.getAncestor(5);
        int i = 0;
        while (i < engines.length) {
            if (engines[i].isValidModule(module)) {
                wc.setAttribute("org.eclipse.dltk.testing.engineId", engines[i].getId());
                break;
            }
            ++i;
        }
        return wc;
    }

    protected String[] getAttributeNamesToCompare() {
        return new String[]{"project", "mainScript", "nature"};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean hasSameAttributes(ILaunchConfiguration config1, ILaunchConfiguration config2, String[] attributeToCompare) {
        try {
            int i = 0;
            while (true) {
                String val2;
                if (i >= attributeToCompare.length) {
                    return true;
                }
                String val1 = config1.getAttribute(attributeToCompare[i], EMPTY_STRING);
                if (!val1.equals(val2 = config2.getAttribute(attributeToCompare[i], EMPTY_STRING))) {
                    return false;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private ILaunchConfiguration findExistingLaunchConfiguration(ILaunchConfigurationWorkingCopy temporary, String mode) throws InterruptedException, CoreException {
        ILaunchConfiguration config;
        ILaunchConfigurationType configType = temporary.getType();
        ILaunchConfiguration[] configs = this.getLaunchManager().getLaunchConfigurations(configType);
        String[] attributeToCompare = this.getAttributeNamesToCompare();
        ArrayList<ILaunchConfiguration> candidateConfigs = new ArrayList<ILaunchConfiguration>(configs.length);
        int i = 0;
        while (i < configs.length) {
            config = configs[i];
            if (TclTestingLaunchShortcut.hasSameAttributes(config, (ILaunchConfiguration)temporary, attributeToCompare)) {
                candidateConfigs.add(config);
            }
            ++i;
        }
        int candidateCount = candidateConfigs.size();
        if (candidateCount == 0) {
            return null;
        }
        if (candidateCount == 1) {
            return (ILaunchConfiguration)candidateConfigs.get(0);
        }
        config = this.chooseConfiguration(candidateConfigs, mode);
        if (config != null) {
            return config;
        }
        return null;
    }
}

