/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import java.util.HashMap;

public class Keywords {
    public static final String FUNCTION = "function";
    public static final String NULL = "null";
    public static final String RETURN = "return";
    public static final String IF = "if";
    public static final String ELSE = "else";
    public static final String SWITCH = "switch";
    public static final String CASE = "case";
    public static final String BREAK = "break";
    public static final String CONTINUE = "continue";
    public static final String DEFAULT = "default";
    public static final String FOR = "for";
    public static final String EACH = "each";
    public static final String WHILE = "while";
    public static final String DO = "do";
    public static final String VAR = "var";
    public static final String CONST = "const";
    public static final String IN = "in";
    public static final String NEW = "new";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String TRY = "try";
    public static final String CATCH = "catch";
    public static final String FINALLY = "finally";
    public static final String INSTANCEOF = "instanceof";
    public static final String TYPEOF = "typeof";
    public static final String THIS = "this";
    public static final String THROW = "throw";
    public static final String EXPORT = "export";
    public static final String IMPORT = "import";
    public static final String WITH = "with";
    public static final String DELETE = "delete";
    public static final String GET = "get";
    public static final String SET = "set";
    public static final String VOID = "void";
    public static final String XML = "xml";
    public static final String NAMESPACE = "namespace";
    public static final String YIELD = "yield";
    public static final char SPACE_CHAR = ' ';
    public static final char LP = '(';
    public static final char RP = ')';
    public static final char LC = '{';
    public static final char RC = '}';
    public static final char LB = '[';
    public static final char RB = ']';
    public static final char DOT = '.';
    public static final char COMMA = ',';
    public static final char SEMI = ';';
    public static final char COLON = ':';
    public static final char STRING_QUOTE = '\"';
    public static final char ASSIGN = '=';
    public static final String ADDASS = "+=";
    public static final String SUBASS = "-=";
    public static final String MULASS = "*=";
    public static final String DIVASS = "/=";
    public static final String MODASS = "%=";
    public static final String XORASS = "^=";
    public static final String ANDASS = "&=";
    public static final String ORASS = "|=";
    public static final String SHLASS = "<<=";
    public static final String SHRASS = ">>=";
    public static final String SHUASS = ">>>=";
    public static final String INC = "++";
    public static final String DEC = "--";
    public static final char ADD = '+';
    public static final char SUB = '-';
    public static final char MUL = '*';
    public static final char DIV = '/';
    public static final char MOD = '%';
    public static final String LAND = "&&";
    public static final String LOR = "||";
    public static final char NOT = '!';
    public static final char OR = '|';
    public static final char XOR = '^';
    public static final char AND = '&';
    public static final char INV = '~';
    public static final String SHL = "<<";
    public static final String SHR = ">>";
    public static final String SHU = ">>>";
    public static final String EQ = "==";
    public static final String NEQ = "!=";
    public static final String SAME = "===";
    public static final String NSAME = "!==";
    public static final String LTE = "<=";
    public static final char LT = '<';
    public static final String GTE = ">=";
    public static final char GT = '>';
    public static final char HOOK = '?';
    private static final HashMap<Integer, String> map = new HashMap();

    static {
        map.put(18, FUNCTION);
        map.put(4, NULL);
        map.put(23, RETURN);
        map.put(19, IF);
        map.put(14, IF);
        map.put(24, SWITCH);
        map.put(8, CASE);
        map.put(7, BREAK);
        map.put(10, CONTINUE);
        map.put(11, DEFAULT);
        map.put(16, FOR);
        map.put(17, EACH);
        map.put(31, WHILE);
        map.put(13, DO);
        map.put(29, VAR);
        map.put(44, CONST);
        map.put(20, IN);
        map.put(22, NEW);
        map.put(5, TRUE);
        map.put(6, FALSE);
        map.put(27, TRY);
        map.put(9, CATCH);
        map.put(15, FINALLY);
        map.put(21, INSTANCEOF);
        map.put(28, TYPEOF);
        map.put(25, THIS);
        map.put(26, THROW);
        map.put(48, EXPORT);
        map.put(54, IMPORT);
        map.put(32, WITH);
        map.put(12, DELETE);
        map.put(33, GET);
        map.put(34, SET);
        map.put(30, VOID);
        map.put(37, XML);
        map.put(38, NAMESPACE);
        map.put(35, YIELD);
        map.put(105, String.valueOf('='));
        map.put(106, ADDASS);
        map.put(107, SUBASS);
        map.put(108, MULASS);
        map.put(117, DIVASS);
        map.put(109, MODASS);
        map.put(115, XORASS);
        map.put(113, ANDASS);
        map.put(114, ORASS);
        map.put(110, SHLASS);
        map.put(111, SHRASS);
        map.put(112, SHUASS);
        map.put(151, INC);
        map.put(150, DEC);
        map.put(91, INC);
        map.put(92, DEC);
        map.put(147, String.valueOf('-'));
        map.put(152, String.valueOf('+'));
        map.put(87, String.valueOf('+'));
        map.put(88, String.valueOf('-'));
        map.put(116, String.valueOf('/'));
        map.put(89, String.valueOf('*'));
        map.put(90, String.valueOf('%'));
        map.put(101, LAND);
        map.put(102, LOR);
        map.put(99, String.valueOf('!'));
        map.put(97, String.valueOf('|'));
        map.put(98, String.valueOf('^'));
        map.put(96, String.valueOf('&'));
        map.put(100, String.valueOf('~'));
        map.put(93, SHL);
        map.put(94, SHR);
        map.put(95, SHU);
        map.put(83, EQ);
        map.put(84, NEQ);
        map.put(81, LTE);
        map.put(79, String.valueOf('<'));
        map.put(82, GTE);
        map.put(80, String.valueOf('>'));
        map.put(85, SAME);
        map.put(86, NSAME);
        map.put(21, INSTANCEOF);
        map.put(28, TYPEOF);
        map.put(20, IN);
    }

    public static String fromToken(int token) {
        Integer tokenValue = token;
        if (map.containsKey(tokenValue)) {
            return map.get(tokenValue);
        }
        throw new IllegalArgumentException(Integer.toString(token));
    }

    private static String charToHexString(char ch) {
        return Integer.toHexString(ch).toUpperCase();
    }

    public static String encodeString(String s, char quoteChar) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\t': {
                    buffer.append("\\t");
                    break;
                }
                case '\b': {
                    buffer.append("\\b");
                    break;
                }
                case '\f': {
                    buffer.append("\\f");
                    break;
                }
                case '\r': {
                    buffer.append("\\r");
                    break;
                }
                case '\n': {
                    buffer.append("\\n");
                    break;
                }
                case '\\': {
                    buffer.append("\\\\");
                    break;
                }
                default: {
                    if (ch == quoteChar) {
                        buffer.append("\\");
                        buffer.append(quoteChar);
                        break;
                    }
                    if (ch > '\u0fff') {
                        buffer.append("\\u" + Keywords.charToHexString(ch));
                        break;
                    }
                    if (ch > '\u00ff') {
                        buffer.append("\\u0" + Keywords.charToHexString(ch));
                        break;
                    }
                    if (ch > '\u007f') {
                        buffer.append("\\u00" + Keywords.charToHexString(ch));
                        break;
                    }
                    buffer.append(ch);
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    public static boolean isKeyword(String value) {
        if (value == null || value.length() == 0) {
            return false;
        }
        if (map.containsValue(value.toLowerCase())) {
            int i = 0;
            while (i < value.length()) {
                if (!Character.isLetter(value.charAt(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }
}

