/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.search.indexing.core;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.index.Index;
import org.eclipse.dltk.core.search.indexing.IProjectIndexer;
import org.eclipse.dltk.core.search.indexing.IndexManager;
import org.eclipse.dltk.core.search.indexing.core.ExternalProjectFragmentRequest;
import org.eclipse.dltk.core.search.indexing.core.Messages;
import org.eclipse.dltk.core.search.indexing.core.ProjectRequest;
import org.eclipse.dltk.core.search.indexing.core.ReconcileSourceModuleRequest;
import org.eclipse.dltk.core.search.indexing.core.RemoveIndexRequest;
import org.eclipse.dltk.core.search.indexing.core.SourceIndexUtil;
import org.eclipse.dltk.core.search.indexing.core.SourceModuleRemoveRequest;
import org.eclipse.dltk.core.search.indexing.core.SourceModuleRequest;
import org.eclipse.dltk.internal.core.ExternalSourceModule;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.search.DLTKSearchDocument;
import org.eclipse.dltk.internal.core.search.processing.IJob;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractProjectIndexer
implements IProjectIndexer,
IProjectIndexer.Internal {
    private final IndexManager manager = ModelManager.getModelManager().getIndexManager();

    public void request(IJob job) {
        this.manager.request(job);
    }

    protected void requestIfNotWaiting(IJob job) {
        if (!this.manager.isJobWaiting(job)) {
            this.manager.request(job);
        }
    }

    public IndexManager getIndexManager() {
        return this.manager;
    }

    public void indexProject(IScriptProject project) {
        ProjectRequest request = new ProjectRequest(this, project, true);
        this.requestIfNotWaiting(request);
    }

    public void indexLibrary(IScriptProject project, IPath path) {
        try {
            IProjectFragment fragment = project.findProjectFragment(path);
            if (fragment != null) {
                if (!path.segment(0).equals("#special#builtin#")) {
                    ExternalProjectFragmentRequest request = new ExternalProjectFragmentRequest(this, fragment, DLTKLanguageManager.getLanguageToolkit(fragment));
                    this.requestIfNotWaiting(request);
                }
            } else {
                DLTKCore.warn(NLS.bind((String)Messages.MixinIndexer_unknownProjectFragment, (Object)path));
            }
        }
        catch (Exception e) {
            DLTKCore.error(NLS.bind((String)Messages.MixinIndexer_indexLibraryError, (Object)path), e);
        }
    }

    public void indexProjectFragment(IScriptProject project, IPath path) {
        IProjectFragment fragmentToIndex = null;
        try {
            IProjectFragment[] fragments;
            IProjectFragment[] iProjectFragmentArray = fragments = project.getProjectFragments();
            int n = fragments.length;
            int n2 = 0;
            while (n2 < n) {
                IProjectFragment fragment = iProjectFragmentArray[n2];
                if (fragment.getPath().equals((Object)path)) {
                    fragmentToIndex = fragment;
                    break;
                }
                ++n2;
            }
        }
        catch (ModelException e) {
            DLTKCore.error("Failed to index fragment:" + path.toString(), (Throwable)((Object)e));
        }
        if (fragmentToIndex == null || !fragmentToIndex.isExternal() || fragmentToIndex.isBuiltin()) {
            this.requestIfNotWaiting(new ProjectRequest(this, project, true));
            return;
        }
        this.requestIfNotWaiting(new ExternalProjectFragmentRequest(this, fragmentToIndex, DLTKLanguageManager.getLanguageToolkit(project)));
    }

    public void indexSourceModule(ISourceModule module, IDLTKLanguageToolkit toolkit) {
        this.request(new SourceModuleRequest(this, module, toolkit));
    }

    public void reconciled(ISourceModule workingCopy, IDLTKLanguageToolkit toolkit) {
        this.request(new ReconcileSourceModuleRequest(this, workingCopy, toolkit));
    }

    public void removeProjectFragment(IScriptProject project, IPath sourceFolder) {
        this.requestIfNotWaiting(new ProjectRequest(this, project, false));
    }

    public void removeSourceModule(IScriptProject project, String path) {
        this.request(new SourceModuleRemoveRequest(this, project, path));
    }

    public void removeProject(IPath projectPath) {
        this.requestIfNotWaiting(new RemoveIndexRequest(this, (IPath)new Path(projectPath.toString())));
    }

    public void removeLibrary(IScriptProject project, IPath path) {
        this.requestIfNotWaiting(new RemoveIndexRequest(this, (IPath)new Path(path.toString())));
    }

    public void startIndexing() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        try {
            IScriptProject[] projects = DLTKCore.create(workspace.getRoot()).getScriptProjects();
            int i = 0;
            while (i < projects.length) {
                this.requestIfNotWaiting(new ProjectRequest(this, projects[i], false));
                ++i;
            }
        }
        catch (Exception e) {
            DLTKCore.error(Messages.MixinIndexer_startIndexingError, e);
        }
    }

    public void indexSourceModule(Index index, IDLTKLanguageToolkit toolkit, ISourceModule module, IPath containerPath) {
        SearchParticipant participant = SearchEngine.getDefaultSearchParticipant();
        IPath path = module.getPath();
        DLTKSearchDocument document = new DLTKSearchDocument(path.toString(), containerPath, null, participant, module instanceof ExternalSourceModule, module.getScriptProject().getProject());
        document.toolkit = toolkit;
        String relativePath = SourceIndexUtil.containerRelativePath(containerPath, module, path);
        document.setContainerRelativePath(relativePath);
        index.remove(relativePath);
        document.setIndex(index);
        this.doIndexing(document, module);
    }

    public abstract void doIndexing(DLTKSearchDocument var1, ISourceModule var2);

    public Index getProjectIndex(IScriptProject project) {
        return this.getProjectIndex(project.getProject().getFullPath());
    }

    public Index getProjectIndex(IPath path) {
        return this.getIndexManager().getIndex(path, true, true);
    }

    public Index getProjectFragmentIndex(IProjectFragment fragment) {
        return this.getIndexManager().getIndex(fragment.getPath(), true, true);
    }
}

