/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.browsing;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.internal.ui.filters.NonScriptElementFilter;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.actions.SelectAllAction;
import org.eclipse.dltk.ui.browsing.LogicalPackage;
import org.eclipse.dltk.ui.browsing.ScriptBrowsingPart;
import org.eclipse.dltk.ui.browsing.TopLevelTypeProblemsLabelDecorator;
import org.eclipse.dltk.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.dltk.ui.viewsupport.DecoratingModelLabelProvider;
import org.eclipse.dltk.ui.viewsupport.ScriptUILabelProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;

public class TypesView
extends ScriptBrowsingPart {
    private SelectAllAction fSelectAllAction;

    protected ScriptUILabelProvider createLabelProvider() {
        return new AppearanceAwareLabelProvider(2815849278734377L, 1, DLTKUIPlugin.getDefault().getPreferenceStore());
    }

    protected StructuredViewer createViewer(Composite parent) {
        StructuredViewer viewer = super.createViewer(parent);
        return viewer;
    }

    public Object getAdapter(Class key) {
        return super.getAdapter(key);
    }

    protected void addFilters() {
        super.addFilters();
        this.getViewer().addFilter((ViewerFilter)new NonScriptElementFilter());
    }

    protected boolean isValidInput(Object element) {
        return element instanceof IScriptFolder;
    }

    protected boolean isValidElement(Object element) {
        if (element instanceof ISourceModule) {
            return super.isValidElement(((ISourceModule)element).getParent());
        }
        if (element instanceof IType) {
            IType type = (IType)element;
            return type.getDeclaringType() == null && this.isValidElement(type.getSourceModule());
        }
        return false;
    }

    protected IModelElement findElementToSelect(IModelElement je) {
        if (je == null) {
            return null;
        }
        switch (je.getElementType()) {
            case 7: {
                IType type = ((IType)je).getDeclaringType();
                if (type == null) {
                    type = (IType)je;
                }
                return type;
            }
            case 5: {
                return je;
            }
            case 10: {
                return this.findElementToSelect(je.getParent());
            }
        }
        if (je instanceof IMember) {
            return this.findElementToSelect((IModelElement)((IMember)je).getDeclaringType());
        }
        return null;
    }

    protected String getHelpContextId() {
        return "";
    }

    protected String getLinkToEditorKey() {
        return "org.eclipse.dltk.ui.browsing.types.to.editor";
    }

    protected void createActions() {
        super.createActions();
        this.fSelectAllAction = new SelectAllAction((TableViewer)this.getViewer());
    }

    protected void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)this.fSelectAllAction);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!this.needsToProcessSelectionChanged(part, selection)) {
            return;
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            Object selectedElement = sel.getFirstElement();
            if (sel.size() == 1 && selectedElement instanceof LogicalPackage) {
                IScriptFolder[] fragments = ((LogicalPackage)((Object)selectedElement)).getScriptFolders();
                List<IScriptFolder> selectedElements = Arrays.asList(fragments);
                if (selectedElements.size() > 1) {
                    this.adjustInput(part, selectedElements);
                    this.fPreviousSelectedElement = selectedElements;
                    this.fPreviousSelectionProvider = part;
                } else if (selectedElements.size() == 1) {
                    super.selectionChanged(part, (ISelection)new StructuredSelection((Object)selectedElements.get(0)));
                } else {
                    Assert.isLegal((boolean)false);
                }
                return;
            }
        }
        super.selectionChanged(part, selection);
    }

    private void adjustInput(IWorkbenchPart part, List selectedElements) {
        Object currentInput = this.getViewer().getInput();
        if (!selectedElements.equals(currentInput)) {
            this.setInput(selectedElements);
        }
    }

    protected DecoratingModelLabelProvider createDecoratingLabelProvider(ScriptUILabelProvider provider) {
        DecoratingModelLabelProvider decoratingLabelProvider = super.createDecoratingLabelProvider(provider);
        provider.addLabelDecorator(new TopLevelTypeProblemsLabelDecorator(null));
        return decoratingLabelProvider;
    }
}

