/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.validators.internal.externalchecker.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.dltk.internal.ui.util.TableLayoutComposite;
import org.eclipse.dltk.ui.util.PixelConverter;
import org.eclipse.dltk.ui.util.SWTFactory;
import org.eclipse.dltk.validators.internal.externalchecker.core.CustomWildcard;
import org.eclipse.dltk.validators.internal.externalchecker.core.ExternalCheckerWildcardManager;
import org.eclipse.dltk.validators.internal.externalchecker.ui.CustomWildcardsList;
import org.eclipse.dltk.validators.internal.externalchecker.ui.IWildcardListViewer;
import org.eclipse.dltk.validators.internal.externalchecker.ui.Messages;
import org.eclipse.dltk.validators.internal.externalchecker.ui.WildcardCellModifier;
import org.eclipse.dltk.validators.internal.externalchecker.ui.WildcardLabelProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class ExternalCheckerRulesBlock {
    private Composite fControl;
    Table fTable;
    TableViewer tViewer;
    private String[] columnNames = new String[]{"CHARACTER", "PATTERN", "DESCRIPTION"};
    private CustomWildcardsList wlist = new CustomWildcardsList();
    private Button addWCard;
    private Button removeWCard;

    public void refresh() {
        this.tViewer.refresh();
    }

    public void loadWildcards() {
        this.wlist.getWcards().clear();
        List wildcards = new ArrayList();
        wildcards = ExternalCheckerWildcardManager.loadCustomWildcards();
        int i = 0;
        while (i < wildcards.size()) {
            this.wlist.addWcard((CustomWildcard)wildcards.get(i));
            ++i;
        }
    }

    public void createControl(Composite ancestor) {
        this.loadWildcards();
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Font font = ancestor.getFont();
        parent.setFont(font);
        parent.setLayout((Layout)layout);
        this.fControl = parent;
        PixelConverter conv = new PixelConverter((Control)parent);
        GridData data = new GridData(1808);
        data.widthHint = conv.convertWidthInCharsToPixels(50);
        TableLayoutComposite tblComposite = new TableLayoutComposite(parent, 0);
        tblComposite.setLayoutData((Object)data);
        this.fTable = new Table((Composite)tblComposite, 67586);
        data = new GridData(1808);
        data.widthHint = 450;
        this.fTable.setLayoutData((Object)data);
        this.fTable.setFont(font);
        this.fTable.setHeaderVisible(true);
        this.fTable.setLinesVisible(true);
        TableColumn col1 = new TableColumn(this.fTable, 16384, 0);
        col1.setWidth(70);
        col1.setText(Messages.ExternalCheckerRulesBlock_char);
        TableColumn col2 = new TableColumn(this.fTable, 16384, 1);
        col2.setWidth(130);
        col2.setText(Messages.ExternalCheckerRulesBlock_pattern);
        TableColumn col3 = new TableColumn(this.fTable, 16384, 2);
        col3.setWidth(100);
        col3.setText(Messages.ExternalCheckerRulesBlock_description);
        this.tViewer = new TableViewer(this.fTable);
        this.tViewer.setColumnProperties(this.columnNames);
        CellEditor[] editors = new CellEditor[this.columnNames.length];
        TextCellEditor textEditor = new TextCellEditor((Composite)this.fTable);
        ((Text)textEditor.getControl()).setTextLimit(60);
        editors[0] = textEditor;
        TextCellEditor textEditor2 = new TextCellEditor((Composite)this.fTable);
        editors[1] = textEditor2;
        TextCellEditor textEditor3 = new TextCellEditor((Composite)this.fTable);
        editors[2] = textEditor3;
        this.tViewer.setCellEditors(editors);
        this.tViewer.setCellModifier((ICellModifier)new WildcardCellModifier(this));
        this.tViewer.setContentProvider((IContentProvider)new WildcardContentProvider());
        this.tViewer.setLabelProvider((IBaseLabelProvider)new WildcardLabelProvider());
        this.tViewer.setInput((Object)this.getWlist());
        Composite buttons = new Composite(parent, 0);
        buttons.setLayoutData((Object)new GridData(2));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        buttons.setFont(font);
        this.addWCard = SWTFactory.createPushButton((Composite)buttons, (String)Messages.ExternalCheckerRulesBlock_add, null);
        this.addWCard.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                ExternalCheckerRulesBlock.this.getWlist().addWcard();
            }
        });
        this.removeWCard = SWTFactory.createPushButton((Composite)buttons, (String)Messages.ExternalCheckerRulesBlock_remove, null);
        this.removeWCard.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                CustomWildcard rule = (CustomWildcard)((IStructuredSelection)ExternalCheckerRulesBlock.this.tViewer.getSelection()).getFirstElement();
                if (rule != null) {
                    ExternalCheckerRulesBlock.this.wlist.removeWcard(rule);
                }
            }
        });
    }

    public void createControl2(Composite ancestor) {
        this.loadWildcards();
        Composite parent = new Composite(ancestor, 0);
        Font font = ancestor.getFont();
        parent.setFont(font);
        this.fControl = parent;
        GridLayout layout = (GridLayout)ancestor.getLayout();
        this.fTable = new Table(ancestor, 101124);
        this.fTable.setLayout((Layout)layout);
        this.fTable.setLinesVisible(true);
        this.fTable.setHeaderVisible(true);
        this.fTable.setSize(500, 500);
        TableColumn col1 = new TableColumn(this.fTable, 16384, 0);
        col1.setWidth(200);
        col1.setText(Messages.ExternalCheckerRulesBlock_char);
        TableColumn col2 = new TableColumn(this.fTable, 16384, 1);
        col2.setWidth(100);
        col2.setText(Messages.ExternalCheckerRulesBlock_pattern);
        this.tViewer = new TableViewer(this.fTable);
        this.tViewer.setColumnProperties(this.columnNames);
        CellEditor[] editors = new CellEditor[this.columnNames.length];
        TextCellEditor textEditor = new TextCellEditor((Composite)this.fTable);
        ((Text)textEditor.getControl()).setTextLimit(60);
        editors[0] = textEditor;
        TextCellEditor textEditor2 = new TextCellEditor((Composite)this.fTable);
        editors[1] = textEditor2;
        this.tViewer.setCellEditors(editors);
        this.tViewer.setCellModifier((ICellModifier)new WildcardCellModifier(this));
        this.tViewer.setContentProvider((IContentProvider)new WildcardContentProvider());
        this.tViewer.setLabelProvider((IBaseLabelProvider)new WildcardLabelProvider());
        this.tViewer.setInput((Object)this.getWlist());
        this.addWCard = new Button(ancestor, 8);
        this.addWCard.setText(Messages.ExternalCheckerRulesBlock_addRule);
        this.addWCard.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                ExternalCheckerRulesBlock.this.getWlist().addWcard();
            }
        });
    }

    public Control getControl() {
        return this.fControl;
    }

    protected Shell getShell() {
        return this.getControl().getShell();
    }

    public List getColumnNames() {
        return Arrays.asList(this.columnNames);
    }

    public void setWlist(CustomWildcardsList wlist) {
        this.wlist = wlist;
    }

    public CustomWildcardsList getWlist() {
        return this.wlist;
    }

    public void removeAll() {
        this.getWlist().removeAll();
    }

    class WildcardContentProvider
    implements IStructuredContentProvider,
    IWildcardListViewer {
        WildcardContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ExternalCheckerRulesBlock.this.getWlist().getWcards().toArray();
        }

        public void dispose() {
            ExternalCheckerRulesBlock.this.getWlist().removeChangeListener(this);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput != null) {
                ((CustomWildcardsList)newInput).addChangeListener(this);
            }
            if (oldInput != null) {
                ((CustomWildcardsList)oldInput).removeChangeListener(this);
            }
        }

        public void addWildcard(CustomWildcard r) {
            ExternalCheckerRulesBlock.this.tViewer.add((Object)r);
        }

        public void removeWildcard(CustomWildcard r) {
            ExternalCheckerRulesBlock.this.tViewer.remove((Object)r);
        }

        public void updateWildcard(CustomWildcard r) {
            ExternalCheckerRulesBlock.this.tViewer.update((Object)r, null);
        }
    }
}

