/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.core.search;

import org.eclipse.dltk.core.ISearchPatternProcessor;
import org.eclipse.dltk.core.search.SearchPatternProcessor;

public class RubySearchPatternProcessor
extends SearchPatternProcessor {
    private static final String TYPE_DELIMITER = "::";
    private static final String METHOD_DELIMITER = "::";

    public char[] extractDeclaringTypeQualification(String pattern) {
        int pos = pattern.lastIndexOf("::");
        if (pos != -1) {
            String type = pattern.substring(0, pos);
            return this.extractTypeQualification(type);
        }
        return null;
    }

    public char[] extractDeclaringTypeSimpleName(String pattern) {
        int pos = pattern.lastIndexOf("::");
        if (pos != -1) {
            String type = pattern.substring(0, pos);
            return this.extractTypeChars(type).toCharArray();
        }
        return null;
    }

    public char[] extractSelector(String pattern) {
        int begin;
        int pos = pattern.lastIndexOf("::");
        if (pos != -1 && (begin = pos + "::".length()) < pattern.length()) {
            char[] result = new char[pattern.length() - begin];
            pattern.getChars(begin, pattern.length(), result, 0);
            return result;
        }
        return pattern.toCharArray();
    }

    public ISearchPatternProcessor.ITypePattern parseType(String patternString) {
        int pos = patternString.lastIndexOf("::");
        if (pos != -1) {
            return new SearchPatternProcessor.TypePatten(patternString.substring(0, pos).replace("::", TYPE_SEPARATOR_STR), patternString.substring(pos + "::".length()));
        }
        return new SearchPatternProcessor.TypePatten(null, patternString);
    }

    public String getDelimiterReplacementString() {
        return "::";
    }
}

