/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.structure;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.dltk.compiler.ISourceElementRequestor;
import org.eclipse.dltk.compiler.SourceElementRequestorKind;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.compiler.problem.ProblemSeverity;
import org.eclipse.dltk.core.ISourceElementParser;
import org.eclipse.dltk.core.builder.ISourceLineTracker;
import org.eclipse.dltk.tcl.ast.TclCommand;
import org.eclipse.dltk.tcl.ast.TclModule;
import org.eclipse.dltk.tcl.core.TclPlugin;
import org.eclipse.dltk.tcl.internal.parser.NewTclSourceParser;
import org.eclipse.dltk.tcl.internal.parser.TclSourceElementParser;
import org.eclipse.dltk.tcl.internal.structure.ModelBuilderManager;
import org.eclipse.dltk.tcl.internal.structure.TclModelBuildContext;
import org.eclipse.dltk.tcl.parser.ITclErrorReporter;
import org.eclipse.dltk.tcl.parser.TclErrorCollector;
import org.eclipse.dltk.tcl.parser.TclParser;
import org.eclipse.dltk.tcl.parser.TclParserUtils;
import org.eclipse.dltk.tcl.parser.TclVisitor;
import org.eclipse.dltk.tcl.parser.definitions.DefinitionManager;
import org.eclipse.dltk.tcl.parser.definitions.IScopeProcessor;
import org.eclipse.dltk.tcl.parser.definitions.NamespaceScopeProcessor;
import org.eclipse.dltk.tcl.structure.ITclModelBuildContext;
import org.eclipse.dltk.tcl.structure.ITclModelBuilder;
import org.eclipse.dltk.tcl.structure.ITclModelBuilderDetector;
import org.eclipse.dltk.tcl.structure.TclModelProblem;
import org.eclipse.dltk.tcl.structure.TclProcessorUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TclSourceElementParser2
extends TclSourceElementParser
implements ISourceElementParser {
    public static final boolean USE_NEW = true;
    protected ITclModelBuilderDetector[] detectors = null;
    private Map<String, ITclModelBuilder> builders = new HashMap<String, ITclModelBuilder>();
    private static final ITclModelBuilder NULL_BUILDER = new ITclModelBuilder(){

        public boolean process(TclCommand command, ITclModelBuildContext context) {
            return true;
        }
    };
    private static final Set<String> LOGGED_BUILDERS = Collections.synchronizedSet(new HashSet());

    public void parseSourceModule(IModuleSource module) {
        ISourceElementRequestor requestor = this.getRequestor();
        if (SourceElementRequestorKind.STRUCTURE.matches(requestor)) {
            this.initDetectors();
            IProblemReporter reporter = this.getProblemReporter();
            TclErrorCollector collector = reporter != null ? new TclErrorCollector() : null;
            String source = module.getSourceContents();
            TclModelBuildContext context = new TclModelBuildContext(this, requestor, (ITclErrorReporter)collector);
            requestor.enterModule();
            TclParser newParser = this.createParser();
            NamespaceScopeProcessor coreProcessor = DefinitionManager.getInstance().createProcessor();
            TclModule tclModule = newParser.parseModule(source, context.getErrorReporter(), (IScopeProcessor)coreProcessor);
            this.traverse((List<TclCommand>)tclModule.getStatements(), context);
            requestor.exitModule(source.length());
            if (collector != null) {
                ISourceLineTracker tracker = NewTclSourceParser.createLineTracker(tclModule);
                collector.reportAll(reporter, tracker);
            }
        } else {
            super.parseSourceModule(module);
        }
    }

    public List<TclCommand> parse(String source, int offset) {
        this.initDetectors();
        TclModelBuildContext context = new TclModelBuildContext(this, this.getRequestor(), new ITclErrorReporter(){

            public void report(int code, String message, String[] extraMessage, int start, int end, ProblemSeverity kind) {
            }
        });
        TclParser newParser = this.createParser();
        newParser.setGlobalOffset(offset);
        NamespaceScopeProcessor coreProcessor = DefinitionManager.getInstance().createProcessor();
        List commands = newParser.parse(source, context.getErrorReporter(), (IScopeProcessor)coreProcessor);
        this.traverse(commands, context);
        return commands;
    }

    protected TclParser createParser() {
        return new TclParser();
    }

    protected void traverse(List<TclCommand> commands, TclModelBuildContext context) {
        TclParserUtils.traverse(commands, (TclVisitor)new TclModelBuilderVisitor(context));
    }

    private void initDetectors() {
        if (this.detectors == null) {
            this.detectors = ModelBuilderManager.getInstance().getDetectors();
        }
    }

    protected ITclModelBuilder getBuilder(String id, boolean logMissingAsError) {
        ITclModelBuilder builder = this.builders.get(id);
        if (builder == null) {
            builder = ModelBuilderManager.getInstance().getModelBuilder(id);
            if (builder == null) {
                if (logMissingAsError && LOGGED_BUILDERS.add(id)) {
                    TclPlugin.error("Tcl Model Builder '" + id + "' is not found");
                }
                builder = NULL_BUILDER;
            }
            this.builders.put(id, builder);
        }
        return builder != NULL_BUILDER ? builder : null;
    }

    private class TclModelBuilderVisitor
    extends TclVisitor {
        private final TclModelBuildContext context;

        private TclModelBuilderVisitor(TclModelBuildContext context) {
            this.context = context;
        }

        public boolean visit(TclCommand command) {
            String commandName = TclProcessorUtil.asString(command.getName());
            ITclModelBuilderDetector[] iTclModelBuilderDetectorArray = TclSourceElementParser2.this.detectors;
            int n = TclSourceElementParser2.this.detectors.length;
            int n2 = 0;
            while (n2 < n) {
                ITclModelBuilderDetector detector = iTclModelBuilderDetectorArray[n2];
                String builderId = detector.detect(commandName, command, this.context);
                if (builderId != null) {
                    ITclModelBuilder builder = TclSourceElementParser2.this.getBuilder(builderId, true);
                    if (builder != null) {
                        try {
                            return builder.process(command, this.context);
                        }
                        catch (TclModelProblem tclModelProblem) {
                            return false;
                        }
                    }
                    return true;
                }
                ++n2;
            }
            ITclModelBuilder builder = TclSourceElementParser2.this.getBuilder(commandName, false);
            if (builder != null) {
                try {
                    return builder.process(command, this.context);
                }
                catch (TclModelProblem tclModelProblem) {
                    return false;
                }
            }
            return true;
        }

        public void endVisit(TclCommand command) {
            this.context.leave(command);
        }
    }
}

