/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.ui.interpreters;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.internal.debug.ui.interpreters.InterpretersMessages;
import org.eclipse.dltk.internal.launching.InterpreterDefinitionsContainer;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class InterpretersUpdater {
    private InterpreterDefinitionsContainer fOriginalInterpreters;

    public InterpretersUpdater() {
        this.saveCurrentAsOriginal();
    }

    private void saveCurrentAsOriginal() {
        this.fOriginalInterpreters = new InterpreterDefinitionsContainer();
        ScriptRuntime.DefaultInterpreterEntry[] entries = ScriptRuntime.getDefaultInterpreterIDs();
        int i = 0;
        while (i < entries.length) {
            ScriptRuntime.DefaultInterpreterEntry entry = entries[i];
            IInterpreterInstall def = ScriptRuntime.getDefaultInterpreterInstall((ScriptRuntime.DefaultInterpreterEntry)entry);
            if (def != null) {
                this.fOriginalInterpreters.setDefaultInterpreterInstallCompositeID(entry, ScriptRuntime.getCompositeIdFromInterpreter((IInterpreterInstall)def));
            }
            ++i;
        }
        IInterpreterInstallType[] types = ScriptRuntime.getInterpreterInstallTypes();
        int i2 = 0;
        while (i2 < types.length) {
            IInterpreterInstall[] installs = types[i2].getInterpreterInstalls();
            if (installs != null) {
                int j = 0;
                while (j < installs.length) {
                    this.fOriginalInterpreters.addInterpreter(installs[j]);
                    ++j;
                }
            }
            ++i2;
        }
    }

    public boolean updateInterpreterSettings(String langNatureId, IInterpreterInstall[] interpreters, IInterpreterInstall[] defaultInterpreters) {
        InterpreterDefinitionsContainer container = new InterpreterDefinitionsContainer();
        HashSet<String> envIds = new HashSet<String>();
        if (defaultInterpreters != null) {
            int i = 0;
            while (i < defaultInterpreters.length) {
                String defaultId = ScriptRuntime.getCompositeIdFromInterpreter((IInterpreterInstall)defaultInterpreters[i]);
                String environmentId = defaultInterpreters[i].getEnvironmentId();
                if (environmentId != null) {
                    ScriptRuntime.DefaultInterpreterEntry entry = new ScriptRuntime.DefaultInterpreterEntry(langNatureId, environmentId);
                    container.setDefaultInterpreterInstallCompositeID(entry, defaultId);
                    envIds.add(environmentId);
                }
                ++i;
            }
        }
        IEnvironment[] iEnvironmentArray = EnvironmentManager.getEnvironments();
        int n = iEnvironmentArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEnvironment environment = iEnvironmentArray[n2];
            if (!envIds.contains(environment.getId())) {
                ScriptRuntime.DefaultInterpreterEntry entry = new ScriptRuntime.DefaultInterpreterEntry(langNatureId, environment.getId());
                container.setDefaultInterpreterInstallCompositeID(entry, null);
            }
            ++n2;
        }
        int i = 0;
        while (i < interpreters.length) {
            container.addInterpreter(interpreters[i]);
            ++i;
        }
        iEnvironmentArray = this.fOriginalInterpreters.getInterpreterNatures();
        n = iEnvironmentArray.length;
        n2 = 0;
        while (n2 < n) {
            IEnvironment entry = iEnvironmentArray[n2];
            if (!langNatureId.equals(entry.getNature())) {
                String defaultId = this.fOriginalInterpreters.getDefaultInterpreterInstallCompositeID((ScriptRuntime.DefaultInterpreterEntry)entry);
                container.setDefaultInterpreterInstallCompositeID((ScriptRuntime.DefaultInterpreterEntry)entry, defaultId);
            }
            ++n2;
        }
        for (IInterpreterInstall install : this.fOriginalInterpreters.getInterpreterList()) {
            if (langNatureId.equals(install.getInterpreterInstallType().getNatureId())) continue;
            container.addInterpreter(install);
        }
        this.saveInterpreterDefinitions(container);
        this.saveCurrentAsOriginal();
        return true;
    }

    private void saveInterpreterDefinitions(final InterpreterDefinitionsContainer container) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            /*
             * Loose catch block
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        monitor.beginTask(InterpretersMessages.InterpretersUpdater_0, 100);
                        String xml = container.getAsXML();
                        monitor.worked(40);
                        ScriptRuntime.getPreferences().setValue(ScriptRuntime.PREF_INTERPRETER_XML, xml);
                        monitor.worked(30);
                        ScriptRuntime.savePreferences();
                        monitor.worked(30);
                    }
                    catch (IOException ioe) {
                        DLTKDebugUIPlugin.log(ioe);
                        monitor.done();
                    }
                    catch (ParserConfigurationException e) {
                        DLTKDebugUIPlugin.log(e);
                        monitor.done();
                    }
                    catch (TransformerException e) {
                        DLTKDebugUIPlugin.log(e);
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            DLTKDebugUIPlugin.getDefault().getWorkbench().getProgressService().busyCursorWhile(runnable);
        }
        catch (InvocationTargetException e) {
            DLTKDebugUIPlugin.log(e);
        }
        catch (InterruptedException e) {
            DLTKDebugUIPlugin.log(e);
        }
    }
}

