/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.typehierarchy;

import org.eclipse.dltk.core.Flags;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.hierarchy.TypeHierarchy;
import org.eclipse.dltk.internal.ui.typehierarchy.CumulativeType;
import org.eclipse.dltk.internal.ui.typehierarchy.TypeHierarchyLifeCycle;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.ScriptElementImageDescriptor;
import org.eclipse.dltk.ui.ScriptElementImageProvider;
import org.eclipse.dltk.ui.ScriptElementLabels;
import org.eclipse.dltk.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.dltk.ui.viewsupport.ScriptUILabelProvider;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class HierarchyLabelProvider
extends AppearanceAwareLabelProvider {
    private Color fGrayedColor;
    private Color fSpecialColor;
    private ViewerFilter fFilter;
    private TypeHierarchyLifeCycle fHierarchy;
    private ILabelProvider fScriptLabelProvider = null;

    public HierarchyLabelProvider(TypeHierarchyLifeCycle lifeCycle, IPreferenceStore store) {
        super(845524441759785L, 1, store);
        this.fHierarchy = lifeCycle;
        this.fFilter = null;
    }

    public ViewerFilter getFilter() {
        return this.fFilter;
    }

    public void setFilter(ViewerFilter filter) {
        this.fFilter = filter;
    }

    protected boolean isDifferentScope(IType type) {
        if (this.fFilter != null && !this.fFilter.select(null, null, (Object)type)) {
            return true;
        }
        IModelElement input = this.fHierarchy.getInputElement();
        if (input == null || input.getElementType() == 7) {
            return false;
        }
        IModelElement parent = type.getAncestor(input.getElementType());
        return !(input.getElementType() == 3 ? parent == null || parent.getElementName().equals(input.getElementName()) : input.equals(parent));
    }

    public String getText(Object element) {
        if (element instanceof CumulativeType) {
            CumulativeType cType = (CumulativeType)element;
            return super.getText(cType.getFirst());
        }
        if (element instanceof CumulativeType.Part) {
            CumulativeType.Part part = (CumulativeType.Part)element;
            return ScriptElementLabels.getDefault().getTextLabel(part.type.getSourceModule(), ScriptElementLabels.ALL_FULLY_QUALIFIED);
        }
        return super.getText(element);
    }

    private boolean isCustomTypeHierarchy() {
        ITypeHierarchy hierarchy = this.fHierarchy.getHierarchy();
        return hierarchy != null && !(hierarchy instanceof TypeHierarchy);
    }

    private ILabelProvider getScriptLabelProvider() {
        if (this.fScriptLabelProvider == null) {
            this.fScriptLabelProvider = new ScriptUILabelProvider();
        }
        return this.fScriptLabelProvider;
    }

    public Image getImage(Object element) {
        Image result = null;
        if (element instanceof IType) {
            if (this.isCustomTypeHierarchy()) {
                return this.getScriptLabelProvider().getImage(element);
            }
            Object desc = this.getTypeImageDescriptor((IType)element);
            if (desc != null) {
                if (element.equals(this.fHierarchy.getInputElement())) {
                    desc = new FocusDescriptor((ImageDescriptor)desc);
                }
                result = DLTKUIPlugin.getImageDescriptorRegistry().get((ImageDescriptor)desc);
            }
        } else if (element instanceof CumulativeType) {
            CumulativeType cType = (CumulativeType)element;
            Object desc = this.getTypeImageDescriptor(cType.getFirst());
            if (desc != null) {
                if (cType.contains(this.fHierarchy.getInputElement())) {
                    desc = new FocusDescriptor((ImageDescriptor)desc);
                }
                result = DLTKUIPlugin.getImageDescriptorRegistry().get((ImageDescriptor)desc);
            }
        } else if (element instanceof CumulativeType.Part) {
            CumulativeType.Part part = (CumulativeType.Part)element;
            result = super.getImage(part.type.getSourceModule());
            ScriptElementImageDescriptor desc = new ScriptElementImageDescriptor(ImageDescriptor.createFromImage((Image)result), 0, ScriptElementImageProvider.BIG_SIZE);
            result = DLTKUIPlugin.getImageDescriptorRegistry().get((ImageDescriptor)desc);
        } else {
            result = this.fImageLabelProvider.getImageLabel(element, this.evaluateImageFlags(element));
        }
        return this.decorateImage(result, element);
    }

    private ImageDescriptor getTypeImageDescriptor(IType type) {
        ITypeHierarchy hierarchy = this.fHierarchy.getHierarchy();
        if (hierarchy == null) {
            return new ScriptElementImageDescriptor(DLTKPluginImages.DESC_OBJS_CLASS, 0, ScriptElementImageProvider.BIG_SIZE);
        }
        int flags = hierarchy.getCachedFlags(type);
        if (flags == -1) {
            try {
                flags = type.getFlags();
                if (hierarchy instanceof TypeHierarchy) {
                    ((TypeHierarchy)hierarchy).cacheFlags(type, flags);
                }
            }
            catch (ModelException modelException) {}
        }
        ImageDescriptor desc = ScriptElementImageProvider.getTypeImageDescriptor(flags, this.isDifferentScope(type));
        boolean isInterface = Flags.isInterface((int)flags);
        int adornmentFlags = 0;
        if (Flags.isFinal((int)flags)) {
            adornmentFlags |= 2;
        }
        if (Flags.isAbstract((int)flags) && !isInterface) {
            adornmentFlags |= 1;
        }
        if (Flags.isStatic((int)flags)) {
            adornmentFlags |= 8;
        }
        return new ScriptElementImageDescriptor(desc, adornmentFlags, ScriptElementImageProvider.BIG_SIZE);
    }

    public Color getForeground(Object element) {
        if (element instanceof IMethod) {
            if (this.fSpecialColor == null) {
                this.fSpecialColor = Display.getCurrent().getSystemColor(10);
            }
            return this.fSpecialColor;
        }
        if (element instanceof IType && this.isDifferentScope((IType)element)) {
            if (this.fGrayedColor == null) {
                this.fGrayedColor = Display.getCurrent().getSystemColor(16);
            }
            return this.fGrayedColor;
        }
        return null;
    }

    private static class FocusDescriptor
    extends CompositeImageDescriptor {
        private ImageDescriptor fBase;

        public FocusDescriptor(ImageDescriptor base) {
            this.fBase = base;
        }

        protected void drawCompositeImage(int width, int height) {
            this.drawImage(this.getImageData(this.fBase), 0, 0);
        }

        private ImageData getImageData(ImageDescriptor descriptor) {
            ImageData data = descriptor.getImageData();
            if (data == null) {
                data = DEFAULT_IMAGE_DATA;
                DLTKUIPlugin.logErrorMessage("Image data not available: " + descriptor.toString());
            }
            return data;
        }

        protected Point getSize() {
            return ScriptElementImageProvider.BIG_SIZE;
        }

        public int hashCode() {
            return this.fBase.hashCode();
        }

        public boolean equals(Object object) {
            return object != null && FocusDescriptor.class.equals(object.getClass()) && ((FocusDescriptor)((Object)object)).fBase.equals(this.fBase);
        }
    }
}

