/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.testing.ui;

import org.eclipse.dltk.internal.testing.model.TestElement;
import org.eclipse.dltk.internal.testing.ui.TestRunnerViewPart;
import org.eclipse.dltk.testing.DLTKTestingMessages;
import org.eclipse.dltk.testing.model.ITestElement;
import org.eclipse.dltk.testing.model.ITestElementPredicate;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CopyFailureListAction
extends Action {
    private final Clipboard fClipboard;
    private final TestRunnerViewPart fRunner;

    public CopyFailureListAction(TestRunnerViewPart runner, Clipboard clipboard) {
        super(DLTKTestingMessages.CopyFailureList_action_label);
        this.fRunner = runner;
        this.fClipboard = clipboard;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.dltk.testing.copy_failure_list_action_context");
    }

    public void run() {
        block3: {
            TextTransfer plainTextTransfer = TextTransfer.getInstance();
            try {
                this.fClipboard.setContents((Object[])new String[]{this.getAllFailureTraces()}, new Transfer[]{plainTextTransfer});
            }
            catch (SWTError e) {
                if (e.code != 2002) {
                    throw e;
                }
                if (!MessageDialog.openQuestion((Shell)DLTKUIPlugin.getActiveWorkbenchShell(), (String)DLTKTestingMessages.CopyFailureList_problem, (String)DLTKTestingMessages.CopyFailureList_clipboard_busy)) break block3;
                this.run();
            }
        }
    }

    public String getAllFailureTraces() {
        StringBuffer buf = new StringBuffer();
        ITestElement[] failures = this.fRunner.getCurrentSession().getFailedTestElements(new ITestElementPredicate(){

            public boolean matches(ITestElement testElement) {
                return true;
            }
        });
        String lineDelim = System.getProperty("line.separator", "\n");
        int i = 0;
        while (i < failures.length) {
            TestElement failure = (TestElement)failures[i];
            buf.append(failure.getTestName()).append(lineDelim);
            String failureTrace = failure.getTrace();
            if (failureTrace != null) {
                int start = 0;
                while (start < failureTrace.length()) {
                    int idx = failureTrace.indexOf(10, start);
                    if (idx != -1) {
                        String line = failureTrace.substring(start, idx);
                        buf.append(line).append(lineDelim);
                        start = idx + 1;
                        continue;
                    }
                    start = Integer.MAX_VALUE;
                }
            }
            ++i;
        }
        return buf.toString();
    }
}

