/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.validators.core;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.validators.core.IValidatorOutput;
import org.eclipse.dltk.validators.core.IValidatorReporter;
import org.eclipse.dltk.validators.core.ValidatorReporter;
import org.eclipse.dltk.validators.internal.core.ValidatorsCore;

abstract class AbstractValidatorWorker {
    AbstractValidatorWorker() {
    }

    protected abstract String getMarkerId();

    protected abstract String getNullResourceMessage();

    protected abstract String getPluginId();

    protected abstract String getTaskName();

    protected int calcTotalWork(Object[] objects) {
        return objects.length;
    }

    protected void clean(IResource[] resources) {
        String markerType = this.getMarkerId();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            this.clean(resource, markerType);
            ++i;
        }
    }

    protected void clean(IResource resource) {
        this.clean(resource, this.getMarkerId());
    }

    protected void clean(IResource resource, String markerType) {
        try {
            resource.deleteMarkers(markerType, true, 2);
        }
        catch (CoreException e) {
            ValidatorsCore.log(e.getStatus());
        }
    }

    protected IValidatorReporter createValidatorReporter() {
        return new ValidatorReporter(this.getMarkerId());
    }

    protected boolean isValidatorConfigured() {
        return true;
    }

    abstract IResource getResource(Object var1);

    abstract boolean isValidResource(Object var1);

    abstract void runValidator(Object var1, IValidatorOutput var2, IValidatorReporter var3, IProgressMonitor var4) throws CoreException;

    final IStatus doValidate(Object[] objects, IValidatorOutput console, IProgressMonitor monitor) {
        if (!this.isValidatorConfigured()) {
            return Status.CANCEL_STATUS;
        }
        IValidatorReporter reporter = this.createValidatorReporter();
        monitor.beginTask(this.getTaskName(), this.calcTotalWork(objects));
        try {
            int i = 0;
            while (i < objects.length) {
                if (monitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                if (this.getResource(objects[i]) == null) {
                    Status status = new Status(2, this.getPluginId(), this.getNullResourceMessage());
                    ValidatorsCore.log((IStatus)status);
                } else {
                    this.validate(objects[i], reporter, console, monitor);
                }
                monitor.worked(1);
                ++i;
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    private void validate(Object object, IValidatorReporter reporter, IValidatorOutput console, IProgressMonitor monitor) {
        if (!this.isValidResource(object)) {
            return;
        }
        IResource resource = this.getResource(object);
        this.clean(resource);
        try {
            this.runValidator(object, console, reporter, monitor);
        }
        catch (CoreException e) {
            ValidatorsCore.log(e.getStatus());
        }
    }
}

