/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.indexing;

import java.io.File;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.tcl.indexing.DLTKEFSTclIndexer;

public class DLTKTclIndexer {
    public static final long VERSION = 200905291444L;
    DLTKEFSTclIndexer realIndexer = new DLTKEFSTclIndexer(){

        public void logBeginOfFolder(IFileStore folder) {
            try {
                DLTKTclIndexer.this.logBeginOfFolder(folder.toLocalFile(0, (IProgressMonitor)new NullProgressMonitor()));
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }

        public void logEntry(IFileStore indexFile, long filesSize) {
            try {
                DLTKTclIndexer.this.logEntry(indexFile.toLocalFile(0, (IProgressMonitor)new NullProgressMonitor()), filesSize);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }

        protected void logIndexConsistent(IFileStore folder) {
            try {
                DLTKTclIndexer.this.logIndexConsistent(folder.toLocalFile(0, (IProgressMonitor)new NullProgressMonitor()));
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }

        protected void reportUnknownError(IFileStore folder) {
            try {
                DLTKTclIndexer.this.reportUnknownError(folder.toLocalFile(0, (IProgressMonitor)new NullProgressMonitor()));
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    };

    public boolean isForceRebuild() {
        return this.realIndexer.isForceRebuild();
    }

    public void buildIndexFor(File folder, boolean recursive) {
        this.realIndexer.buildIndexFor(EFS.getLocalFileSystem().getStore((IPath)new Path(folder.getAbsolutePath())), recursive);
    }

    protected void logIndexConsistent(File folder) {
    }

    public void logBeginOfFolder(File folder) {
    }

    public void logEntry(File indexFile, long filesSize) {
    }

    protected void reportUnknownError(File folder) {
    }

    public long getTotalSize() {
        return this.realIndexer.getTotalSize();
    }

    public long getTotalIndexesSize() {
        return this.realIndexer.getTotalIndexesSize();
    }

    public long getBasicIndexesSize() {
        return this.realIndexer.getBasicIndexesSize();
    }

    public long getASTIndexesSize() {
        return this.realIndexer.getASTIndexesSize();
    }
}

