/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.editor.selectionaction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.SourceRange;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.internal.ui.editor.selectionaction.SelectionActionMessages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IUpdate;

public class GoToNextPreviousMemberAction
extends Action
implements IUpdate {
    public static final String NEXT_MEMBER = "GoToNextMember";
    public static final String PREVIOUS_MEMBER = "GoToPreviousMember";
    private ScriptEditor fEditor;
    private boolean fIsGotoNext;

    public static GoToNextPreviousMemberAction newGoToNextMemberAction(ScriptEditor editor) {
        String text = SelectionActionMessages.GotoNextMember_label;
        return new GoToNextPreviousMemberAction(editor, text, true);
    }

    public static GoToNextPreviousMemberAction newGoToPreviousMemberAction(ScriptEditor editor) {
        String text = SelectionActionMessages.GotoPreviousMember_label;
        return new GoToNextPreviousMemberAction(editor, text, false);
    }

    private GoToNextPreviousMemberAction(ScriptEditor editor, String text, boolean isGotoNext) {
        super(text);
        this.fEditor = editor;
        this.fIsGotoNext = isGotoNext;
    }

    public GoToNextPreviousMemberAction(boolean isSelectNext) {
        super("");
        this.fIsGotoNext = isSelectNext;
    }

    public void update() {
        this.setEnabled(true);
    }

    public final void run() {
        ITextSelection selection = this.getTextSelection();
        ISourceRange newRange = this.getNewSelectionRange(GoToNextPreviousMemberAction.createSourceRange(selection), null);
        if (selection.getOffset() == newRange.getOffset() && selection.getLength() == newRange.getLength()) {
            return;
        }
        this.fEditor.selectAndReveal(newRange.getOffset(), newRange.getLength());
    }

    private IType[] getTypes() throws ModelException {
        IEditorInput input = this.fEditor.getEditorInput();
        return DLTKUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(input).getTypes();
    }

    private ITextSelection getTextSelection() {
        return (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
    }

    public ISourceRange getNewSelectionRange(ISourceRange oldSourceRange, IType[] types) {
        try {
            Object[] offsetArray;
            if (types == null) {
                types = this.getTypes();
            }
            if ((offsetArray = GoToNextPreviousMemberAction.createOffsetArray(types)).length == 0) {
                return oldSourceRange;
            }
            Arrays.sort(offsetArray);
            Integer oldOffset = oldSourceRange.getOffset();
            int index = Arrays.binarySearch(offsetArray, oldOffset);
            if (this.fIsGotoNext) {
                return GoToNextPreviousMemberAction.createNewSourceRange(GoToNextPreviousMemberAction.getNextOffset(index, (Integer[])offsetArray, oldOffset));
            }
            return GoToNextPreviousMemberAction.createNewSourceRange(GoToNextPreviousMemberAction.getPreviousOffset(index, (Integer[])offsetArray, oldOffset));
        }
        catch (ModelException e) {
            DLTKUIPlugin.log(e);
            return oldSourceRange;
        }
    }

    private static Integer getPreviousOffset(int index, Integer[] offsetArray, Integer oldOffset) {
        if (index == -1) {
            return oldOffset;
        }
        if (index == 0) {
            return offsetArray[0];
        }
        if (index > 0) {
            return offsetArray[index - 1];
        }
        Assert.isTrue((index < -1 ? 1 : 0) != 0);
        int absIndex = Math.abs(index);
        return offsetArray[absIndex - 2];
    }

    private static Integer getNextOffset(int index, Integer[] offsetArray, Integer oldOffset) {
        if (index == -1) {
            return offsetArray[0];
        }
        if (index == 0) {
            if (offsetArray.length != 1) {
                return offsetArray[1];
            }
            return offsetArray[0];
        }
        if (index > 0) {
            if (index == offsetArray.length - 1) {
                return oldOffset;
            }
            return offsetArray[index + 1];
        }
        Assert.isTrue((index < -1 ? 1 : 0) != 0);
        int absIndex = Math.abs(index);
        if (absIndex > offsetArray.length) {
            return oldOffset;
        }
        return offsetArray[absIndex - 1];
    }

    private static ISourceRange createNewSourceRange(Integer offset) {
        return new SourceRange(offset.intValue(), 0);
    }

    private static Integer[] createOffsetArray(IType[] types) throws ModelException {
        ArrayList result = new ArrayList();
        int i = 0;
        while (i < types.length) {
            IType iType = types[i];
            GoToNextPreviousMemberAction.addOffset(result, iType.getNameRange().getOffset());
            GoToNextPreviousMemberAction.addOffset(result, iType.getSourceRange().getOffset() + iType.getSourceRange().getLength());
            GoToNextPreviousMemberAction.addMemberOffsetList(result, (IMember[])iType.getMethods());
            GoToNextPreviousMemberAction.addMemberOffsetList(result, (IMember[])iType.getFields());
            ++i;
        }
        return result.toArray(new Integer[result.size()]);
    }

    private static void addMemberOffsetList(List result, IMember[] members) throws ModelException {
        int i = 0;
        while (i < members.length) {
            GoToNextPreviousMemberAction.addOffset(result, GoToNextPreviousMemberAction.getOffset(members[i]));
            ++i;
        }
    }

    private static int getOffset(IMember iMember) throws ModelException {
        if (iMember.getNameRange() != null && iMember.getNameRange().getOffset() >= 0) {
            return iMember.getNameRange().getOffset();
        }
        return iMember.getSourceRange().getOffset();
    }

    private static ISourceRange createSourceRange(ITextSelection ts) {
        return new SourceRange(ts.getOffset(), ts.getLength());
    }

    private static void addOffset(List result, int offset) {
        if (offset >= 0) {
            result.add(offset);
        }
    }
}

