/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.search;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.internal.ui.search.SearchParticipantDescriptor;
import org.eclipse.dltk.internal.ui.search.SearchParticipantRecord;
import org.eclipse.dltk.ui.DLTKUIPlugin;

public class SearchParticipantsExtensionPoint {
    private Set<SearchParticipantDescriptor> fActiveParticipants = null;
    private static SearchParticipantsExtensionPoint fgInstance;

    public boolean hasAnyParticipants() {
        return Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.dltk.ui.queryParticipants").length > 0;
    }

    private synchronized Set<SearchParticipantDescriptor> getAllParticipants() {
        if (this.fActiveParticipants != null) {
            return this.fActiveParticipants;
        }
        IConfigurationElement[] allParticipants = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.dltk.ui.queryParticipants");
        this.fActiveParticipants = new HashSet<SearchParticipantDescriptor>(allParticipants.length);
        int i = 0;
        while (i < allParticipants.length) {
            SearchParticipantDescriptor descriptor = new SearchParticipantDescriptor(allParticipants[i]);
            IStatus status = descriptor.checkSyntax();
            if (status.isOK()) {
                this.fActiveParticipants.add(descriptor);
            } else {
                DLTKUIPlugin.log(status);
            }
            ++i;
        }
        return this.fActiveParticipants;
    }

    private void collectParticipants(IDLTKLanguageToolkit language, Set<SearchParticipantRecord> participants, IProject[] projects) {
        Iterator<SearchParticipantDescriptor> activeParticipants = this.getAllParticipants().iterator();
        HashSet<String> seenParticipants = new HashSet<String>();
        while (activeParticipants.hasNext()) {
            SearchParticipantDescriptor participant = activeParticipants.next();
            if (!participant.isEnabled() || !language.getNatureId().equals(participant.getLanguage())) continue;
            String id = participant.getID();
            int i = 0;
            while (i < projects.length) {
                if (!seenParticipants.contains(id)) {
                    try {
                        if (projects[i].hasNature(participant.getNature())) {
                            participants.add(new SearchParticipantRecord(participant, participant.create()));
                            seenParticipants.add(id);
                        }
                    }
                    catch (CoreException e) {
                        DLTKUIPlugin.log(e.getStatus());
                        participant.disable();
                    }
                }
                ++i;
            }
        }
    }

    public SearchParticipantRecord[] getSearchParticipants(IDLTKLanguageToolkit language, IProject[] concernedProjects) throws CoreException {
        HashSet<SearchParticipantRecord> participantSet = new HashSet<SearchParticipantRecord>();
        this.collectParticipants(language, participantSet, concernedProjects);
        return participantSet.toArray(new SearchParticipantRecord[participantSet.size()]);
    }

    public static synchronized SearchParticipantsExtensionPoint getInstance() {
        if (fgInstance == null) {
            fgInstance = new SearchParticipantsExtensionPoint();
        }
        return fgInstance;
    }

    public static void debugSetInstance(SearchParticipantsExtensionPoint instance) {
        fgInstance = instance;
    }
}

