/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.refactoring.rename;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.ui.text.DLTKWordIterator;

public class RenamingNameSuggestor {
    public static final int STRATEGY_EXACT = 1;
    public static final int STRATEGY_EMBEDDED = 2;
    public static final int STRATEGY_SUFFIX = 3;
    private static final String PLURAL_S = "s";
    private static final String PLURAL_IES = "ies";
    private static final String SINGULAR_Y = "y";
    private int fStrategy;
    private String[] fFieldPrefixes;
    private String[] fFieldSuffixes;
    private String[] fStaticFieldPrefixes;
    private String[] fStaticFieldSuffixes;
    private String[] fLocalPrefixes;
    private String[] fLocalSuffixes;
    private String[] fArgumentPrefixes;
    private String[] fArgumentSuffixes;
    private boolean fExtendedInterfaceNameMatching;
    private boolean fExtendedAllUpperCaseHunkMatching;
    private boolean fExtendedPluralMatching;

    public RenamingNameSuggestor() {
        this(3);
    }

    public RenamingNameSuggestor(int strategy) {
        Assert.isTrue((strategy >= 1 && strategy <= 3 ? 1 : 0) != 0);
        this.fStrategy = strategy;
        this.fExtendedInterfaceNameMatching = true;
        this.fExtendedAllUpperCaseHunkMatching = true;
        this.fExtendedPluralMatching = true;
        this.resetPrefixes();
    }

    public String suggestNewFieldName(IScriptProject project, String oldFieldName, boolean isStatic, String oldTypeName, String newTypeName) {
        this.initializePrefixesAndSuffixes(project);
        if (isStatic) {
            return this.suggestNewVariableName(this.fStaticFieldPrefixes, this.fStaticFieldSuffixes, oldFieldName, oldTypeName, newTypeName);
        }
        return this.suggestNewVariableName(this.fFieldPrefixes, this.fFieldSuffixes, oldFieldName, oldTypeName, newTypeName);
    }

    public String suggestNewLocalName(IScriptProject project, String oldLocalName, boolean isArgument, String oldTypeName, String newTypeName) {
        this.initializePrefixesAndSuffixes(project);
        if (isArgument) {
            return this.suggestNewVariableName(this.fArgumentPrefixes, this.fArgumentSuffixes, oldLocalName, oldTypeName, newTypeName);
        }
        return this.suggestNewVariableName(this.fLocalPrefixes, this.fLocalSuffixes, oldLocalName, oldTypeName, newTypeName);
    }

    public String suggestNewMethodName(String oldMethodName, String oldTypeName, String newTypeName) {
        Assert.isNotNull((Object)oldMethodName);
        Assert.isNotNull((Object)oldTypeName);
        Assert.isNotNull((Object)newTypeName);
        Assert.isTrue((oldMethodName.length() > 0 ? 1 : 0) != 0);
        Assert.isTrue((oldTypeName.length() > 0 ? 1 : 0) != 0);
        Assert.isTrue((newTypeName.length() > 0 ? 1 : 0) != 0);
        this.resetPrefixes();
        return this.match(oldTypeName, newTypeName, oldMethodName);
    }

    public String suggestNewVariableName(String[] prefixes, String[] suffixes, String oldVariableName, String oldTypeName, String newTypeName) {
        Assert.isNotNull((Object)prefixes);
        Assert.isNotNull((Object)suffixes);
        Assert.isNotNull((Object)oldVariableName);
        Assert.isNotNull((Object)oldTypeName);
        Assert.isNotNull((Object)newTypeName);
        Assert.isTrue((oldVariableName.length() > 0 ? 1 : 0) != 0);
        Assert.isTrue((oldTypeName.length() > 0 ? 1 : 0) != 0);
        Assert.isTrue((newTypeName.length() > 0 ? 1 : 0) != 0);
        String usedPrefix = this.findLongestPrefix(oldVariableName, prefixes);
        String usedSuffix = this.findLongestSuffix(oldVariableName, suffixes);
        String strippedVariableName = oldVariableName.substring(usedPrefix.length(), oldVariableName.length() - usedSuffix.length());
        String newVariableName = this.match(oldTypeName, newTypeName, strippedVariableName);
        return newVariableName != null ? String.valueOf(usedPrefix) + newVariableName + usedSuffix : null;
    }

    private String match(String oldTypeName, String newTypeName, String strippedVariableName) {
        String oldType = oldTypeName;
        String newType = newTypeName;
        if (this.fExtendedInterfaceNameMatching && this.isInterfaceName(oldType) && this.isInterfaceName(newType)) {
            oldType = this.getInterfaceName(oldType);
            newType = this.getInterfaceName(newType);
        }
        String newVariableName = this.matchDirect(oldType, newType, strippedVariableName);
        if (this.fExtendedPluralMatching && newVariableName == null && this.canPluralize(oldType)) {
            newVariableName = this.matchDirect(this.pluralize(oldType), this.pluralize(newType), strippedVariableName);
        }
        return newVariableName;
    }

    private String matchDirect(String oldType, String newType, String strippedVariableName) {
        String newVariableName = this.exactMatch(oldType, newType, strippedVariableName);
        if (newVariableName == null && this.fStrategy >= 2) {
            newVariableName = this.embeddedMatch(oldType, newType, strippedVariableName);
        }
        if (newVariableName == null && this.fStrategy >= 3) {
            newVariableName = this.suffixMatch(oldType, newType, strippedVariableName);
        }
        return newVariableName;
    }

    private String exactMatch(String oldTypeName, String newTypeName, String strippedVariableName) {
        String newName = this.exactDirectMatch(oldTypeName, newTypeName, strippedVariableName);
        if (newName != null) {
            return newName;
        }
        if (this.fExtendedAllUpperCaseHunkMatching && this.isUpperCaseCamelCaseHunk(oldTypeName)) {
            String oldTN = this.getFirstUpperRestLowerCased(oldTypeName);
            String newTN = this.isUpperCaseCamelCaseHunk(newTypeName) ? this.getFirstUpperRestLowerCased(newTypeName) : newTypeName;
            newName = this.exactDirectMatch(oldTN, newTN, strippedVariableName);
        }
        return newName;
    }

    private String exactDirectMatch(String oldTypeName, String newTypeName, String strippedVariableName) {
        if (strippedVariableName.equals(oldTypeName)) {
            return newTypeName;
        }
        if (strippedVariableName.equals(this.getLowerCased(oldTypeName))) {
            return this.getLowerCased(newTypeName);
        }
        return null;
    }

    private String embeddedMatch(String oldTypeName, String newTypeName, String strippedVariableName) {
        String lowerCaseVariable = strippedVariableName.toLowerCase();
        String lowerCaseOldTypeName = oldTypeName.toLowerCase();
        int presumedIndex = lowerCaseVariable.indexOf(lowerCaseOldTypeName);
        while (presumedIndex != -1) {
            String name;
            String presumedTypeName = strippedVariableName.substring(presumedIndex, presumedIndex + oldTypeName.length());
            String prefix = strippedVariableName.substring(0, presumedIndex);
            String suffix = strippedVariableName.substring(presumedIndex + oldTypeName.length());
            if (this.startsNewHunk(suffix) && (name = this.exactMatch(oldTypeName, newTypeName, presumedTypeName)) != null) {
                return String.valueOf(prefix) + name + suffix;
            }
            presumedIndex = lowerCaseVariable.indexOf(lowerCaseOldTypeName, presumedIndex + 1);
        }
        return null;
    }

    private String suffixMatch(String oldType, String newType, String strippedVariableName) {
        String varName;
        int newPrefixes;
        String[] suffixesOld = this.getSuffixes(oldType);
        String[] suffixesNew = this.getSuffixes(newType);
        String[] suffixesVar = this.getSuffixes(strippedVariableName);
        int min = Math.min(suffixesOld.length, suffixesNew.length);
        String[] suffixesOldEqual = new String[min];
        String[] suffixesNewEqual = new String[min];
        System.arraycopy(suffixesOld, suffixesOld.length - min, suffixesOldEqual, 0, min);
        System.arraycopy(suffixesNew, suffixesNew.length - min, suffixesNewEqual, 0, min);
        int endIndex = -1;
        int j = suffixesVar.length - 1;
        while (j >= 0) {
            String newHunkName = this.exactMatch(suffixesOldEqual[suffixesOldEqual.length - 1], suffixesNewEqual[suffixesNewEqual.length - 1], suffixesVar[j]);
            if (newHunkName != null) {
                endIndex = j;
                break;
            }
            --j;
        }
        if (endIndex == -1) {
            return null;
        }
        int stepBack = 0;
        int lastSuffixMatched = -1;
        int hunkInVarName = -1;
        int i = suffixesOldEqual.length - 1;
        while (i >= 0) {
            String newHunkName;
            hunkInVarName = endIndex - stepBack;
            ++stepBack;
            if (hunkInVarName < 0 || (newHunkName = this.exactMatch(suffixesOldEqual[i], suffixesNewEqual[i], suffixesVar[hunkInVarName])) == null) break;
            suffixesVar[hunkInVarName] = newHunkName;
            lastSuffixMatched = i--;
        }
        if (lastSuffixMatched == 0 && (newPrefixes = suffixesNew.length - suffixesNewEqual.length) > 0) {
            if (Character.isLowerCase(suffixesVar[hunkInVarName].charAt(0)) && Character.isUpperCase(suffixesOldEqual[lastSuffixMatched].charAt(0))) {
                suffixesVar[hunkInVarName] = this.getUpperCased(suffixesVar[hunkInVarName]);
                suffixesNew[0] = this.getLowerCased(suffixesNew[0]);
            }
            String[] newVariableName = new String[suffixesVar.length + newPrefixes];
            System.arraycopy(suffixesVar, 0, newVariableName, 0, hunkInVarName);
            System.arraycopy(suffixesNew, 0, newVariableName, hunkInVarName, newPrefixes);
            System.arraycopy(suffixesVar, hunkInVarName, newVariableName, hunkInVarName + newPrefixes, suffixesVar.length - hunkInVarName);
            suffixesVar = newVariableName;
        }
        if ((varName = this.concat(suffixesVar)).equals(strippedVariableName)) {
            return null;
        }
        return varName;
    }

    private boolean startsNewHunk(String string) {
        if (string.length() == 0) {
            return true;
        }
        return this.isLegalChar(string.charAt(0));
    }

    private boolean isUpperCaseCamelCaseHunk(String hunk) {
        if (hunk.length() < 2) {
            return false;
        }
        int i = 0;
        while (i < hunk.length()) {
            if (!this.isLegalChar(hunk.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isLegalChar(char c) {
        if (Character.isLetter(c)) {
            return Character.isUpperCase(c);
        }
        return true;
    }

    private String[] getSuffixes(String typeName) {
        int match;
        ArrayList<String> suffixes = new ArrayList<String>();
        DLTKWordIterator iterator = new DLTKWordIterator();
        iterator.setText(typeName);
        int lastmatch = 0;
        while ((match = iterator.next()) != -1) {
            suffixes.add(typeName.substring(lastmatch, match));
            lastmatch = match;
        }
        return suffixes.toArray(new String[0]);
    }

    private String concat(String[] suffixesNewEqual) {
        StringBuffer returner = new StringBuffer();
        int j = 0;
        while (j < suffixesNewEqual.length) {
            returner.append(suffixesNewEqual[j]);
            ++j;
        }
        return returner.toString();
    }

    private String getLowerCased(String name) {
        if (name.length() > 1) {
            return String.valueOf(Character.toLowerCase(name.charAt(0))) + name.substring(1);
        }
        return name.toLowerCase();
    }

    private String getUpperCased(String name) {
        if (name.length() > 1) {
            return String.valueOf(Character.toUpperCase(name.charAt(0))) + name.substring(1);
        }
        return name.toLowerCase();
    }

    private String getFirstUpperRestLowerCased(String name) {
        if (name.length() > 1) {
            return String.valueOf(Character.toUpperCase(name.charAt(0))) + name.substring(1).toLowerCase();
        }
        return name.toLowerCase();
    }

    private boolean isInterfaceName(String typeName) {
        return typeName.length() >= 2 && typeName.charAt(0) == 'I' && Character.isUpperCase(typeName.charAt(1));
    }

    private String getInterfaceName(String typeName) {
        return typeName.substring(1);
    }

    private String findLongestPrefix(String name, String[] prefixes) {
        String usedPrefix = "";
        int bestLen = 0;
        int i = 0;
        while (i < prefixes.length) {
            if (name.startsWith(prefixes[i]) && prefixes[i].length() > bestLen) {
                bestLen = prefixes[i].length();
                usedPrefix = prefixes[i];
            }
            ++i;
        }
        return usedPrefix;
    }

    private String findLongestSuffix(String name, String[] suffixes) {
        String usedPrefix = "";
        int bestLen = 0;
        int i = 0;
        while (i < suffixes.length) {
            if (name.endsWith(suffixes[i]) && suffixes[i].length() > bestLen) {
                bestLen = suffixes[i].length();
                usedPrefix = suffixes[i];
            }
            ++i;
        }
        return usedPrefix;
    }

    private boolean canPluralize(String typeName) {
        return !typeName.endsWith(PLURAL_S);
    }

    private String pluralize(String typeName) {
        if (typeName.endsWith(SINGULAR_Y)) {
            typeName = typeName.substring(0, typeName.length() - 1).concat(PLURAL_IES);
        } else if (!typeName.endsWith(PLURAL_S)) {
            typeName = typeName.concat(PLURAL_S);
        }
        return typeName;
    }

    private void resetPrefixes() {
        String[] empty = new String[]{};
        this.fFieldPrefixes = empty;
        this.fFieldSuffixes = empty;
        this.fStaticFieldPrefixes = empty;
        this.fStaticFieldSuffixes = empty;
        this.fLocalPrefixes = empty;
        this.fLocalSuffixes = empty;
        this.fArgumentPrefixes = empty;
        this.fArgumentSuffixes = empty;
    }

    private void initializePrefixesAndSuffixes(IScriptProject project) {
        if (DLTKCore.DEBUG) {
            System.err.println("Add code assist code here...");
        }
    }
}

