/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.testsrunner.internal.boost;

import java.text.MessageFormat;
import java.util.Stack;
import org.eclipse.cdt.testsrunner.internal.boost.BoostTestsRunnerMessages;
import org.eclipse.cdt.testsrunner.internal.boost.BoostTestsRunnerPlugin;
import org.eclipse.cdt.testsrunner.model.ITestItem;
import org.eclipse.cdt.testsrunner.model.ITestMessage;
import org.eclipse.cdt.testsrunner.model.ITestModelUpdater;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class BoostXmlLogHandler
extends DefaultHandler {
    private static final String XML_NODE_TEST_LOG = "TestLog";
    private static final String XML_NODE_TEST_SUITE = "TestSuite";
    private static final String XML_NODE_TEST_CASE = "TestCase";
    private static final String XML_NODE_TESTING_TIME = "TestingTime";
    private static final String XML_NODE_LAST_CHECKPOINT = "LastCheckpoint";
    private static final String XML_NODE_INFO = "Info";
    private static final String XML_NODE_MESSAGE = "Message";
    private static final String XML_NODE_WARNING = "Warning";
    private static final String XML_NODE_ERROR = "Error";
    private static final String XML_NODE_FATAL_ERROR = "FatalError";
    private static final String XML_NODE_EXCEPTION = "Exception";
    private static final String XML_NODE_CONTEXT = "Context";
    private static final String XML_NODE_FRAME = "Frame";
    private static final String XML_ATTR_TEST_SUITE_NAME = "name";
    private static final String XML_ATTR_TEST_CASE_NAME = "name";
    private static final String XML_ATTR_MESSAGE_FILE = "file";
    private static final String XML_ATTR_MESSAGE_LINE = "line";
    private static final int MAX_CONTEXT_LENGTH_IN_TREE = 50;
    private static final String DEFAULT_LOCATION_FILE = null;
    private static final int DEFAULT_LOCATION_LINE = -1;
    private ITestModelUpdater modelUpdater;
    private Stack<StringBuilder> elementDataStack = new Stack();
    private String fileName;
    private int lineNumber;
    private ITestItem.Status testStatus;
    private String lastTestCaseName = "";
    private static final int SAME_TEST_CASE_NAME_COUNT_START = 2;
    private int sameTestCaseNameCount = 2;
    private StringBuilder context = new StringBuilder();
    private boolean testCaseEnterDeferred = false;
    private StringBuilder testCaseName = new StringBuilder();

    BoostXmlLogHandler(ITestModelUpdater modelUpdater) {
        this.modelUpdater = modelUpdater;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) throws SAXException {
        if (qName == null) {
            throw this.createAndLogExceptionForElement(qName);
        }
        this.elementDataStack.push(new StringBuilder());
        switch (qName) {
            case "TestSuite": {
                String testSuiteName = attrs.getValue("name");
                this.modelUpdater.enterTestSuite(testSuiteName);
                break;
            }
            case "TestCase": {
                this.testCaseName.setLength(0);
                this.testCaseName.append(attrs.getValue("name"));
                if (this.lastTestCaseName.equals(this.testCaseName.toString())) {
                    this.testCaseName.append(" (" + this.sameTestCaseNameCount + ")");
                    ++this.sameTestCaseNameCount;
                } else {
                    this.lastTestCaseName = this.testCaseName.toString();
                    this.sameTestCaseNameCount = 2;
                }
                this.testCaseEnterDeferred = true;
                this.testStatus = ITestItem.Status.Passed;
                break;
            }
            case "Message": 
            case "Warning": 
            case "LastCheckpoint": 
            case "FatalError": 
            case "Info": 
            case "Error": {
                this.fileName = attrs.getValue(XML_ATTR_MESSAGE_FILE);
                String lineNumberStr = attrs.getValue(XML_ATTR_MESSAGE_LINE);
                this.lineNumber = lineNumberStr != null ? Integer.parseInt(lineNumberStr.trim()) : -1;
                break;
            }
            case "Exception": {
                this.fileName = DEFAULT_LOCATION_FILE;
                this.lineNumber = -1;
                break;
            }
            default: {
                throw this.createAndLogExceptionForElement(qName);
            }
            case "Context": 
            case "Frame": 
            case "TestLog": 
            case "TestingTime": 
        }
    }

    private void addCurrentMessage(ITestMessage.Level level) {
        Object text = this.elementDataStack.peek().toString().trim();
        if (this.testCaseEnterDeferred) {
            if (!this.context.isEmpty()) {
                this.testCaseName.append(BoostTestsRunnerMessages.BoostXmlLogHandler_ContextPrefix);
                if (this.context.length() > 50) {
                    this.testCaseName.append(this.context.subSequence(0, 50));
                    this.testCaseName.append(BoostTestsRunnerMessages.BoostXmlLogHandler_ContextOverflow);
                } else {
                    this.testCaseName.append((CharSequence)this.context);
                }
                this.testCaseName.append(BoostTestsRunnerMessages.BoostXmlLogHandler_ContextSuffix);
            }
            this.modelUpdater.enterTestCase(this.testCaseName.toString());
            this.testCaseEnterDeferred = false;
        }
        if (!this.context.isEmpty()) {
            text = (String)text + BoostTestsRunnerMessages.BoostXmlLogHandler_ContextHeader + this.context.toString().trim();
            this.context.setLength(0);
        }
        this.modelUpdater.addTestMessage(this.fileName, this.lineNumber, level, ((String)text).trim());
        this.fileName = DEFAULT_LOCATION_FILE;
        this.lineNumber = -1;
        if (level == ITestMessage.Level.Error || level == ITestMessage.Level.FatalError) {
            if (this.testStatus != ITestItem.Status.Aborted) {
                this.testStatus = ITestItem.Status.Failed;
            }
        } else if (level == ITestMessage.Level.Exception) {
            this.testStatus = ITestItem.Status.Aborted;
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (qName == null) {
            throw this.createAndLogExceptionForElement(qName);
        }
        switch (qName) {
            case "TestSuite": {
                this.modelUpdater.exitTestSuite();
                break;
            }
            case "TestCase": {
                if (this.testCaseEnterDeferred) {
                    this.modelUpdater.enterTestCase(this.testCaseName.toString());
                    this.testCaseEnterDeferred = false;
                }
                this.modelUpdater.setTestStatus(this.testStatus);
                this.modelUpdater.exitTestCase();
                break;
            }
            case "TestingTime": {
                this.modelUpdater.setTestingTime(Integer.parseInt(this.elementDataStack.peek().toString().trim()) / 1000);
                break;
            }
            case "Info": {
                this.addCurrentMessage(ITestMessage.Level.Info);
                break;
            }
            case "Message": {
                this.addCurrentMessage(ITestMessage.Level.Message);
                break;
            }
            case "Warning": {
                this.addCurrentMessage(ITestMessage.Level.Warning);
                break;
            }
            case "Error": {
                this.addCurrentMessage(ITestMessage.Level.Error);
                break;
            }
            case "FatalError": {
                this.addCurrentMessage(ITestMessage.Level.FatalError);
                break;
            }
            case "Exception": {
                if (this.fileName != DEFAULT_LOCATION_FILE && !this.fileName.isEmpty() && this.lineNumber >= 0) {
                    StringBuilder current = this.elementDataStack.peek();
                    String trimmed = current.toString().trim();
                    current.setLength(0);
                    current.append(trimmed);
                    current.append(BoostTestsRunnerMessages.BoostXmlLogHandler_exception_suffix);
                }
                this.addCurrentMessage(ITestMessage.Level.Exception);
                break;
            }
            case "Context": {
                this.context.insert(0, this.elementDataStack.peek().toString().trim());
                break;
            }
            case "Frame": {
                this.context.append(this.elementDataStack.peek().toString().trim());
                break;
            }
            default: {
                throw this.createAndLogExceptionForElement(qName);
            }
            case "LastCheckpoint": 
            case "TestLog": 
        }
        this.elementDataStack.pop();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        StringBuilder builder = this.elementDataStack.peek();
        int i = start;
        while (i < start + length) {
            builder.append(ch[i]);
            ++i;
        }
    }

    private SAXException createAndLogExceptionForElement(String tagName) {
        SAXException e = new SAXException(MessageFormat.format(BoostTestsRunnerMessages.BoostXmlLogHandler_wrong_tag_name, tagName));
        BoostTestsRunnerPlugin.log(e);
        return e;
    }

    @Override
    public void warning(SAXParseException ex) throws SAXException {
        BoostTestsRunnerPlugin.log(ex);
    }

    @Override
    public void error(SAXParseException ex) throws SAXException {
        BoostTestsRunnerPlugin.log(ex);
        throw ex;
    }

    @Override
    public void fatalError(SAXParseException ex) throws SAXException {
        BoostTestsRunnerPlugin.log(ex);
        throw ex;
    }
}

