/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.internal.server;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import org.eclipse.cdt.lsp.internal.server.AsyncStreamPipe;
import org.eclipse.cdt.lsp.internal.server.LogProviderRegistry;
import org.eclipse.cdt.lsp.plugin.LspPlugin;
import org.eclipse.cdt.lsp.server.ICLanguageServerCommandLineValidator;
import org.eclipse.cdt.lsp.server.ICLanguageServerProvider;
import org.eclipse.cdt.lsp.server.ICLanguageServerProvider3;
import org.eclipse.cdt.lsp.server.ILogProvider;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.lsp4e.internal.NullSafetyHelper;
import org.eclipse.lsp4e.server.ProcessStreamConnectionProvider;

public final class CLanguageServerStreamConnectionProvider
extends ProcessStreamConnectionProvider {
    private final ICLanguageServerProvider provider;
    private Runnable errorStreamPipeStopper;
    private Optional<ILogProvider> logProvider = Optional.empty();

    public CLanguageServerStreamConnectionProvider() {
        this.provider = LspPlugin.getDefault().getCLanguageServerProvider();
        this.setWorkingDirectory(System.getProperty("user.dir"));
    }

    public Object getInitializationOptions(URI rootUri) {
        this.setCommands(this.provider.getCommands(rootUri));
        return this.provider.getInitializationOptions(rootUri);
    }

    protected ProcessBuilder createProcessBuilder() {
        if (this.logEnabled() && this.getLogProvider().isPresent()) {
            ProcessBuilder builder = new ProcessBuilder((List)NullSafetyHelper.castNonNull((Object)this.getCommands()));
            String workDir = this.getWorkingDirectory();
            if (workDir != null) {
                builder.directory(new File(workDir));
            }
            return builder;
        }
        return super.createProcessBuilder();
    }

    public void start() throws IOException {
        ICLanguageServerProvider iCLanguageServerProvider = this.provider;
        if (iCLanguageServerProvider instanceof ICLanguageServerCommandLineValidator) {
            ICLanguageServerCommandLineValidator validator = (ICLanguageServerCommandLineValidator)((Object)iCLanguageServerProvider);
            IStatus status = validator.validateCommandLineOptions();
            if (status.getSeverity() == 4) {
                throw new IOException(status.getMessage());
            }
            if (!status.isOK()) {
                Platform.getLog(((Object)((Object)this)).getClass()).log(status);
            }
        }
        super.start();
        if (this.logEnabled() && this.getLogProvider().isPresent()) {
            this.errorStreamPipeStopper = new AsyncStreamPipe().pipeTo("CDT LS stderr pipe", this.getErrorStream(), this.getLogProvider().get().getOutputStream());
        }
    }

    public void stop() {
        if (this.errorStreamPipeStopper != null) {
            this.errorStreamPipeStopper.run();
        }
        super.stop();
        this.getLogProvider().ifPresent(lp -> lp.close());
    }

    private boolean logEnabled() {
        ICLanguageServerProvider3 provider3;
        ICLanguageServerProvider iCLanguageServerProvider = this.provider;
        return iCLanguageServerProvider instanceof ICLanguageServerProvider3 && (provider3 = (ICLanguageServerProvider3)iCLanguageServerProvider).logToConsole();
    }

    private Optional<ILogProvider> getLogProvider() {
        if (this.logProvider.isEmpty()) {
            this.logProvider = LogProviderRegistry.createLogProvider();
        }
        return this.logProvider;
    }
}

