/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.infoviews;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.internal.ui.text.ScriptWordFinder;
import org.eclipse.dltk.internal.ui.util.SelectionUtil;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.ScriptElementLabels;
import org.eclipse.dltk.ui.actions.SelectionDispatchAction;
import org.eclipse.dltk.ui.infoviews.CopyToClipboardAction;
import org.eclipse.dltk.ui.infoviews.GotoInputAction;
import org.eclipse.dltk.ui.infoviews.ModelElementArray;
import org.eclipse.dltk.ui.infoviews.TextSelectionConverter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class AbstractInfoView
extends ViewPart
implements ISelectionListener,
IMenuListener,
IPropertyChangeListener {
    private final long TITLE_FLAGS = ScriptElementLabels.ALL_FULLY_QUALIFIED | 0x20L | 0x4000L | 1L | 2L | 0x10L | 0x8000L | 4L | 0x200000L | 0x1000000000000L;
    private static final long TOOLTIP_LABEL_FLAGS = ScriptElementLabels.DEFAULT_QUALIFIED | 0x40000000000L | 0x80000000000L | 1L | 2L | 0x20L | 0x10L | 0x4000L | 0x20L | 0x200000L;
    private IPartListener2 fPartListener = new IPartListener2(){

        public void partVisible(IWorkbenchPartReference ref) {
            if (ref.getId().equals(AbstractInfoView.this.getSite().getId())) {
                IWorkbenchPart activePart = ref.getPage().getActivePart();
                if (activePart != null) {
                    AbstractInfoView.this.selectionChanged(activePart, ref.getPage().getSelection());
                }
                AbstractInfoView.this.startListeningForSelectionChanges();
            }
        }

        public void partHidden(IWorkbenchPartReference ref) {
            if (ref.getId().equals(AbstractInfoView.this.getSite().getId())) {
                AbstractInfoView.this.stopListeningForSelectionChanges();
            }
        }

        public void partInputChanged(IWorkbenchPartReference ref) {
            if (!ref.getId().equals(AbstractInfoView.this.getSite().getId())) {
                AbstractInfoView.this.computeAndSetInput(ref.getPart(false));
            }
        }

        public void partActivated(IWorkbenchPartReference ref) {
        }

        public void partBroughtToTop(IWorkbenchPartReference ref) {
        }

        public void partClosed(IWorkbenchPartReference ref) {
        }

        public void partDeactivated(IWorkbenchPartReference ref) {
        }

        public void partOpened(IWorkbenchPartReference ref) {
        }
    };
    protected Object fCurrentViewInput;
    private SelectionDispatchAction fCopyToClipboardAction;
    private GotoInputAction fGotoInputAction;
    private volatile int fComputeCount;
    private IContextActivation fContextActivation;
    private Color fBackgroundColor;
    private RGB fBackgroundColorRGB;

    protected abstract void setInput(Object var1);

    protected abstract Object computeInput(Object var1);

    protected abstract void internalCreatePartControl(Composite var1);

    protected abstract void setForeground(Color var1);

    protected abstract void setBackground(Color var1);

    protected abstract Control getControl();

    protected abstract String getHelpContextId();

    public final void createPartControl(Composite parent) {
        this.internalCreatePartControl(parent);
        this.inititalizeColors();
        this.getSite().getWorkbenchWindow().getPartService().addPartListener(this.fPartListener);
        this.createActions();
        this.createContextMenu();
        this.fillActionBars(this.getViewSite().getActionBars());
        IContextService ctxService = (IContextService)this.getSite().getService(IContextService.class);
        if (ctxService != null) {
            this.fContextActivation = ctxService.activateContext("org.eclipse.dltk.ui.context.views");
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), this.getHelpContextId());
    }

    protected void createActions() {
        this.fGotoInputAction = new GotoInputAction(this);
        this.fGotoInputAction.setEnabled(false);
        this.fCopyToClipboardAction = new CopyToClipboardAction((IWorkbenchSite)this.getViewSite());
        ISelectionProvider provider = this.getSelectionProvider();
        if (provider != null) {
            provider.addSelectionChangedListener((ISelectionChangedListener)this.fCopyToClipboardAction);
        }
    }

    protected void createContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)this);
        Menu contextMenu = menuManager.createContextMenu(this.getControl());
        this.getControl().setMenu(contextMenu);
        this.getSite().registerContextMenu(menuManager, this.getSelectionProvider());
    }

    public void menuAboutToShow(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("group.open"));
        menu.add((IContributionItem)new Separator("group.edit"));
        menu.add((IContributionItem)new Separator("additions"));
        IAction action = this.getCopyToClipboardAction();
        if (action != null) {
            menu.appendToGroup("group.edit", action);
        }
        if ((action = this.getSelectAllAction()) != null) {
            menu.appendToGroup("group.edit", action);
        }
        menu.appendToGroup("group.open", (IAction)this.fGotoInputAction);
    }

    protected IAction getSelectAllAction() {
        return null;
    }

    protected IAction getCopyToClipboardAction() {
        return this.fCopyToClipboardAction;
    }

    protected Object getInput() {
        return this.fCurrentViewInput;
    }

    ISelectionProvider getSelectionProvider() {
        return this.getViewSite().getSelectionProvider();
    }

    protected void fillActionBars(IActionBars actionBars) {
        IToolBarManager toolBar = actionBars.getToolBarManager();
        this.fillToolBar(toolBar);
        IAction action = this.getCopyToClipboardAction();
        if (action != null) {
            actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), action);
        }
        if ((action = this.getSelectAllAction()) != null) {
            actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), action);
        }
    }

    protected void fillToolBar(IToolBarManager tbm) {
        tbm.add((IAction)this.fGotoInputAction);
    }

    private void inititalizeColors() {
        Color bgColor;
        if (this.getSite().getShell().isDisposed()) {
            return;
        }
        Display display = this.getSite().getShell().getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        this.setForeground(display.getSystemColor(28));
        ColorRegistry registry = JFaceResources.getColorRegistry();
        registry.addListener((IPropertyChangeListener)this);
        this.fBackgroundColorRGB = registry.getRGB(this.getBackgroundColorKey());
        if (this.fBackgroundColorRGB == null) {
            bgColor = display.getSystemColor(29);
            this.fBackgroundColorRGB = bgColor.getRGB();
        } else {
            this.fBackgroundColor = bgColor = new Color((Device)display, this.fBackgroundColorRGB);
        }
        this.setBackground(bgColor);
    }

    protected abstract String getBackgroundColorKey();

    public void propertyChange(PropertyChangeEvent event) {
        if (this.getBackgroundColorKey().equals(event.getProperty())) {
            this.inititalizeColors();
        }
    }

    protected void startListeningForSelectionChanges() {
        this.getSite().getPage().addPostSelectionListener((ISelectionListener)this);
    }

    protected void stopListeningForSelectionChanges() {
        this.getSite().getPage().removePostSelectionListener((ISelectionListener)this);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part.equals((Object)this)) {
            return;
        }
        this.computeAndSetInput(part);
    }

    protected boolean isIgnoringNewInput(Object je, IWorkbenchPart part, ISelection selection) {
        return this.fCurrentViewInput != null && this.fCurrentViewInput.equals(je) && je != null;
    }

    protected Object findSelectedModelElement(IWorkbenchPart part, ISelection selection) {
        try {
            if (this.isValidWorkbenchPart(part) && selection instanceof ITextSelection) {
                IEditorPart editor = (IEditorPart)part;
                Object[] elements = TextSelectionConverter.codeResolve(editor, (ITextSelection)selection);
                if (elements != null && elements.length > 0) {
                    return elements.length == 1 ? elements[0] : new ModelElementArray(elements);
                }
            } else if (selection instanceof IStructuredSelection) {
                Object element = SelectionUtil.getSingleElement(selection);
                return this.findModelElement(element);
            }
        }
        catch (ModelException e) {
            DLTKUIPlugin.log(e);
        }
        return null;
    }

    protected boolean isValidWorkbenchPart(IWorkbenchPart part) {
        return part instanceof IEditorPart;
    }

    private IModelElement findModelElement(Object element) {
        if (element != null && element instanceof IAdaptable) {
            return (IModelElement)((IAdaptable)element).getAdapter(IModelElement.class);
        }
        return null;
    }

    public final void dispose() {
        IContextService ctxService;
        ++this.fComputeCount;
        if (this.fContextActivation != null && (ctxService = (IContextService)this.getSite().getService(IContextService.class)) != null) {
            ctxService.deactivateContext(this.fContextActivation);
        }
        this.getSite().getWorkbenchWindow().getPartService().removePartListener(this.fPartListener);
        ISelectionProvider provider = this.getSelectionProvider();
        if (provider != null) {
            provider.removeSelectionChangedListener((ISelectionChangedListener)this.fCopyToClipboardAction);
        }
        JFaceResources.getColorRegistry().removeListener((IPropertyChangeListener)this);
        this.fBackgroundColorRGB = null;
        if (this.fBackgroundColor != null) {
            this.fBackgroundColor.dispose();
            this.fBackgroundColor = null;
        }
        this.internalDispose();
    }

    protected abstract void internalDispose();

    private void computeAndSetInput(final IWorkbenchPart part) {
        final int currentCount = ++this.fComputeCount;
        ISelectionProvider provider = part.getSite().getSelectionProvider();
        if (provider == null) {
            return;
        }
        final ISelection selection = provider.getSelection();
        if (selection == null || selection.isEmpty()) {
            return;
        }
        Thread thread = new Thread("Info view input computer"){

            @Override
            public void run() {
                ITextEditor edit;
                IDocument document;
                IRegion reg;
                if (currentCount != AbstractInfoView.this.fComputeCount) {
                    return;
                }
                Object je = AbstractInfoView.this.findSelectedModelElement(part, selection);
                Object tmp = null;
                if (je != null) {
                    tmp = je;
                } else if (part instanceof ITextEditor && selection instanceof ITextSelection && (reg = ScriptWordFinder.findWord(document = (edit = (ITextEditor)part).getDocumentProvider().getDocument((Object)edit.getEditorInput()), ((ITextSelection)selection).getOffset())) != null) {
                    try {
                        tmp = new KeywordInput(document.get(reg.getOffset(), reg.getLength()), (IModelElement)EditorUtility.getEditorInputModelElement((IEditorPart)edit, false));
                    }
                    catch (BadLocationException e) {
                        tmp = null;
                    }
                }
                Object src = tmp;
                if (AbstractInfoView.this.isIgnoringNewInput(src, part, selection)) {
                    return;
                }
                Object input = AbstractInfoView.this.computeInput(src);
                if (input == null) {
                    return;
                }
                Shell shell = AbstractInfoView.this.getSite().getShell();
                if (shell.isDisposed()) {
                    return;
                }
                Display display = shell.getDisplay();
                if (display.isDisposed()) {
                    return;
                }
                display.asyncExec(() -> {
                    if (AbstractInfoView.this.fComputeCount != currentCount || AbstractInfoView.this.getViewSite().getShell().isDisposed()) {
                        return;
                    }
                    AbstractInfoView.this.fCurrentViewInput = src;
                    AbstractInfoView.this.doSetInput(input);
                });
            }
        };
        thread.setDaemon(true);
        thread.setPriority(1);
        thread.start();
    }

    private void doSetInput(Object input) {
        this.setInput(input);
        Object in = this.getInput();
        this.fGotoInputAction.setEnabled(in instanceof IModelElement);
        if (in instanceof IModelElement) {
            IModelElement me = (IModelElement)in;
            this.setContentDescription(ScriptElementLabels.getDefault().getElementLabel(me, this.TITLE_FLAGS));
            this.setTitleToolTip(ScriptElementLabels.getDefault().getElementLabel(me, TOOLTIP_LABEL_FLAGS));
        } else if (in instanceof ModelElementArray) {
            ModelElementArray array = (ModelElementArray)in;
            this.setContentDescription(array.getContentDescription());
            this.setTitleToolTip(array.getTitleTooltip());
        } else if (in instanceof KeywordInput) {
            KeywordInput keyword = (KeywordInput)in;
            this.setContentDescription(keyword.getValue());
            this.setTitleToolTip(keyword.getValue());
        } else {
            this.setContentDescription(in.toString());
            this.setTitleToolTip(in.toString());
        }
    }

    protected static class KeywordInput {
        private final String value;
        private final IModelElement context;

        public KeywordInput(String value, IModelElement context) {
            this.value = value;
            this.context = context;
        }

        public String getValue() {
            return this.value;
        }

        public IModelElement getContext() {
            return this.context;
        }
    }
}

