/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.internal.provisional.model.MemoryBlockRetrievalFactory;
import org.eclipse.cdt.dsf.gdb.internal.GdbDebugOptions;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class GdbPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.cdt.dsf.gdb";
    private static GdbPlugin plugin;
    private static BundleContext fgBundleContext;
    private IAdapterFactory fMemoryRetrievalFactory = null;

    public void start(BundleContext context) throws Exception {
        fgBundleContext = context;
        super.start(context);
        plugin = this;
        new GdbDebugOptions(context);
        this.fMemoryRetrievalFactory = new MemoryBlockRetrievalFactory();
        Platform.getAdapterManager().registerAdapters(this.fMemoryRetrievalFactory, IDMContext.class);
    }

    public void stop(BundleContext context) throws Exception {
        this.shutdownActiveLaunches();
        plugin = null;
        if (this.fMemoryRetrievalFactory != null) {
            Platform.getAdapterManager().unregisterAdapters(this.fMemoryRetrievalFactory, IDMContext.class);
        }
        super.stop(context);
        fgBundleContext = null;
    }

    public static GdbPlugin getDefault() {
        return plugin;
    }

    public static BundleContext getBundleContext() {
        return fgBundleContext;
    }

    private void shutdownActiveLaunches() {
        DebugPlugin debugPlugin = DebugPlugin.getDefault();
        if (debugPlugin == null) {
            return;
        }
        ILaunch[] iLaunchArray = debugPlugin.getLaunchManager().getLaunches();
        int n = iLaunchArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            if (launch instanceof GdbLaunch && ((GdbLaunch)launch).getSession().isActive()) {
                final GdbLaunch gdbLaunch = (GdbLaunch)launch;
                Query<Object> launchShutdownQuery = new Query<Object>(){

                    protected void execute(DataRequestMonitor<Object> rm) {
                        gdbLaunch.shutdownSession((RequestMonitor)rm);
                    }
                };
                try {
                    gdbLaunch.getSession().getExecutor().execute((Runnable)launchShutdownQuery);
                }
                catch (RejectedExecutionException e) {
                    break;
                }
                try {
                    launchShutdownQuery.get(1L, TimeUnit.MINUTES);
                }
                catch (InterruptedException e) {
                    this.getLog().log((IStatus)new Status(4, PLUGIN_ID, "InterruptedException while shutting down launch " + String.valueOf(gdbLaunch), e.getCause()));
                }
                catch (ExecutionException e) {
                    this.getLog().log((IStatus)new Status(4, PLUGIN_ID, "Exception while shutting down launch " + String.valueOf(gdbLaunch), e.getCause()));
                }
                catch (TimeoutException e) {
                    this.getLog().log((IStatus)new Status(4, PLUGIN_ID, "TimeoutException while shutting down launch " + String.valueOf(gdbLaunch), e.getCause()));
                }
            }
            ++n2;
        }
    }

    public static String getDebugTime() {
        StringBuilder traceBuilder = new StringBuilder();
        long time = System.currentTimeMillis();
        long seconds = time / 1000L % 1000L;
        if (seconds < 100L) {
            traceBuilder.append('0');
        }
        if (seconds < 10L) {
            traceBuilder.append('0');
        }
        traceBuilder.append(seconds);
        traceBuilder.append(',');
        long millis = time % 1000L;
        if (millis < 100L) {
            traceBuilder.append('0');
        }
        if (millis < 10L) {
            traceBuilder.append('0');
        }
        traceBuilder.append(millis);
        return traceBuilder.toString();
    }

    public static String getUniqueIdentifier() {
        if (GdbPlugin.getDefault() == null) {
            return PLUGIN_ID;
        }
        return GdbPlugin.getDefault().getBundle().getSymbolicName();
    }

    public static void log(IStatus status) {
        GdbPlugin.getDefault().getLog().log(status);
    }

    public static void logErrorMessage(String message) {
        GdbPlugin.log((IStatus)new Status(4, GdbPlugin.getUniqueIdentifier(), 4, message, null));
    }

    public static void log(Throwable e) {
        GdbPlugin.log((IStatus)new Status(4, GdbPlugin.getUniqueIdentifier(), 4, e.getMessage(), e));
    }

    public static <T> T getService(Class<T> service) {
        BundleContext context = plugin.getBundle().getBundleContext();
        ServiceReference ref = context.getServiceReference(service);
        return (T)(ref != null ? context.getService(ref) : null);
    }
}

