/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.discovery.compatibility.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.discovery.compatibility.Activator;
import org.eclipse.equinox.internal.p2.discovery.compatibility.Messages;
import org.eclipse.equinox.internal.p2.repository.AuthenticationFailedException;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.internal.provisional.p2.repository.IStateful;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.osgi.util.NLS;

public class CacheManager {
    private static final String PREFIX = "discovery";
    private static final String DOWNLOADING = "downloading";
    private final Transport transport;

    public CacheManager(Transport transport) {
        this.transport = transport;
    }

    private int computeHash(URI location) {
        return location.hashCode();
    }

    public File createCache(URI location, IProgressMonitor monitor) throws IOException, ProvisionException {
        SubMonitor submonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1000);
        try {
            File cacheFile = this.getCache(location);
            boolean stale = true;
            long lastModified = 0L;
            if (cacheFile != null) {
                lastModified = cacheFile.lastModified();
            }
            long lastModifiedRemote = 0L;
            try {
                lastModifiedRemote = this.transport.getLastModified(location, (IProgressMonitor)submonitor.newChild(1));
                if (lastModifiedRemote <= 0L) {
                    LogHelper.log((IStatus)new Status(2, "org.eclipse.equinox.p2.discovery.compatibility", "Server returned lastModified <= 0 for " + String.valueOf(location)));
                }
            }
            catch (AuthenticationFailedException e) {
                throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.discovery.compatibility", 1007, NLS.bind((String)Messages.CacheManager_AuthenticationFaileFor_0, (Object)location), null));
            }
            catch (CoreException e) {
                throw new ProvisionException(e.getStatus());
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            if (submonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            boolean bl = stale = lastModifiedRemote > lastModified || lastModifiedRemote <= 0L;
            if (!stale) {
                File file = cacheFile;
                return file;
            }
            cacheFile = this.getCacheFile(location);
            this.updateCache(cacheFile, location, lastModifiedRemote, submonitor);
            File file = cacheFile;
            return file;
        }
        finally {
            submonitor.done();
        }
    }

    void deleteCache(URI location) {
        File cacheFile = this.getCache(location);
        this.safeDelete(cacheFile);
        this.safeDelete(new File(new File(cacheFile.getParentFile(), DOWNLOADING), cacheFile.getName()));
    }

    private File getCache(URI location) {
        File cacheFile = this.getCacheFile(location);
        return cacheFile.exists() ? cacheFile : null;
    }

    private File getCacheFile(URI location) {
        return new File(this.getCacheDirectory(), PREFIX + this.computeHash(location));
    }

    protected File getCacheDirectory() {
        return Activator.getDefault().getStateLocation().append("cache").toFile();
    }

    private boolean safeDelete(File file) {
        if (file.exists() && !file.delete()) {
            file.deleteOnExit();
            return true;
        }
        return false;
    }

    protected void updateCache(File cacheFile, URI remoteFile, long lastModifiedRemote, SubMonitor submonitor) throws FileNotFoundException, IOException, ProvisionException {
        IStatus result;
        File tempFile;
        block25: {
            cacheFile.getParentFile().mkdirs();
            File downloadDir = new File(cacheFile.getParentFile(), DOWNLOADING);
            if (!downloadDir.exists()) {
                downloadDir.mkdir();
            }
            if ((tempFile = new File(downloadDir, cacheFile.getName())).exists()) {
                this.safeDelete(tempFile);
            }
            tempFile.createNewFile();
            result = null;
            try {
                Throwable throwable = null;
                Object var10_11 = null;
                try (StatefulStream stream = new StatefulStream(new FileOutputStream(tempFile));){
                    try {
                        try {
                            submonitor.setWorkRemaining(1000);
                            result = this.transport.download(remoteFile, (OutputStream)stream, (IProgressMonitor)submonitor.newChild(1000));
                        }
                        catch (OperationCanceledException e) {
                            result = stream.getStatus();
                            if (result == null || !result.isOK()) {
                                this.safeDelete(tempFile);
                            }
                            break block25;
                        }
                    }
                    catch (Throwable throwable2) {
                        if (result == null || !result.isOK()) {
                            this.safeDelete(tempFile);
                        }
                        throw throwable2;
                    }
                    if (result == null || !result.isOK()) {
                        this.safeDelete(tempFile);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (FileNotFoundException e) {
                throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.discovery.compatibility", e.getMessage(), (Throwable)e));
            }
        }
        if (result != null && result.isOK()) {
            if (cacheFile.exists()) {
                this.safeDelete(cacheFile);
            }
            if (tempFile.renameTo(cacheFile)) {
                return;
            }
            result = new Status(4, "org.eclipse.equinox.p2.discovery.compatibility", NLS.bind((String)Messages.CacheManage_ErrorRenamingCache, (Object[])new String[]{remoteFile.toString(), tempFile.getAbsolutePath(), cacheFile.getAbsolutePath()}));
        }
        if (result != null && result.getSeverity() == 8 || submonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        throw new ProvisionException(result);
    }

    private static class StatefulStream
    extends BufferedOutputStream
    implements IStateful {
        private IStatus status;

        public StatefulStream(OutputStream stream) {
            super(stream);
        }

        public IStatus getStatus() {
            return this.status;
        }

        public void setStatus(IStatus aStatus) {
            this.status = aStatus;
        }
    }
}

