/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.cli;

import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.passage.lic.api.LicensedProduct;
import org.eclipse.passage.lic.api.agreements.AgreementAcceptanceService;
import org.eclipse.passage.lic.api.agreements.AgreementToAccept;
import org.eclipse.passage.lic.cli.BaseOption;
import org.eclipse.passage.lic.cli.CoverageCheckOptionDecision;
import org.eclipse.passage.lic.cli.DecoratedPrompt;
import org.eclipse.passage.lic.cli.Interaction;
import org.eclipse.passage.lic.cli.LicenseCoverageCheckOption;
import org.eclipse.passage.lic.cli.Option;
import org.eclipse.passage.lic.cli.Options;
import org.eclipse.passage.lic.cli.TheOtherSide;
import org.eclipse.passage.lic.equinox.SuppliedFrameworkAware;
import org.eclipse.passage.lic.internal.base.access.Libraries;
import org.eclipse.passage.lic.internal.equinox.access.AgreementAcceptanceDelegate;
import org.eclipse.passage.lic.internal.equinox.access.RegisteredLibraries;

final class OptionAccept
extends BaseOption<LicenseCoverageCheckOption, CoverageCheckOptionDecision> {
    private final Collection<AgreementToAccept> agreements;
    private final Options<AgreementAcceptanceOption, AcceptanceDecision> options;
    private final Libraries libraries;

    OptionAccept(TheOtherSide interaction, Collection<AgreementToAccept> agreements, LicensedProduct product) {
        super(new LicenseCoverageCheckOption.Choise().acceptAgreement(), "Accept", "Read and accept license agreements", interaction);
        this.agreements = agreements;
        this.options = new Options(Arrays.asList(new OptionAccepted(interaction), new OptionDenied(interaction)), interaction);
        this.libraries = new Libraries((Supplier)new RegisteredLibraries(), () -> product);
    }

    @Override
    public CoverageCheckOptionDecision run() {
        new DecoratedPrompt(this.interaction).head(String.format("accept license agreements: %d", this.agreements.size()), "Please read the agreement(s) carefully prior accepting");
        Optional<AgreementAcceptanceService> root = this.acceptanceService();
        if (!root.isPresent()) {
            this.reportInsufficientConfiguration();
            return CoverageCheckOptionDecision.quit;
        }
        AgreementAcceptanceDelegate acceptance = new AgreementAcceptanceDelegate(root.get(), this.libraries);
        this.agreements.forEach(agreement -> this.exposeForAccept((AgreementToAccept)agreement, acceptance));
        return CoverageCheckOptionDecision.reassess;
    }

    private void reportInsufficientConfiguration() {
        this.interaction.prompt("The product lacks configuration, thus license acceptance cannot be performed. \n Contact the vendor.");
    }

    private void exposeForAccept(AgreementToAccept agreement, AgreementAcceptanceDelegate service) {
        try {
            if (this.exposedAndAccepted(agreement)) {
                service.accept(agreement);
            }
        }
        catch (Exception e) {
            this.interaction.swear(e);
        }
    }

    private boolean exposedAndAccepted(AgreementToAccept agreement) {
        this.interaction.prompt(String.format("  ---\n%s\n   ---", agreement.acceptance().name()));
        this.interaction.prompt(new String(agreement.acceptance().content()));
        return AcceptanceDecision.accepted.equals((Object)this.options.promptAndPick().run());
    }

    private Optional<AgreementAcceptanceService> acceptanceService() {
        return new SuppliedFrameworkAware().withFramework(framework -> framework.accessCycleConfiguration().acceptance());
    }

    private static enum AcceptanceDecision {
        accepted,
        denied;

    }

    private static final class AgreementAcceptanceOption
    extends Option.Key.Base {
        private AgreementAcceptanceOption(char key) {
            super(key);
        }

        private static final class Choise {
            private Choise() {
            }

            AgreementAcceptanceOption accept() {
                return new AgreementAcceptanceOption('a');
            }

            AgreementAcceptanceOption decline() {
                return new AgreementAcceptanceOption('n');
            }
        }
    }

    private static final class OptionAccepted
    extends BaseOption<AgreementAcceptanceOption, AcceptanceDecision> {
        OptionAccepted(Interaction interaction) {
            super(new AgreementAcceptanceOption.Choise().accept(), "Accept", "I have read the text of the agreement carefully and ACCEPT all its terms", interaction);
        }

        @Override
        public AcceptanceDecision run() {
            this.interaction.prompt("--> Agreement has just been ACCEPTED");
            return AcceptanceDecision.accepted;
        }
    }

    private static final class OptionDenied
    extends BaseOption<AgreementAcceptanceOption, AcceptanceDecision> {
        OptionDenied(Interaction interaction) {
            super(new AgreementAcceptanceOption.Choise().decline(), "Do not accept", "I DO NOT ACCEPT the agreement", interaction);
        }

        @Override
        public AcceptanceDecision run() {
            this.interaction.prompt("--> Agreementhas just been DENIED");
            return AcceptanceDecision.denied;
        }
    }
}

