/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.jaxws;

import java.io.InputStream;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ElementExtensible;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.schema.SchemaReference;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.eclipse.scout.sdk.core.s.jaxws.JaxWsUtils;
import org.eclipse.scout.sdk.core.util.CharSequenceInputStream;
import org.eclipse.scout.sdk.core.util.CoreUtils;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.Strings;
import org.xml.sax.InputSource;

public class ParsedWsdl {
    private final Map<URI, String> m_referencedResourceUris = new HashMap<URI, String>();
    private final Map<Service, URI> m_services = new HashMap<Service, URI>();
    private final Map<PortType, URI> m_portTypes = new HashMap<PortType, URI>();
    private final Map<Service, Map<String, QName>> m_portTypesByService = new HashMap<Service, Map<String, QName>>();
    private final Map<Service, WebServiceNames> m_namesByService = new HashMap<Service, WebServiceNames>();

    protected ParsedWsdl() {
    }

    public Map<URI, String> getReferencedResources() {
        return Collections.unmodifiableMap(this.m_referencedResourceUris);
    }

    public Map<Service, URI> getWebServices() {
        return Collections.unmodifiableMap(this.m_services);
    }

    public Map<PortType, URI> getPortTypes() {
        return Collections.unmodifiableMap(this.m_portTypes);
    }

    public boolean isEmpty() {
        return this.m_portTypes.isEmpty();
    }

    public Set<PortType> getPortTypes(Service service) {
        Map<String, QName> portTypesByPort = this.m_portTypesByService.get(service);
        if (portTypesByPort == null || portTypesByPort.isEmpty()) {
            return Collections.emptySet();
        }
        return portTypesByPort.values().stream().map(this::getPortType).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public Map<String, QName> getPorts(Service service) {
        Map<String, QName> map = this.m_portTypesByService.get(service);
        if (map == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(map);
    }

    public String getPortName(Service service, PortType portType) {
        QName nameToSearch = portType.getQName();
        return this.getPorts(service).entrySet().stream().filter(entry -> ((QName)entry.getValue()).equals(nameToSearch)).findFirst().map(Map.Entry::getKey).orElse(null);
    }

    public PortType getPortType(QName name) {
        return this.m_portTypes.keySet().stream().filter(candidate -> name.equals(candidate.getQName())).findFirst().orElse(null);
    }

    public Map<Service, WebServiceNames> getServiceNames() {
        return Collections.unmodifiableMap(this.m_namesByService);
    }

    protected void putPortType(PortType portType, URI source) {
        this.m_portTypes.put(portType, source);
    }

    protected void putService(Service service, URI source) {
        this.m_services.put(service, source);
    }

    protected String putReferencedResource(URI absolutePath, URI pathFromWsdlRoot) {
        return this.m_referencedResourceUris.put(absolutePath.normalize(), URLDecoder.decode(pathFromWsdlRoot.toString(), StandardCharsets.UTF_8));
    }

    protected void completeMapping() {
        HashSet<Service> usedServices = new HashSet<Service>(this.m_services.size());
        HashSet<PortType> usedPortTypes = new HashSet<PortType>(this.m_portTypes.size());
        for (Service service : this.m_services.keySet()) {
            Map ports = service.getPorts();
            for (Port port : ports.values()) {
                for (ExtensibilityElement element : ParsedWsdl.extensibilityElementsOf((ElementExtensible)port)) {
                    PortType portType;
                    Binding binding;
                    if (!(element instanceof SOAPAddress) && !(element instanceof SOAP12Address) || !ParsedWsdl.isBindingSupported(binding = port.getBinding()) || (portType = binding.getPortType()) == null) continue;
                    usedServices.add(service);
                    usedPortTypes.add(portType);
                    this.m_portTypesByService.computeIfAbsent(service, k -> new HashMap()).put(port.getName(), portType.getQName());
                }
            }
        }
        this.m_portTypes.keySet().retainAll(usedPortTypes);
        this.m_services.keySet().retainAll(usedServices);
        for (Service s : this.m_services.keySet()) {
            this.m_namesByService.put(s, new WebServiceNames(s.getQName().getLocalPart()));
        }
    }

    protected static Definition parseWsdl(URI documentBase, InputSource wsdl) throws WSDLException {
        WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
        reader.setFeature("javax.wsdl.importDocuments", true);
        reader.setFeature("javax.wsdl.verbose", false);
        String documentBaseUri = null;
        if (documentBase != null) {
            documentBaseUri = documentBase.toString();
        }
        return reader.readWSDL(documentBaseUri, wsdl);
    }

    public static ParsedWsdl create(URI documentBase, CharSequence wsdlContent, boolean loadSchemas) throws WSDLException {
        Definition wsdl = ParsedWsdl.parseWsdl(documentBase, new InputSource((InputStream)new CharSequenceInputStream(wsdlContent, StandardCharsets.UTF_8)));
        return ParsedWsdl.create(wsdl, loadSchemas);
    }

    public static ParsedWsdl create(URI documentBase, InputStream is, boolean loadSchemas) throws WSDLException {
        Definition wsdl = ParsedWsdl.parseWsdl(documentBase, new InputSource((InputStream)Ensure.notNull((Object)is)));
        return ParsedWsdl.create(wsdl, loadSchemas);
    }

    protected static ParsedWsdl create(Definition wsdl, boolean loadSchemas) {
        if (wsdl == null) {
            return null;
        }
        ParsedWsdl result = new ParsedWsdl();
        URI rootDirUri = CoreUtils.getParentURI((URI)URI.create(wsdl.getDocumentBaseURI()));
        ParsedWsdl.parseWsdlRec(wsdl, rootDirUri, URI.create(""), result, loadSchemas);
        result.completeMapping();
        return result;
    }

    protected static boolean isBindingSupported(Binding b) {
        if (b == null) {
            return false;
        }
        List ops = b.getBindingOperations();
        if (ops.isEmpty()) {
            return false;
        }
        for (BindingOperation op : ops) {
            List<ExtensibilityElement> opElements = ParsedWsdl.extensibilityElementsOf((ElementExtensible)op);
            List<ExtensibilityElement> outputElements = ParsedWsdl.extensibilityElementsOf((ElementExtensible)op.getBindingOutput());
            List<ExtensibilityElement> inputElements = ParsedWsdl.extensibilityElementsOf((ElementExtensible)op.getBindingInput());
            ArrayList<ExtensibilityElement> all = new ArrayList<ExtensibilityElement>(Stream.of(opElements, outputElements, inputElements).mapToInt(List::size).sum());
            all.addAll(opElements);
            all.addAll(outputElements);
            all.addAll(inputElements);
            for (ExtensibilityElement element : all) {
                if (!(element instanceof SOAPBody) || !"encoded".equalsIgnoreCase(((SOAPBody)element).getUse())) continue;
                return false;
            }
        }
        return true;
    }

    protected static List<ExtensibilityElement> extensibilityElementsOf(ElementExtensible e) {
        if (e == null) {
            return Collections.emptyList();
        }
        return e.getExtensibilityElements();
    }

    protected static void parseWsdlRec(Definition def, URI rootDefUri, URI relPath, ParsedWsdl collector, boolean loadSchemas) {
        Map imports = def.getImports();
        for (List iv : imports.values()) {
            for (Import i : iv) {
                Definition innerDef = i.getDefinition();
                if (innerDef == null) continue;
                URI pathRelativeToRoot = relPath.resolve(i.getLocationURI());
                URI pathAbsolute = URI.create(innerDef.getDocumentBaseURI());
                collector.putReferencedResource(pathAbsolute, pathRelativeToRoot);
                ParsedWsdl.parseWsdlRec(innerDef, rootDefUri, CoreUtils.getParentURI((URI)pathRelativeToRoot), collector, loadSchemas);
            }
        }
        URI uriOfCurrentDefinition = URI.create(def.getDocumentBaseURI());
        Map services = def.getServices();
        for (Object service : services.values()) {
            collector.putService((Service)service, uriOfCurrentDefinition);
        }
        Map portTypes = def.getPortTypes();
        for (PortType pt : portTypes.values()) {
            collector.putPortType(pt, uriOfCurrentDefinition);
        }
        Types types = def.getTypes();
        if (types == null) {
            return;
        }
        if (loadSchemas) {
            for (ExtensibilityElement e : ParsedWsdl.extensibilityElementsOf((ElementExtensible)types)) {
                if (!(e instanceof Schema)) continue;
                ParsedWsdl.parseSchemasRec((Schema)e, rootDefUri, relPath, collector);
            }
        }
    }

    protected static void parseSchemasRec(Schema s, URI rootUri, URI relPath, ParsedWsdl collector) {
        if (s == null) {
            return;
        }
        Map imports = s.getImports();
        List includes = s.getIncludes();
        if (includes.isEmpty() && imports.isEmpty()) {
            return;
        }
        Collection references = imports.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        references.addAll(includes);
        if (references.isEmpty()) {
            return;
        }
        for (SchemaReference ref : references) {
            URI pathRelativeToRoot;
            String schemaLocationURI = ref.getSchemaLocationURI();
            boolean exists = false;
            if (Strings.isBlank((CharSequence)schemaLocationURI)) {
                pathRelativeToRoot = relPath;
            } else {
                URI pathAbsolute = URI.create(schemaLocationURI);
                if (Strings.hasText((CharSequence)pathAbsolute.getRawFragment())) continue;
                if (pathAbsolute.isAbsolute()) {
                    pathRelativeToRoot = pathAbsolute;
                } else {
                    pathAbsolute = rootUri.resolve(relPath).resolve(pathAbsolute).normalize();
                    pathRelativeToRoot = CoreUtils.relativizeURI((URI)rootUri, (URI)pathAbsolute);
                }
                boolean bl = exists = collector.putReferencedResource(pathAbsolute, pathRelativeToRoot) != null;
            }
            if (exists) continue;
            ParsedWsdl.parseSchemasRec(ref.getReferencedSchema(), rootUri, CoreUtils.getParentURI((URI)pathRelativeToRoot), collector);
        }
    }

    public static class WebServiceNames {
        private final String m_wsBaseName;
        private final String m_wsNameFromWsdl;

        protected WebServiceNames(String wsNameLocalPart) {
            this.m_wsNameFromWsdl = wsNameLocalPart;
            this.m_wsBaseName = WebServiceNames.getBaseName(this.m_wsNameFromWsdl);
        }

        public static String getPortTypeClassName(String portTypeNameFromWsdl) {
            return "I" + WebServiceNames.getBaseName(portTypeNameFromWsdl) + "PortType";
        }

        public static String getEntryPointClassName(String portTypeNameFromWsdl) {
            return WebServiceNames.getBaseName(portTypeNameFromWsdl) + "WebServiceEntryPoint";
        }

        public static String getWebServiceClientClassName(String portTypeNameFromWsdl) {
            return WebServiceNames.getBaseName(portTypeNameFromWsdl) + "WebServiceClient";
        }

        public static String getWebServiceProviderImplClassName(String portTypeNameFromWsdl) {
            return WebServiceNames.getBaseName(portTypeNameFromWsdl) + "WebService";
        }

        public static String getEntryPointDefinitionClassName(String portTypeNameFromWsdl) {
            return "I" + WebServiceNames.getBaseName(portTypeNameFromWsdl) + "WebServiceEntryPointDefinition";
        }

        protected static String getBaseName(String wsNameFromWsdl) {
            return WebServiceNames.wsdlNameToJavaName(JaxWsUtils.removeCommonSuffixes(wsNameFromWsdl));
        }

        protected static String wsdlNameToJavaName(CharSequence name) {
            String[] parts = Pattern.compile("[^a-zA-Z\\d]").split(name);
            return Arrays.stream(parts).map(Strings::capitalize).collect(Collectors.joining());
        }

        public String getWebServiceNameFromWsdl() {
            return this.m_wsNameFromWsdl;
        }

        public String getWebServiceClassName() {
            return this.m_wsBaseName + "Service";
        }
    }
}

