/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.util;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.eclipse.scout.sdk.core.util.Ensure;

public final class FinalValue<VALUE> {
    private static final Object NULL_VALUE = new Object();
    private final AtomicReference<Object> m_value = new AtomicReference<Object>(NULL_VALUE);

    public VALUE get() {
        Object value = this.m_value.get();
        if (value == NULL_VALUE) {
            return null;
        }
        return (VALUE)value;
    }

    public Optional<VALUE> opt() {
        return Optional.ofNullable(this.get());
    }

    public void set(VALUE value) {
        Ensure.same(this.m_value.get(), NULL_VALUE, "Value already set.", new Object[0]);
        this.setIfAbsent(value);
    }

    public VALUE setIfAbsentAndGet(VALUE value) {
        return (VALUE)this.computeIfAbsentAndGet(() -> value);
    }

    public VALUE computeIfAbsentAndGet(Supplier<VALUE> producer) {
        this.computeIfAbsent(producer);
        return (VALUE)this.m_value.get();
    }

    public boolean setIfAbsent(VALUE value) {
        return this.computeIfAbsent(() -> value);
    }

    public boolean computeIfAbsent(Supplier<VALUE> producer) {
        Object value = this.m_value.get();
        return value == NULL_VALUE && this.m_value.compareAndSet(NULL_VALUE, Ensure.notNull(producer).get());
    }

    public boolean isSet() {
        return this.m_value.get() != NULL_VALUE;
    }

    public String toString() {
        String className = FinalValue.class.getSimpleName();
        if (this.isSet()) {
            String content = Objects.toString(this.get());
            return new StringBuilder(className.length() + content.length() + 2).append(className).append('[').append(content).append(']').toString();
        }
        String notSet = "[<not set>]";
        return new StringBuilder(className.length() + notSet.length()).append(className).append(notSet).toString();
    }

    public int hashCode() {
        return Objects.hashCode(this.get());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FinalValue other = (FinalValue)obj;
        return Objects.equals(this.get(), other.get());
    }
}

