/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.value;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.value.ChangeVetoException;
import org.eclipse.core.databinding.observable.value.DecoratingObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangingListener;
import org.eclipse.core.databinding.observable.value.IVetoableValue;
import org.eclipse.core.databinding.observable.value.ValueChangingEvent;
import org.eclipse.core.databinding.observable.value.ValueDiff;

public class DecoratingVetoableValue<T>
extends DecoratingObservableValue<T>
implements IVetoableValue<T> {
    public DecoratingVetoableValue(IObservableValue<T> decorated, boolean disposeDecoratedOnDispose) {
        super(decorated, disposeDecoratedOnDispose);
    }

    @Override
    public void setValue(T value) {
        this.checkRealm();
        Object currentValue = this.getValue();
        ValueDiff diff = Diffs.createValueDiff(currentValue, value);
        boolean okToProceed = this.fireValueChanging(diff);
        if (!okToProceed) {
            throw new ChangeVetoException("Change not permitted");
        }
        super.setValue(value);
    }

    @Override
    public synchronized void addValueChangingListener(IValueChangingListener<T> listener) {
        this.addListener(ValueChangingEvent.TYPE, listener);
    }

    @Override
    public synchronized void removeValueChangingListener(IValueChangingListener<T> listener) {
        this.removeListener(ValueChangingEvent.TYPE, listener);
    }

    protected boolean fireValueChanging(ValueDiff<T> diff) {
        this.checkRealm();
        ValueChangingEvent<T> event = new ValueChangingEvent<T>(this, diff);
        this.fireEvent(event);
        return !event.veto;
    }
}

