/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dstore.core.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dstore.core.java.IRemoteClassInstance;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.Handler;
import org.eclipse.dstore.internal.core.util.DataElementRemover;

public abstract class UpdateHandler
extends Handler {
    protected ArrayList _dataObjects;
    protected ArrayList _classesToSend;

    public UpdateHandler() {
        this.setName("DStore UpdateHandler" + this.getName());
        this._dataObjects = new ArrayList();
        this._classesToSend = new ArrayList();
    }

    public void handle() {
        if (!this._dataObjects.isEmpty() || !this._classesToSend.isEmpty()) {
            this.sendUpdates();
        }
    }

    protected void clean(DataElement object) {
        this.clean(object, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clean(DataElement object, int depth) {
        if (depth > 0 && object != null && object.getNestedSize() > 0) {
            List deletedList = this._dataStore.findDeleted(object);
            int i = 0;
            while (i < deletedList.size()) {
                DataElement child = (DataElement)deletedList.get(i);
                if (child != null && child.isDeleted()) {
                    DataElement parent = child.getParent();
                    DataElementRemover.addToRemovedCount();
                    this.cleanChildren(child);
                    if (child.isSpirit()) {
                        child.delete();
                    }
                    child.clear();
                    if (parent != null) {
                        DataElement dataElement = parent;
                        synchronized (dataElement) {
                            parent.removeNestedData(child);
                        }
                    }
                }
                ++i;
            }
            deletedList.clear();
        }
        this._dataStore.getTempRoot().removeNestedData();
    }

    protected void cleanChildren(DataElement parent) {
        List nestedData = parent.getNestedData();
        if (nestedData != null) {
            int i = 0;
            while (i < nestedData.size()) {
                DataElement child = (DataElement)nestedData.get(i);
                this.cleanChildren(child);
                if (child.isSpirit()) {
                    child.delete();
                }
                child.clear();
                parent.removeNestedData(child);
                ++i;
            }
        }
    }

    public void update(ArrayList objects) {
        int i = 0;
        while (i < objects.size()) {
            this.update((DataElement)objects.get(i));
            ++i;
        }
    }

    public void update(DataElement object) {
        this.update(object, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(DataElement object, boolean immediate) {
        ArrayList arrayList = this._dataObjects;
        synchronized (arrayList) {
            if (immediate) {
                this._dataObjects.add(0, object);
            } else if (!this._dataObjects.contains(object)) {
                this._dataObjects.add(object);
            } else if (this._dataStore != null && object != null && !object.isDeleted() && object.getType().equals("status") && object.getName().equals("done")) {
                this._dataObjects.remove(object);
                this._dataObjects.add(object);
            }
        }
        this.notifyInput();
    }

    public synchronized void waitForInput() {
        if (this._dataObjects.size() == 0 && this._classesToSend.size() == 0) {
            super.waitForInput();
        }
    }

    public abstract void sendUpdates();

    public abstract void updateFile(String var1, byte[] var2, int var3, boolean var4);

    public abstract void updateAppendFile(String var1, byte[] var2, int var3, boolean var4);

    public abstract void updateFile(String var1, byte[] var2, int var3, boolean var4, String var5);

    public abstract void updateAppendFile(String var1, byte[] var2, int var3, boolean var4, String var5);

    public abstract void requestClass(String var1);

    public abstract void sendKeepAliveRequest();

    public abstract void updateClassInstance(IRemoteClassInstance var1, String var2);

    public abstract void sendClass(String var1);

    public abstract void sendClass(String var1, String var2);

    public abstract void sendKeepAliveConfirmation();
}

