/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.views.preferences;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.internal.lttng2.control.core.LttngProfileManager;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.preferences.LTTngProfileViewer;
import org.eclipse.tracecompass.tmf.ui.dialog.DirectoryDialogFactory;
import org.eclipse.tracecompass.tmf.ui.dialog.TmfFileDialogFactory;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class ControlRemoteProfilesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.eclipse.tracecompass.internal.lttng2.control.ui.views.preferences.ControlRemoteProfilesPreferencePage";
    private CheckboxTreeViewer fFolderViewer;
    private Button fDeleteButton = null;
    private Button fImportButton = null;
    private Button fExportButton = null;

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(2, false));
        FilteredTree filteredTree = new FilteredTree(composite, 68354, new PatternFilter(), true){

            protected TreeViewer doCreateTreeViewer(Composite aParent, int style) {
                ControlRemoteProfilesPreferencePage.this.fFolderViewer = LTTngProfileViewer.createLTTngProfileViewer(aParent, style);
                return ControlRemoteProfilesPreferencePage.this.fFolderViewer;
            }
        };
        filteredTree.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite buttonComposite = this.createVerticalButtonBar(composite);
        buttonComposite.setLayout((Layout)new GridLayout());
        buttonComposite.setLayoutData((Object)new GridData(2, 1, false, false));
        this.fFolderViewer.addCheckStateListener(event -> this.enableButtons());
        return composite;
    }

    private Composite createVerticalButtonBar(Composite composite) {
        Composite buttonComposite = new Composite(composite, 0);
        this.fDeleteButton = ControlRemoteProfilesPreferencePage.createVerticalButton(buttonComposite, Messages.TraceControl_DeleteButtonText);
        this.fDeleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] checkedElements = ControlRemoteProfilesPreferencePage.this.fFolderViewer.getCheckedElements();
                StringBuffer files = new StringBuffer();
                Object[] objectArray = checkedElements;
                int n = checkedElements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    if (element instanceof File) {
                        files.append(((File)element).toString()).append("\n");
                    }
                    ++n2;
                }
                boolean delete = MessageDialog.openConfirm((Shell)ControlRemoteProfilesPreferencePage.this.getShell(), (String)Messages.TraceControl_DeleteProfileTitle, (String)(Messages.TraceControl_DeleteQuery + "\n" + files.toString()));
                if (!delete) {
                    return;
                }
                Object[] objectArray2 = checkedElements;
                int n3 = checkedElements.length;
                n = 0;
                while (n < n3) {
                    Object element = objectArray2[n];
                    if (element instanceof File) {
                        File sourceFile = (File)element;
                        Path source = FileSystems.getDefault().getPath(sourceFile.getAbsolutePath(), new String[0]);
                        try {
                            Files.delete(source);
                        }
                        catch (IOException e1) {
                            MessageDialog.openError((Shell)ControlRemoteProfilesPreferencePage.this.getShell(), (String)Messages.TraceControl_DeleteProfileTitle, (String)("Error deleting profile:\n" + e1.toString()));
                        }
                    }
                    ++n;
                }
                ControlRemoteProfilesPreferencePage.this.fFolderViewer.setInput((Object)LTTngProfileViewer.getViewerInput());
                ControlRemoteProfilesPreferencePage.this.enableButtons();
            }
        });
        this.fImportButton = ControlRemoteProfilesPreferencePage.createVerticalButton(buttonComposite, Messages.TraceControl_ImportButtonText);
        this.fExportButton = ControlRemoteProfilesPreferencePage.createVerticalButton(buttonComposite, Messages.TraceControl_ExportButtonText);
        this.fImportButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = TmfFileDialogFactory.create((Shell)Display.getCurrent().getActiveShell(), (int)4096);
                dialog.setText(Messages.TraceControl_ImportProfileTitle);
                dialog.setFilterExtensions(new String[]{"*.lttng", "*"});
                String sourceFile = dialog.open();
                if (sourceFile != null) {
                    Path source = FileSystems.getDefault().getPath(sourceFile, new String[0]);
                    Path destPath = FileSystems.getDefault().getPath(LttngProfileManager.getProfilePath().toFile().toString(), new String[0]);
                    ControlRemoteProfilesPreferencePage.this.copyProfileFile(source, destPath, Messages.TraceControl_ImportProfileTitle);
                    ControlRemoteProfilesPreferencePage.this.fFolderViewer.setInput((Object)LTTngProfileViewer.getViewerInput());
                }
            }
        });
        this.fExportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = DirectoryDialogFactory.create((Shell)Display.getCurrent().getActiveShell());
                dialog.setText(Messages.TraceControl_ExportProfileTitle);
                String path = dialog.open();
                if (path != null) {
                    Object[] checkedElements;
                    Object[] objectArray = checkedElements = ControlRemoteProfilesPreferencePage.this.fFolderViewer.getCheckedElements();
                    int n = checkedElements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object element = objectArray[n2];
                        if (element instanceof File) {
                            File sourceFile = (File)element;
                            Path source = FileSystems.getDefault().getPath(sourceFile.getAbsolutePath(), new String[0]);
                            Path destPath = FileSystems.getDefault().getPath(path, new String[0]);
                            ControlRemoteProfilesPreferencePage.this.copyProfileFile(source, destPath, Messages.TraceControl_ExportProfileTitle);
                        }
                        ++n2;
                    }
                }
            }
        });
        this.enableButtons();
        return buttonComposite;
    }

    private static Button createVerticalButton(Composite parent, String text) {
        Button button = new Button(parent, 8);
        button.setLayoutData((Object)new GridData(256));
        button.setText(text);
        return button;
    }

    private void enableButtons() {
        Object[] checked = this.fFolderViewer.getCheckedElements();
        boolean enabled = checked != null && checked.length > 0;
        this.fDeleteButton.setEnabled(enabled);
        this.fExportButton.setEnabled(enabled);
        this.fImportButton.setEnabled(true);
    }

    private void copyProfileFile(Path source, Path destPath, String errorTitle) {
        boolean overwrite;
        Path destFile = destPath.resolve(source.getFileName());
        if (destFile.toFile().exists() && !(overwrite = MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.TraceControl_ProfileAlreadyExists, (String)NLS.bind((String)Messages.TraceControl_OverwriteQuery, (Object)destFile.getFileName())))) {
            return;
        }
        try {
            Files.copy(source, destFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e1) {
            MessageDialog.openError((Shell)this.getShell(), (String)errorTitle, (String)("Error copying profile:\n" + e1.toString()));
        }
    }
}

