/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.chart.ui.consumer;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.resolver.IStringResolver;
import org.eclipse.tracecompass.internal.tmf.chart.core.consumer.IDataConsumer;

public class ScatterStringConsumer
implements IDataConsumer {
    private final IStringResolver<Object> fResolver;
    private final BiMap<String, Integer> fMap;
    private final List<String> fList = new ArrayList<String>();

    public ScatterStringConsumer(IStringResolver<Object> resolver) {
        this.fResolver = resolver;
        this.fMap = HashBiMap.create();
    }

    public ScatterStringConsumer(IStringResolver<Object> resolver, BiMap<String, Integer> map) {
        this.fResolver = resolver;
        this.fMap = map;
    }

    public boolean test(Object obj) {
        return true;
    }

    public void accept(@NonNull Object obj) {
        String str = (String)this.fResolver.getMapper().apply(obj);
        if (str == null) {
            str = "?";
        }
        this.fList.add(str);
        this.fMap.putIfAbsent((Object)str, (Object)this.fMap.size());
    }

    public List<String> getList() {
        return ImmutableList.copyOf(this.fList);
    }

    public BiMap<String, Integer> getMap() {
        return ImmutableBiMap.copyOf(this.fMap);
    }
}

