/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.tests.project.model;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.tracecompass.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfAnalysisElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfAnalysisOutputElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfCommonProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.tracecompass.tmf.ui.tests.shared.IWaitCondition;
import org.eclipse.tracecompass.tmf.ui.tests.shared.ProjectModelTestData;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitTimeoutException;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProjectModelOutputTest {
    private TmfProjectElement fixture;

    @Before
    public void setUp() {
        try {
            this.fixture = ProjectModelTestData.getFilledProject();
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @After
    public void cleanUp() {
        ProjectModelTestData.deleteProject(this.fixture);
    }

    private TmfTraceElement getTraceElement() {
        TmfTraceElement trace = null;
        TmfTraceFolder tracesFolder = this.fixture.getTracesFolder();
        Assert.assertNotNull((Object)tracesFolder);
        for (ITmfProjectModelElement element : tracesFolder.getChildren()) {
            TmfTraceElement traceElement;
            if (!(element instanceof TmfTraceElement) || !(traceElement = (TmfTraceElement)element).getName().equals(ProjectModelTestData.getTraceName())) continue;
            trace = traceElement;
        }
        Assert.assertNotNull(trace);
        return trace;
    }

    private TmfAnalysisElement getTestAnalysisUi() {
        TmfTraceElement trace = this.getTraceElement();
        List analysisList = trace.getAvailableAnalysis();
        Assert.assertFalse((boolean)analysisList.isEmpty());
        TmfAnalysisElement analysis = null;
        for (TmfAnalysisElement analysisElement : analysisList) {
            if (!analysisElement.getAnalysisId().equals("org.eclipse.linuxtools.tmf.ui.tests.test")) continue;
            analysis = analysisElement;
        }
        Assert.assertNotNull(analysis);
        return analysis;
    }

    @Test
    public void testListOutputs() {
        TmfAnalysisElement analysis = this.getTestAnalysisUi();
        TmfCommonProjectElement traceElement = analysis.getParent().getParent();
        analysis.activateParentTrace();
        try {
            ProjectModelTestData.delayUntilTraceOpened(traceElement);
        }
        catch (WaitTimeoutException e) {
            Assert.fail((String)"The analysis parent did not open in a reasonable time");
        }
        WaitUtils.waitUntil(new ConditionTraceChildrenElements((ITmfProjectModelElement)analysis, 1));
        List outputList = analysis.getAvailableOutputs();
        Assert.assertFalse((boolean)outputList.isEmpty());
        boolean found = false;
        for (ITmfProjectModelElement element : outputList) {
            TmfAnalysisOutputElement outputElement;
            if (!(element instanceof TmfAnalysisOutputElement) || !(outputElement = (TmfAnalysisOutputElement)element).getName().equals("Test Analysis View")) continue;
            found = true;
        }
        Assert.assertTrue((boolean)found);
        traceElement.closeEditors();
    }

    @Test
    public void testOpenView() {
        TmfAnalysisElement analysis = this.getTestAnalysisUi();
        TmfCommonProjectElement traceElement = analysis.getParent().getParent();
        analysis.activateParentTrace();
        try {
            ProjectModelTestData.delayUntilTraceOpened(traceElement);
        }
        catch (WaitTimeoutException e) {
            Assert.fail((String)"The analysis parent did not open in a reasonable time");
        }
        WaitUtils.waitUntil(new ConditionTraceChildrenElements((ITmfProjectModelElement)analysis, 1));
        List outputList = analysis.getAvailableOutputs();
        Assert.assertFalse((boolean)outputList.isEmpty());
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchPage activePage = wb.getActiveWorkbenchWindow().getActivePage();
        IViewPart view = activePage.findView("org.eclipse.linuxtools.tmf.ui.tests.testAnalysisView");
        if (view != null) {
            activePage.hideView(view);
        }
        TmfAnalysisOutputElement outputElement = null;
        for (ITmfProjectModelElement element : outputList) {
            TmfAnalysisOutputElement el;
            if (!(element instanceof TmfAnalysisOutputElement) || !(el = (TmfAnalysisOutputElement)element).getName().equals("Test Analysis View")) continue;
            outputElement = el;
        }
        Assert.assertNotNull(outputElement);
        outputElement.outputAnalysis();
        WaitUtils.waitUntil(workbenchPage -> workbenchPage.findView("org.eclipse.linuxtools.tmf.ui.tests.testAnalysisView") != null, activePage, "Test Analysis View did not open");
        traceElement.closeEditors();
    }

    private static final class ConditionTraceChildrenElements
    implements IWaitCondition {
        private final ITmfProjectModelElement fProjectElement;
        private int fCurNumChildren;
        private int fExpectedChildNum;

        private ConditionTraceChildrenElements(ITmfProjectModelElement projectElement, int childNum) {
            this.fProjectElement = projectElement;
            this.fExpectedChildNum = childNum;
        }

        @Override
        public boolean test() throws Exception {
            this.fCurNumChildren = this.fProjectElement.getChildren().size();
            return this.fCurNumChildren == this.fExpectedChildNum;
        }

        @Override
        public String getFailureMessage() {
            return "Timeout while waiting for " + String.valueOf(this.fProjectElement) + " to have number of children. Expected: " + this.fExpectedChildNum + " Actual: " + this.fCurNumChildren;
        }
    }
}

