/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.util.math;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.virgo.util.math.ConcurrentHashSet;
import org.eclipse.virgo.util.math.ConcurrentRelation;
import org.eclipse.virgo.util.math.ConcurrentSet;

public final class ConcurrentMapRelation<X, Y>
implements ConcurrentRelation<X, Y> {
    private final ConcurrentMap<X, ConcurrentSet<Y>> rel = new ConcurrentHashMap<X, ConcurrentSet<Y>>();

    @Override
    public boolean add(X x, Y y) {
        this.ensure(x);
        return ((ConcurrentSet)this.rel.get(x)).add(y);
    }

    @Override
    public boolean contains(X x, Y y) {
        this.ensure(x);
        return ((ConcurrentSet)this.rel.get(x)).contains(y);
    }

    @Override
    public Set<X> dom() {
        return this.rel.keySet();
    }

    @Override
    public Set<Y> ran() {
        ConcurrentHashSet range = new ConcurrentHashSet();
        for (ConcurrentSet rangeSet : this.rel.values()) {
            range.addAll(rangeSet);
        }
        return range;
    }

    @Override
    public boolean remove(X x, Y y) {
        this.ensure(x);
        return ((ConcurrentSet)this.rel.get(x)).remove(y);
    }

    private void ensure(X x) {
        if (!this.rel.containsKey(x)) {
            this.rel.putIfAbsent(x, new ConcurrentHashSet());
        }
    }

    @Override
    public Set<Y> relationalImage(Set<X> xset) {
        ConcurrentHashSet rImg = new ConcurrentHashSet();
        for (X x : xset) {
            if (!this.rel.containsKey(x)) continue;
            rImg.addAll((Collection)this.rel.get(x));
        }
        return rImg;
    }

    @Override
    public void domSubtract(Set<X> xset) {
        for (X x : xset) {
            this.rel.remove(x);
        }
    }
}

