/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.osgi.launcher;

import java.util.Set;
import org.eclipse.virgo.osgi.launcher.ServiceLoader;
import org.osgi.framework.launch.FrameworkFactory;

final class FrameworkFactoryLocator {
    FrameworkFactoryLocator() {
    }

    public static FrameworkFactory createFrameworkFactory() {
        ServiceLoader<FrameworkFactory> factoryLoader = ServiceLoader.load(FrameworkFactory.class);
        return FrameworkFactoryLocator.uniqueServiceFromLoader(factoryLoader);
    }

    private static <T> T uniqueServiceFromLoader(ServiceLoader<T> factoryLoader) {
        Set<T> services = factoryLoader.get(FrameworkFactory.class.getClassLoader());
        if (services.isEmpty()) {
            throw new IllegalStateException("No FrameworkFactory services found.");
        }
        if (services.size() > 1) {
            throw new IllegalStateException("Unable to locate unique FrameworkFactory. Found " + services.size() + " factories. Do you have multiple OSGi implementations on your classpath?");
        }
        return services.iterator().next();
    }
}

