/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.userregion.internal.quasi;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiBundle;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiExportPackage;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiImportPackage;
import org.eclipse.virgo.kernel.userregion.internal.quasi.StandardQuasiBundle;
import org.eclipse.virgo.kernel.userregion.internal.quasi.StandardQuasiImportPackage;
import org.eclipse.virgo.kernel.userregion.internal.quasi.StandardQuasiParameterised;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.osgi.framework.Version;

public class StandardQuasiExportPackage
extends StandardQuasiParameterised
implements QuasiExportPackage {
    private final ExportPackageDescription exportPackageDescription;
    private final QuasiBundle exporter;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

    public StandardQuasiExportPackage(ExportPackageDescription exportPackageDescription, QuasiBundle exporter) {
        super(exportPackageDescription);
        this.exportPackageDescription = exportPackageDescription;
        this.exporter = exporter;
    }

    private StateHelper getStateHelper() {
        return ((StandardQuasiBundle)this.exporter).getStateHelper();
    }

    public String getPackageName() {
        return this.exportPackageDescription.getName();
    }

    public Version getVersion() {
        return this.exportPackageDescription.getVersion();
    }

    public QuasiBundle getExportingBundle() {
        return this.exporter;
    }

    public List<QuasiImportPackage> getConsumers() {
        ArrayList<QuasiImportPackage> consumers = new ArrayList<QuasiImportPackage>();
        StateHelper stateHelper = this.getStateHelper();
        BundleDescription[] bundleDescriptionArray = this.getDependentBundles(stateHelper);
        int n = bundleDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription dependentBundle = bundleDescriptionArray[n2];
            if (this.isConsumer(dependentBundle)) {
                this.addConsumer(dependentBundle, consumers, stateHelper);
            }
            ++n2;
        }
        return consumers;
    }

    private BundleDescription[] getDependentBundles(StateHelper stateHelper) {
        return stateHelper.getDependentBundles(new BundleDescription[]{this.exportPackageDescription.getExporter()});
    }

    private boolean isConsumer(BundleDescription dependentBundle) {
        ImportPackageSpecification[] importedPackages;
        ImportPackageSpecification[] importPackageSpecificationArray = importedPackages = dependentBundle.getImportPackages();
        int n = importedPackages.length;
        int n2 = 0;
        while (n2 < n) {
            ImportPackageSpecification importedPackage = importPackageSpecificationArray[n2];
            if (this.exportPackageDescription.equals(importedPackage.getSupplier())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void addConsumer(BundleDescription dependentBundle, List<QuasiImportPackage> consumers, StateHelper stateHelper) {
        ImportPackageSpecification[] dependentImportPackages;
        ImportPackageSpecification[] importPackageSpecificationArray = dependentImportPackages = dependentBundle.getImportPackages();
        int n = dependentImportPackages.length;
        int n2 = 0;
        while (n2 < n) {
            ImportPackageSpecification dependentImportPackage = importPackageSpecificationArray[n2];
            if (this.matches(dependentImportPackage, this.exportPackageDescription)) {
                consumers.add(new StandardQuasiImportPackage(dependentImportPackage, new StandardQuasiBundle(dependentBundle, null, stateHelper)));
                break;
            }
            ++n2;
        }
    }

    private boolean matches(ImportPackageSpecification i, ExportPackageDescription e) {
        return i.isSatisfiedBy((BaseDescription)e);
    }

    @Override
    public String toString() {
        return "StandardQuasiExportPackage(" + this.getPackageName() + ", " + this.getVersion().toString() + ", " + super.toString() + ")";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.exportPackageDescription == null ? 0 : this.exportPackageDescription.hashCode());
        result = 31 * result + (this.exporter == null ? 0 : this.exporter.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StandardQuasiExportPackage other = (StandardQuasiExportPackage)obj;
        if (this.exportPackageDescription == null ? other.exportPackageDescription != null : !this.exportPackageDescription.equals(other.exportPackageDescription)) {
            return false;
        }
        return !(this.exporter == null ? other.exporter != null : !this.exporter.equals(other.exporter));
    }

    public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
        return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    }

    static {
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.userregion.internal.quasi.StandardQuasiExportPackage");
    }
}

