/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.userregionfactory;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.equinox.region.RegionFilter;
import org.eclipse.equinox.region.RegionFilterBuilder;
import org.eclipse.virgo.kernel.core.Shutdown;
import org.eclipse.virgo.kernel.osgi.framework.OsgiFrameworkUtils;
import org.eclipse.virgo.kernel.osgi.framework.OsgiServiceHolder;
import org.eclipse.virgo.kernel.userregionfactory.PackageImportWildcardExpander;
import org.eclipse.virgo.kernel.userregionfactory.UserRegionFactoryLogEvents;
import org.eclipse.virgo.kernel.userregionfactory.UserRegionFactoryParserLogger;
import org.eclipse.virgo.medic.dump.DumpGenerator;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.osgi.launcher.parser.ArgumentParser;
import org.eclipse.virgo.osgi.launcher.parser.BundleEntry;
import org.eclipse.virgo.util.osgi.ServiceRegistrationTracker;
import org.eclipse.virgo.util.osgi.VersionRange;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.eclipse.virgo.util.osgi.manifest.BundleManifestFactory;
import org.eclipse.virgo.util.osgi.manifest.ImportedPackage;
import org.eclipse.virgo.util.osgi.manifest.RequireBundle;
import org.eclipse.virgo.util.osgi.manifest.RequiredBundle;
import org.eclipse.virgo.util.osgi.manifest.parse.ParserLogger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public final class Activator
implements BundleActivator {
    private static final String KERNEL_REGION_NAME = "org.eclipse.equinox.region.kernel";
    private static final String CLASS_LIST_SEPARATOR = ",";
    private static final long MAX_SECONDS_WAIT_FOR_SERVICE = 30L;
    private static final long MAX_MILLIS_WAIT_FOR_SERVICE = TimeUnit.SECONDS.toMillis(30L);
    private static final String USER_REGION_CONFIGURATION_PID = "org.eclipse.virgo.kernel.userregion";
    private static final String USER_REGION_BASE_BUNDLES_PROPERTY = "baseBundles";
    private static final String USER_REGION_PACKAGE_IMPORTS_PROPERTY = "packageImports";
    private static final String USER_REGION_SERVICE_IMPORTS_PROPERTY = "serviceImports";
    private static final String USER_REGION_BUNDLE_IMPORTS_PROPERTY = "bundleImports";
    private static final String USER_REGION_SERVICE_EXPORTS_PROPERTY = "serviceExports";
    private static final String USER_REGION_BUNDLE_CONTEXT_SERVICE_PROPERTY = "org.eclipse.virgo.kernel.regionContext";
    private static final String REGION_USER = "org.eclipse.virgo.region.user";
    private static final String EVENT_REGION_STARTING = "org/eclipse/virgo/kernel/region/STARTING";
    private static final String EVENT_PROPERTY_REGION_BUNDLECONTEXT = "region.bundleContext";
    private static final String WILDCARD = "*";
    private EventAdmin eventAdmin;
    private String regionBundles;
    private String regionPackageImports;
    private String regionServiceImports;
    private String regionBundleImports;
    private String regionServiceExports;
    private BundleContext bundleContext;
    private final ArgumentParser parser = new ArgumentParser();
    private final ServiceRegistrationTracker tracker = new ServiceRegistrationTracker();
    private DumpGenerator dumpGenerator;

    public void start(BundleContext bundleContext) throws Exception {
        this.bundleContext = bundleContext;
        this.dumpGenerator = Activator.getPotentiallyDelayedService(bundleContext, DumpGenerator.class);
        RegionDigraph regionDigraph = Activator.getPotentiallyDelayedService(bundleContext, RegionDigraph.class);
        this.eventAdmin = Activator.getPotentiallyDelayedService(bundleContext, EventAdmin.class);
        ConfigurationAdmin configAdmin = Activator.getPotentiallyDelayedService(bundleContext, ConfigurationAdmin.class);
        EventLogger eventLogger = Activator.getPotentiallyDelayedService(bundleContext, EventLogger.class);
        Shutdown shutdown = Activator.getPotentiallyDelayedService(bundleContext, Shutdown.class);
        this.getRegionConfiguration(configAdmin, eventLogger, shutdown);
        this.createUserRegion(regionDigraph, eventLogger);
    }

    private void getRegionConfiguration(ConfigurationAdmin configAdmin, EventLogger eventLogger, Shutdown shutdown) {
        try {
            Configuration config = configAdmin.getConfiguration(USER_REGION_CONFIGURATION_PID, null);
            Dictionary properties = config.getProperties();
            if (properties != null) {
                this.regionBundles = (String)properties.get(USER_REGION_BASE_BUNDLES_PROPERTY);
                this.regionPackageImports = (String)properties.get(USER_REGION_PACKAGE_IMPORTS_PROPERTY);
                this.regionServiceImports = (String)properties.get(USER_REGION_SERVICE_IMPORTS_PROPERTY);
                this.regionBundleImports = (String)properties.get(USER_REGION_BUNDLE_IMPORTS_PROPERTY);
                this.regionServiceExports = (String)properties.get(USER_REGION_SERVICE_EXPORTS_PROPERTY);
            } else {
                eventLogger.log((LogEvent)UserRegionFactoryLogEvents.USER_REGION_CONFIGURATION_UNAVAILABLE, new Object[0]);
                shutdown.immediateShutdown();
            }
        }
        catch (Exception e) {
            eventLogger.log((LogEvent)UserRegionFactoryLogEvents.USER_REGION_CONFIGURATION_UNAVAILABLE, (Throwable)e, new Object[0]);
            shutdown.immediateShutdown();
        }
    }

    private void createUserRegion(RegionDigraph regionDigraph, EventLogger eventLogger) throws BundleException, InvalidSyntaxException {
        BundleContext systemBundleContext = this.getSystemBundleContext();
        Bundle userRegionFactoryBundle = this.bundleContext.getBundle();
        Region kernelRegion = this.getKernelRegion(regionDigraph);
        kernelRegion.removeBundle(userRegionFactoryBundle);
        Region userRegion = regionDigraph.createRegion(REGION_USER);
        userRegion.addBundle(userRegionFactoryBundle);
        RegionFilter kernelFilter = this.createKernelFilter(regionDigraph, systemBundleContext, eventLogger);
        userRegion.connectRegion(kernelRegion, kernelFilter);
        RegionFilter userRegionFilter = this.createUserRegionFilter(regionDigraph);
        kernelRegion.connectRegion(userRegion, userRegionFilter);
        this.notifyUserRegionStarting(this.bundleContext);
        this.initialiseUserRegionBundles(userRegion);
        this.registerRegionService(userRegion);
        this.publishUserRegionBundleContext(this.bundleContext);
    }

    private RegionFilter createUserRegionFilter(RegionDigraph digraph) throws InvalidSyntaxException {
        Collection<String> serviceFilters = Activator.classesToFilter(this.regionServiceExports);
        RegionFilterBuilder builder = digraph.createRegionFilterBuilder();
        for (String filter : serviceFilters) {
            builder.allow("org.eclipse.equinox.allow.service", filter);
        }
        return builder.build();
    }

    private Region getKernelRegion(RegionDigraph regionDigraph) {
        return regionDigraph.getRegion(KERNEL_REGION_NAME);
    }

    private RegionFilter createKernelFilter(RegionDigraph digraph, BundleContext systemBundleContext, EventLogger eventLogger) throws BundleException, InvalidSyntaxException {
        RegionFilterBuilder builder = digraph.createRegionFilterBuilder();
        Collection<String> allowedBundles = this.allowImportedBundles(eventLogger);
        for (String filter : allowedBundles) {
            builder.allow("org.eclipse.equinox.allow.bundle", filter);
        }
        Collection<String> allowedPackages = this.createUserRegionPackageImportPolicy(systemBundleContext, eventLogger);
        for (String filter : allowedPackages) {
            builder.allow("osgi.wiring.package", filter);
        }
        Collection<String> allowedServices = Activator.classesToFilter(this.regionServiceImports);
        for (String filter : allowedServices) {
            builder.allow("org.eclipse.equinox.allow.service", filter);
        }
        return builder.build();
    }

    private Collection<String> allowImportedBundles(EventLogger eventLogger) {
        String userRegionBundleImports = this.regionBundleImports != null ? this.regionBundleImports : this.bundleContext.getProperty(USER_REGION_BUNDLE_IMPORTS_PROPERTY);
        RequireBundle bundleImportsAsRequireBundle = this.representBundleImportsAsRequireBundle(userRegionBundleImports, eventLogger);
        return Activator.importBundleToFilter(bundleImportsAsRequireBundle.getRequiredBundles());
    }

    private RequireBundle representBundleImportsAsRequireBundle(String userRegionBundleImportsProperty, EventLogger eventLogger) {
        Hashtable<String, String> headers = new Hashtable<String, String>();
        ((Dictionary)headers).put("Require-Bundle", userRegionBundleImportsProperty);
        BundleManifest manifest = BundleManifestFactory.createBundleManifest(headers, (ParserLogger)new UserRegionFactoryParserLogger(eventLogger));
        return manifest.getRequireBundle();
    }

    private static Collection<String> importBundleToFilter(List<RequiredBundle> importedBundles) {
        if (importedBundles == null || importedBundles.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(importedBundles.size());
        for (RequiredBundle importedBundle : importedBundles) {
            StringBuilder f = new StringBuilder();
            f.append("(&(").append("org.eclipse.equinox.allow.bundle").append('=').append(importedBundle.getBundleSymbolicName()).append(')');
            Activator.addRange("bundle-version", importedBundle.getBundleVersion(), f);
            f.append(')');
            result.add(f.toString());
        }
        return result;
    }

    private static Collection<String> importPackageToFilter(String importList) {
        if (importList == null || importList.isEmpty()) {
            return Collections.emptyList();
        }
        if (importList.contains(WILDCARD)) {
            throw new IllegalArgumentException("Wildcards not supported in region imports: '" + importList + "'");
        }
        BundleManifest manifest = BundleManifestFactory.createBundleManifest();
        manifest.setHeader("Import-Package", importList);
        List list = manifest.getImportPackage().getImportedPackages();
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> filters = new ArrayList<String>(list.size());
        for (ImportedPackage importedPackage : list) {
            StringBuilder f = new StringBuilder();
            f.append("(&(").append("osgi.wiring.package").append('=').append(importedPackage.getPackageName()).append(')');
            Map attrs = importedPackage.getAttributes();
            for (Map.Entry attr : attrs.entrySet()) {
                if ("version".equals(attr.getKey()) || "bundle-version".equals(attr.getKey())) {
                    Activator.addRange((String)attr.getKey(), new VersionRange((String)attr.getValue()), f);
                    continue;
                }
                f.append('(').append((String)attr.getKey()).append('=').append((String)attr.getValue()).append(')');
            }
            f.append(')');
            filters.add(f.toString());
        }
        return filters;
    }

    private static void addRange(String key, VersionRange range, StringBuilder f) {
        if (range.isFloorInclusive()) {
            f.append(String.valueOf('(') + key + ">=" + range.getFloor() + ')');
        } else {
            f.append("(!(" + key + "<=" + range.getFloor() + "))");
        }
        Version ceiling = range.getCeiling();
        if (ceiling != null) {
            if (range.isCeilingInclusive()) {
                f.append(String.valueOf('(') + key + "<=" + ceiling + ')');
            } else {
                f.append("(!(" + key + ">=" + ceiling + "))");
            }
        }
    }

    private static Collection<String> classesToFilter(String classList) {
        if (classList == null) {
            return Collections.emptyList();
        }
        String[] classes = classList.split(CLASS_LIST_SEPARATOR);
        if (classes.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(classes.length);
        String[] stringArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            String className = stringArray[n2];
            result.add("(objectClass=" + className + ")");
            ++n2;
        }
        return result;
    }

    private Collection<String> createUserRegionPackageImportPolicy(BundleContext systemBundleContext, EventLogger eventLogger) {
        String userRegionImportsProperty = this.regionPackageImports != null ? this.regionPackageImports : this.bundleContext.getProperty(USER_REGION_PACKAGE_IMPORTS_PROPERTY);
        String expandedUserRegionImportsProperty = null;
        if (userRegionImportsProperty != null) {
            expandedUserRegionImportsProperty = PackageImportWildcardExpander.expandPackageImportsWildcards(userRegionImportsProperty, systemBundleContext, eventLogger);
        }
        return Activator.importPackageToFilter(expandedUserRegionImportsProperty);
    }

    private BundleContext getSystemBundleContext() {
        return this.bundleContext.getBundle(0L).getBundleContext();
    }

    private void notifyUserRegionStarting(BundleContext userRegionBundleContext) {
        HashMap<String, BundleContext> properties = new HashMap<String, BundleContext>();
        properties.put(EVENT_PROPERTY_REGION_BUNDLECONTEXT, userRegionBundleContext);
        this.eventAdmin.sendEvent(new Event(EVENT_REGION_STARTING, properties));
    }

    private void initialiseUserRegionBundles(Region userRegion) throws BundleException {
        String userRegionBundlesProperty;
        String string = userRegionBundlesProperty = this.regionBundles != null ? this.regionBundles : this.bundleContext.getProperty(USER_REGION_BASE_BUNDLES_PROPERTY);
        if (userRegionBundlesProperty != null) {
            ArrayList<Bundle> bundlesToStart = new ArrayList<Bundle>();
            BundleEntry[] bundleEntryArray = this.parser.parseBundleEntries(userRegionBundlesProperty);
            int n = bundleEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                BundleEntry entry = bundleEntryArray[n2];
                URI uri = entry.getURI();
                Bundle bundle = userRegion.installBundle(uri.toString());
                if (entry.isAutoStart()) {
                    bundlesToStart.add(bundle);
                }
                ++n2;
            }
            for (Bundle bundle : bundlesToStart) {
                try {
                    bundle.start();
                }
                catch (BundleException e) {
                    this.dumpGenerator.generateDump("User region bundle failed to start", new Throwable[]{e});
                    throw new BundleException("Failed to start bundle " + bundle.getSymbolicName() + " " + bundle.getVersion(), (Throwable)e);
                }
            }
        }
    }

    private void registerRegionService(Region region) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("org.eclipse.virgo.kernel.region.name", region.getName());
        this.tracker.track(this.bundleContext.registerService(Region.class, (Object)region, props));
    }

    private void publishUserRegionBundleContext(BundleContext userRegionBundleContext) {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put(USER_REGION_BUNDLE_CONTEXT_SERVICE_PROPERTY, "true");
        this.bundleContext.registerService(BundleContext.class, (Object)userRegionBundleContext, properties);
    }

    public void stop(BundleContext context) throws Exception {
    }

    private static <T> T getPotentiallyDelayedService(BundleContext context, Class<T> serviceClass) throws TimeoutException, InterruptedException {
        Object service = null;
        long millisWaited = 0L;
        while (service == null && millisWaited <= MAX_MILLIS_WAIT_FOR_SERVICE) {
            try {
                OsgiServiceHolder serviceHolder = OsgiFrameworkUtils.getService((BundleContext)context, serviceClass);
                if (serviceHolder != null) {
                    service = serviceHolder.getService();
                    continue;
                }
                millisWaited += Activator.sleepABitMore();
            }
            catch (IllegalStateException illegalStateException) {}
        }
        if (service == null) {
            throw new TimeoutException(serviceClass.getName());
        }
        return (T)service;
    }

    private static long sleepABitMore() throws InterruptedException {
        long before = System.currentTimeMillis();
        Thread.sleep(100L);
        return System.currentTimeMillis() - before;
    }
}

